<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class BayplanController extends Controller
{
    /**
     * Display the bayplan visualization page
     */
    public function index()
    {
        $containers = session('containers', []);
        $voyage = session('voyage', []);
        
        // Filter containers that have position data
        $positionedContainers = array_filter($containers, function($container) {
            return !empty($container['bay']) && !empty($container['row']) && !empty($container['tier']);
        });

        
        // Calculate simple statistics
        $stats = [
            'total' => count($containers),
            'positioned' => count($positionedContainers),
            'unpositioned' => count($containers) - count($positionedContainers),
            'full' => count(array_filter($containers, fn($c) => ($c['full_empty'] ?? 'E') === 'F')),
            'empty' => count(array_filter($containers, fn($c) => ($c['full_empty'] ?? 'E') === 'E')),
            'imdg' => count(array_filter($containers, fn($c) => !empty($c['imdg_class']))),
            'reefer' => count(array_filter($containers, fn($c) => !empty($c['temperature']) && $c['temperature'] !== '0')),
        ];
        
        // Bay distribution
        $bayDistribution = [];
        foreach ($positionedContainers as $container) {
            $bay = $container['bay'];
            $bayDistribution[$bay] = ($bayDistribution[$bay] ?? 0) + 1;
        }
        ksort($bayDistribution);
        $stats['bay_distribution'] = $bayDistribution;
        
        // Total weight
        $totalWeight = array_sum(array_map(fn($c) => (int)($c['weight'] ?? 0), $containers));
        $stats['total_weight'] = $totalWeight;
        $stats['average_weight'] = $stats['total'] > 0 ? round($totalWeight / $stats['total'], 2) : 0;
        
        return view('bayplan.index', compact('containers', 'voyage', 'positionedContainers', 'stats'));
    }
}