<?php

namespace App\Services;


class ContainerIsoMapping
{
    public static function getIsoMap()
    {
        return [
    // General Purpose / Dry (G)
    '20G0' => ['old_code' => '2200', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry standard tanpa ventilasi'],
    '20G1' => ['old_code' => '2200', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry standard dengan ventilasi pasif'],
    '20G2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry dengan bukaan samping penuh'],
    '20G3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry dengan bukaan samping sebagian'],
    '20G9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry dengan kemampuan muat curah (bulkhead)'],
    
    '22G0' => ['old_code' => '2210', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry standard tanpa ventilasi'],
    '22G1' => ['old_code' => '2250', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry standard dengan ventilasi pasif'],
    '22G2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry dengan bukaan samping penuh'],
    '22G3' => ['old_code' => '2230', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry dengan bukaan samping sebagian'],
    '22G9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry dengan kemampuan muat curah (bulkhead)'],
    '22T0' => ['old_code' => '2270','size' => "20' x 8'6\" x 8'",'type_group' => 'T', 'jenis' => 'Special Type','keterangan' => 'Kode khusus 22T0, tipe container khusus, definisi perlu disesuaikan'],
    // Ventilated (V)
    '20V0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi non-mekanis (atas & bawah)'],
    '20V1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi non-mekanis (atas saja)'],
    '20V2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi mekanis internal'],
    '20V4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi mekanis eksternal'],
    
    '22V0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi non-mekanis (atas & bawah)'],
    '22V1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi non-mekanis (atas saja)'],
    '22V2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi mekanis internal'],
    '22V4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi mekanis eksternal'],

    // Open Top (U)
    '20U0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top bukaan ujung'],
    '20U1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + top member lepas'],
    '20U2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + bukaan samping'],
    '20U3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + samping + top member lepas'],
    '20U4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top: satu sisi partial, sisi lain penuh'],
    '20U5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan end door'],
    '20U6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top hard top (atap keras lepas)'],
    '20U7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan door dan top member lepas'],
    '20U8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan bukaan ujung dan samping'],
    '20U9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Coil carrier (open-top)'],
    
    '22U0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top bukaan ujung'],
    '22U1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + top member lepas'],
    '22U2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + bukaan samping'],
    '22U3' => ['old_code' => '2263', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + samping + top member lepas'],
    '22U4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top: satu sisi partial, sisi lain penuh'],
    '22U5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan end door'],
    '22U6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top hard top (atap keras lepas)'],
    '22U7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan door dan top member lepas'],
    '22U8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan bukaan ujung dan samping'],
    '22U9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Coil carrier (open-top)'],

    // Platform/Flat (P)
    '20P0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform/flat tanpa superstruktur'],
    '20P1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat fixed ends'],
    '20P2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat fixed posts'],
    '20P3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat folding ends (collapsible)'],
    '20P4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat folding posts'],
    '20P5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform-based skeletal (open)'],
    '20P6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform dengan corner posts dan top member lepas'],
    '20P7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Car carrier (platform)'],
    '20P8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Timber/pipe carrier'],
    '20P9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Coil carrier (platform)'],
    
    '22P0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform/flat tanpa superstruktur'],
    '22P1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat fixed ends'],
    '22P2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat fixed posts'],
    '22P3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat folding ends (collapsible)'],
    '22P4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat folding posts'],
    '22P5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform-based skeletal (open)'],
    '22P6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform dengan corner posts dan top member lepas'],
    '22P7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Car carrier (platform)'],
    '22P8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Timber/pipe carrier'],
    '22P9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Coil carrier (platform)'],

    // Dry Bulk (B)
    '20B0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: box type tertutup'],
    '20B1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: kedap udara'],
    '20B2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/partial width'],
    '20B3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/cat flap'],
    '20B4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/full width opening'],
    '20B5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/full width fixed'],
    '20B6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: removable hard top + bottom discharge'],
    '20B7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: open top + bottom discharge'],
    '20B8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: front discharge/full width'],
    '20B9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: side discharge'],
    
    '22B0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: box type tertutup'],
    '22B1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: kedap udara'],
    '22B2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/partial width'],
    '22B3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/cat flap'],
    '22B4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/full width opening'],
    '22B5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/full width fixed'],
    '22B6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: removable hard top + bottom discharge'],
    '22B7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: open top + bottom discharge'],
    '22B8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: front discharge/full width'],
    '22B9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: side discharge'],

    // Refrigerated (R)
    '20R0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer mekanis (dingin saja)'],
    '20R1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer mekanis (dingin & panas)'],
    '20R2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer self-powered (genset terpasang)'],
    '20R3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer self-powered (dingin & panas)'],
    '20R4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer integrated machinery (dingin saja)'],
    '20R5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer integrated machinery (dingin & panas)'],
    '20R6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer dengan atmosphere control'],
    '20R7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer heated only'],
    '20R8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer heated self-powered'],
    '20R9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer dengan sistem khusus'],
    
    '22R0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer mekanis (dingin saja)'],
    '22R1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer mekanis (dingin & panas)'],
    '22R2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer self-powered (genset terpasang)'],
    '22R3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer self-powered (dingin & panas)'],
    '22R4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer integrated machinery (dingin saja)'],
    '22R5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer integrated machinery (dingin & panas)'],
    '22R6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer dengan atmosphere control'],
    '22R7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer heated only'],
    '22R8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer heated self-powered'],
    '22R9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer dengan sistem khusus'],

    // Insulated/Heated (H)
    '20H0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment eksternal (K=0.4)'],
    '20H1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment internal'],
    '20H2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment eksternal (K=0.7)'],
    '20H3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment dengan heating'],
    '20H4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: fixed equipment eksternal'],
    '20H5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated (K=0.4)'],
    '20H6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated (K=0.7)'],
    '20H7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Heated (self-powered)'],
    '20H8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Eutectic, remote mechanical refrigeration'],
    '20H9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated dengan sistem khusus'],
    
    '22H0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment eksternal (K=0.4)'],
    '22H1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment internal'],
    '22H2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment eksternal (K=0.7)'],
    '22H3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment dengan heating'],
    '22H4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: fixed equipment eksternal'],
    '22H5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated (K=0.4)'],
    '22H6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Highly insulated (K≈0)'],
    '22H7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Heated (self-powered)'],
    '22H8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Eutectic, remote mechanical refrigeration'],
    '22H9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated dengan sistem khusus'],

    // Tank (Liquids/Gases) (K)
    '20K0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank cairan non-regulated'],
    '20K1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank bahan berbahaya ≤2.65 bar'],
    '20K2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank bahan berbahaya >2.65 dan ≤10 bar'],
    '20K3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank tekanan tinggi >10 bar'],
    '20K4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank non-regulated dengan power supply'],
    '20K5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank berbahaya ≤10 bar dengan power supply'],
    '20K6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank berbahaya >10 bar dengan power supply'],
    '20K7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank kriogenik'],
    '20K8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank gas'],
    '20K9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank dengan sistem khusus'],
    
    '22K0' => ['old_code' => '2276', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank cairan non-regulated'],
    '22K1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank bahan berbahaya ≤2.65 bar'],
    '22K2' => ['old_code' => '2276', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank bahan berbahaya >2.65 dan ≤10 bar'],
    '22K3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank tekanan tinggi >10 bar'],
    '22K4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank non-regulated dengan power supply'],
    '22K5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank berbahaya ≤10 bar dengan power supply'],
    '22K6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank berbahaya >10 bar dengan power supply'],
    '22K7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank kriogenik'],
    '22K8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank gas'],
    '22K9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank dengan sistem khusus'],

    // Tank (Dry Bulk Press/Non-press) (N)
    '20N0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Hopper vertical discharge (non-press)'],
    '20N1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Hopper rear discharge'],
    '20N2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized front discharge'],
    '20N3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized rear discharge'],
    '20N4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized side discharge'],
    '20N5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized tipping discharge'],
    '20N6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized front discharge'],
    '20N7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized rear discharge'],
    '20N8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized side discharge'],
    '20N9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized tipping discharge'],
    
    '22N0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Hopper vertical discharge (non-press)'],
    '22N1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Hopper rear discharge'],
    '22N2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized front discharge'],
    '22N3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized rear discharge'],
    '22N4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized side discharge'],
    '22N5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized tipping discharge'],
    '22N6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized front discharge'],
    '22N7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized rear discharge'],
    '22N8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized side discharge'],
    '22N9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized tipping discharge'],

    // Named Cargoes & Non-cargo Carrying (S)
    '20S0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Livestock carrier'],
    '20S1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Automotive carrier'],
    '20S2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Live fish carrier'],
    '20S3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Garment carrier'],
    '20S4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Generator container'],
    '20S5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Office container'],
    '20S6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Workshop container'],
    '20S7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Laboratory container'],
    '20S8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Equipment container (sensitive)'],
    '20S9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Residential/commercial use'],
    
    '22S0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Livestock carrier'],
    '22S1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Automotive carrier'],
    '22S2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Live fish carrier'],
    '22S3' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Garment carrier'],
    '22S4' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Generator container'],
    '22S5' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Office container'],
    '22S6' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Workshop container'],
    '22S7' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Laboratory container'],
    '22S8' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Equipment container (sensitive)'],
    '22S9' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Residential/commercial use'],

    // Foldable Containers (W)
    '20W0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding on base structure'],
    '20W1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding on side structure'],
    '20W2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding dengan top removable'],
    
    '22W0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding on base structure'],
    '22W1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding on side structure'],
    '22W2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding dengan top removable'],

    // Air/Surface Containers (A)
    '20A0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface container'],
    '20A1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface dengan loading equipment'],
    '20A2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface dengan sistem khusus'],
    
    '22A0' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface container'],
    '22A1' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface dengan loading equipment'],
    '22A2' => ['old_code' => '', 'size' => "20' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface dengan sistem khusus'],

    // ========== 40' CONTAINERS (8'6" x 8') ==========
    
    // General Purpose / Dry (G)
    '40G0' => ['old_code' => '4000', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry standard tanpa ventilasi'],
    '40G1' => ['old_code' => '4000', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry standard dengan ventilasi pasif'],
    '40G2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry dengan bukaan samping penuh'],
    '40G3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry dengan bukaan samping sebagian'],
    '40G9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry dengan kemampuan muat curah'],
    
    '42G0' => ['old_code' => '4300', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry standard tanpa ventilasi'],
    '42G1' => ['old_code' => '4310', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry standard dengan ventilasi pasif'],
    '42G2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry dengan bukaan samping penuh'],
    '42G3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry dengan bukaan samping sebagian'],
    '42G9' => ['old_code' => '4350', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose / Dry', 'keterangan' => 'Dry dengan kemampuan muat curah'],

    // Ventilated (V)
        // Ventilated (V)
    '40V0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi non-mekanis (atas & bawah)'],
    '40V1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi non-mekanis (atas saja)'],
    '40V2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi mekanis internal'],
    '40V4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi mekanis eksternal'],

    '42V0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi non-mekanis (atas & bawah)'],
    '42V1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi non-mekanis (atas saja)'],
    '42V2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi mekanis internal'],
    '42V4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi mekanis eksternal'],

    // Open Top (U)
    '40U0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top bukaan ujung'],
    '40U1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + top member lepas'],
    '40U2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + bukaan samping'],
    '40U3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + samping + top member lepas'],
    '40U4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top: satu sisi partial, sisi lain penuh'],
    '40U5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan end door'],
    '40U6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top hard top (atap keras lepas)'],
    '40U7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan door dan top member lepas'],
    '40U8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan bukaan ujung dan samping'],
    '40U9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Coil carrier (open-top)'],

    '42U0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top bukaan ujung'],
    '42U1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + top member lepas'],
    '42U2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + bukaan samping'],
    '42U3' => ['old_code' => '4363', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + samping + top member lepas'],
    '42U4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top: satu sisi partial, sisi lain penuh'],
    '42U5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan end door'],
    '42U6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top hard top (atap keras lepas)'],
    '42U7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan door dan top member lepas'],
    '42U8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan bukaan ujung dan samping'],
    '42U9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Coil carrier (open-top)'],

    // Platform/Flat (P)
    '40P0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform/flat tanpa superstruktur'],
    '40P1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat fixed ends'],
    '40P2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat fixed posts'],
    '40P3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat folding ends (collapsible)'],
    '40P4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat folding posts'],
    '40P5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform-based skeletal (open)'],
    '40P6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform dengan corner posts dan top member lepas'],
    '40P7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Car carrier (platform)'],
    '40P8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Timber/pipe carrier'],
    '40P9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Coil carrier (platform)'],

    '42P0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform/flat tanpa superstruktur'],
    '42P1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat fixed ends'],
    '42P2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat fixed posts'],
    '42P3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat folding ends (collapsible)'],
    '42P4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat folding posts'],
    '42P5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform-based skeletal (open)'],
    '42P6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform dengan corner posts dan top member lepas'],
    '42P7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Car carrier (platform)'],
    '42P8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Timber/pipe carrier'],
    '42P9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Coil carrier (platform)'],

    // Dry Bulk (B)
    '40B0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: box type tertutup'],
    '40B1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: kedap udara'],
    '40B2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/partial width'],
    '40B3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/cat flap'],
    '40B4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/full width opening'],
    '40B5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/full width fixed'],
    '40B6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: removable hard top + bottom discharge'],
    '40B7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: open top + bottom discharge'],
    '40B8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: front discharge/full width'],
    '40B9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: side discharge'],

    '42B0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: box type tertutup'],
    '42B1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: kedap udara'],
    '42B2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/partial width'],
    '42B3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/cat flap'],
    '42B4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/full width opening'],
    '42B5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/full width fixed'],
    '42B6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: removable hard top + bottom discharge'],
    '42B7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: open top + bottom discharge'],
    '42B8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: front discharge/full width'],

        // Refrigerated (R)         // Refrigerated (R) - 40'
    '40R0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer mekanis (dingin saja)'],
    '40R1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer mekanis (dingin & panas)'],
    '40R2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer self-powered (genset terpasang)'],
    '40R3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer self-powered (dingin & panas)'],        '40R4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer integrated machinery (dingin saja)'],
    '40R5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer integrated machinery (dingin & panas)'],
    '40R6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer dengan atmosphere control'],
    '40R7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer heated only'],
    '40R8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer heated self-powered'],
    '40R9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer dengan sistem khusus'],

    '42R0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer mekanis (dingin saja)'],
    '42R1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer mekanis (dingin & panas)'],
    '42R2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer self-powered (genset terpasang)'],        '42R3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer self-powered (dingin & panas)'],
    '42R4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer integrated machinery (dingin saja)'],
    '42R5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer integrated machinery (dingin & panas)'],
    '42R6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer dengan atmosphere control'],
    '42R7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer heated only'],
    '42R8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer heated self-powered'],
    '42R9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer dengan sistem khusus'],

            // Insulated/Heated (H) - 40'
    '40H0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment eksternal (K=0.4)'],
    '40H1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment internal'],
    '40H2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment eksternal (K=0.7)'],
    '40H3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment dengan heating'],
    '40H4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: fixed equipment eksternal'],
    '40H5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated (K=0.4)'],
    '40H6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated (K=0.7)'],
    '40H7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Heated (self-powered)'],
    '40H8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Eutectic, remote mechanical refrigeration'],
    '40H9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated dengan sistem khusus'],

    '42H0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment eksternal (K=0.4)'],
    '42H1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment internal'],
    '42H2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment eksternal (K=0.7)'],
    '42H3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment dengan heating'],
    '42H4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: fixed equipment eksternal'],
    '42H5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated (K=0.4)'],
    '42H6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Highly insulated (K≈0)'],
    '42H7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Heated (self-powered)'],
    '42H8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Eutectic, remote mechanical refrigeration'],
    '42H9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated dengan sistem khusus'],

    // Tank (Liquids/Gases) (K)
    '40K0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank cairan non-regulated'],
    '40K1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank bahan berbahaya ≤2.65 bar'],
    '40K2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank bahan berbahaya >2.65 dan ≤10 bar'],
    '40K3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank tekanan tinggi >10 bar'],
    '40K4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank non-regulated dengan power supply'],
    '40K5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank berbahaya ≤10 bar dengan power supply'],
    '40K6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank berbahaya >10 bar dengan power supply'],
    '40K7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank kriogenik'],
    '40K8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank gas'],
    '40K9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank dengan sistem khusus'],

    '42K0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank cairan non-regulated'],
    '42K1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank bahan berbahaya ≤2.65 bar'],
    '42K2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank bahan berbahaya >2.65 dan ≤10 bar'],
    '42K3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank tekanan tinggi >10 bar'],
    '42K4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank non-regulated dengan power supply'],
    '42K5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank berbahaya ≤10 bar dengan power supply'],
    '42K6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank berbahaya >10 bar dengan power supply'],
    '42K7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank kriogenik'],
    '42K8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank gas'],
    '42K9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank dengan sistem khusus'],

        // Tank (Dry Bulk Press/Non-press) (N)
    '40N0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Hopper vertical discharge (non-press)'],
    '40N1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Hopper rear discharge'],
    '40N2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized front discharge'],
    '40N3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized rear discharge'],
    '40N4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized side discharge'],
    '40N5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized tipping discharge'],
    '40N6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized front discharge'],
    '40N7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized rear discharge'],
    '40N8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized side discharge'],
    '40N9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized tipping discharge'],

    '42N0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Hopper vertical discharge (non-press)'],
    '42N1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Hopper rear discharge'],
    '42N2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized front discharge'],
    '42N3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized rear discharge'],
    '42N4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized side discharge'],
    '42N5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized tipping discharge'],
    '42N6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized front discharge'],
    '42N7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized rear discharge'],
    '42N8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized side discharge'],
    '42N9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized tipping discharge'],

    // Named Cargoes & Non-cargo Carrying (S)
    '40S0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Livestock carrier'],
    '40S1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Automotive carrier'],
    '40S2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Live fish carrier'],
    '40S3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Garment carrier'],
    '40S4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Generator container'],
    '40S5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Office container'],
    '40S6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Workshop container'],
    '40S7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Laboratory container'],
    '40S8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Equipment container (sensitive)'],
    '40S9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Residential/commercial use'],

    '42S0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Livestock carrier'],
    '42S1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Automotive carrier'],
    '42S2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Live fish carrier'],
    '42S3' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Garment carrier'],
    '42S4' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Generator container'],
    '42S5' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Office container'],
    '42S6' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Workshop container'],
    '42S7' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Laboratory container'],
    '42S8' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Equipment container (sensitive)'],
    '42S9' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Residential/commercial use'],

    // Foldable Containers (W)
    '40W0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding on base structure'],
    '40W1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding on side structure'],
    '40W2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding dengan top removable'],

    '42W0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding on base structure'],
    '42W1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding on side structure'],
    '42W2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding dengan top removable'],

    // Air/Surface Containers (A)
    '40A0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface container'],
    '40A1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface dengan loading equipment'],
    '40A2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface dengan sistem khusus'],

    '42A0' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface container'],
    '42A1' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface dengan loading equipment'],
    '42A2' => ['old_code' => '', 'size' => "40' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface dengan sistem khusus'],

// General Purpose (G)
'45G0' => ['old_code' => '4500', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose', 'keterangan' => 'General purpose container standard'],
'45G1' => ['old_code' => '4510', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose', 'keterangan' => 'General purpose container with ventilation'],
'45G2' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose', 'keterangan' => 'General purpose container with side doors'],
'45G3' => ['old_code' => '4530', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose', 'keterangan' => 'General purpose container with extra height'],
'45G4' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose', 'keterangan' => 'General purpose container with insulated walls'],
'45G5' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose', 'keterangan' => 'General purpose container with reinforced floor'],
'45G6' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose', 'keterangan' => 'General purpose container with internal lighting'],
'45G7' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose', 'keterangan' => 'General purpose container with locking system'],
'45G8' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose', 'keterangan' => 'General purpose container with ventilation and side doors'],
'45G9' => ['old_code' => '9500', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'G', 'jenis' => 'General Purpose', 'keterangan' => 'General purpose container with special features'],


// Dry Bulk (B)
'45B0' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: tipe 0'],
'45B1' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: tipe 1'],
'45B2' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: tipe 2'],
'45B3' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: tipe 3'],
'45B4' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: tipe 4'],
'45B5' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: tipe 5'],
'45B6' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: tipe 6'],
'45B7' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: tipe 7'],
'45B8' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: tipe 8'],
'45B9' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: side discharge'],

'45R0' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer mekanis (dingin saja)'],
'45R1' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer mekanis (dingin & panas)'],
'45R2' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer self-powered (genset terpasang)'],
'45R3' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer self-powered (dingin & panas)'],
'45R4' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer integrated machinery (dingin saja)'],
'45R5' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer integrated machinery (dingin & panas)'],
'45R6' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer dengan atmosphere control'],
'45R7' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer heated only'],
'45R8' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer heated self-powered'],
'45R9' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer dengan sistem khusus'],
// Insulated/Heated (H)
'45H0' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment eksternal (K=0.4)'],
'45H1' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment internal'],
'45H2' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment eksternal (K=0.7)'],
'45H3' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment dengan heating'],
'45H4' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: fixed equipment eksternal'],
'45H5' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated (K=0.4)'],
'45H6' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated (K=0.7)'],
'45H7' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Heated (self-powered)'],
'45H8' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Eutectic, remote mechanical refrigeration'],
'45H9' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated dengan sistem khusus'],
// Tank (Liquids/Gases) (K)
'45K0' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank cairan non-regulated'],
'45K1' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank bahan berbahaya ≤2.65 bar'],
'45K2' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank bahan berbahaya >2.65 dan ≤10 bar'],
'45K3' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank tekanan tinggi >10 bar'],
'45K4' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank non-regulated dengan power supply'],
'45K5' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank berbahaya ≤10 bar dengan power supply'],
'45K6' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank berbahaya >10 bar dengan power supply'],
'45K7' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank kriogenik'],
'45K8' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank gas'],
'45K9' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank dengan sistem khusus'],
// Tank (Dry Bulk Press/Non-press) (N)
'45N0' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Hopper vertical discharge (non-press)'],
'45N1' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Hopper rear discharge'],
'45N2' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized front discharge'],
'45N3' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized rear discharge'],
'45N4' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized side discharge'],
'45N5' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized tipping discharge'],
'45N6' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized front discharge'],
'45N7' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized rear discharge'],
'45N8' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized side discharge'],
'45N9' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized tipping discharge'],

// Named Cargoes & Non-cargo Carrying (S)
'45S0' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Livestock carrier'],
'45S1' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Automotive carrier'],
'45S2' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Live fish carrier'],
'45S3' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Garment carrier'],
'45S4' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Generator container'],
'45S5' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Office container'],
'45S6' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Workshop container'],
'45S7' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Laboratory container'],
'45S8' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Equipment container (sensitive)'],
'45S9' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Residential/commercial use'],
// Foldable Containers (W)
'45W0' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding on base structure'],
'45W1' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding on side structure'],
'45W2' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding dengan top removable'],
// Air/Surface Containers (A)
'45A0' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface container'],
'45A1' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface dengan loading equipment'],
'45A2' => ['old_code' => '', 'size' => "45' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface dengan sistem khusus'],

'L5G0' => ['old_code' => 'L5G0','size' => "45' x 8'6\" x 9'6\"",'type_group' => 'G','jenis' => 'General Purpose','keterangan' => 'Kode khusus L5G0, container general purpose dengan dimensi tinggi 9\'6"'],

'50V4' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'V', 'jenis' => 'Ventilated', 'keterangan' => 'Ventilasi mekanis eksternal'],
// Open Top (U)
'50U0' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top bukaan ujung'],
'50U1' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + top member lepas'],
'50U2' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + bukaan samping'],
'50U3' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top + samping + top member lepas'],
'50U4' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top: satu sisi partial, sisi lain penuh'],
'50U5' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan end door'],
'50U6' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top hard top (atap keras lepas)'],
'50U7' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan door dan top member lepas'],
'50U8' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Open-top dengan bukaan ujung dan samping'],
'50U9' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'U', 'jenis' => 'Open Top', 'keterangan' => 'Coil carrier (open-top)'],
// Platform/Flat (P)
'50P0' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform/flat tanpa superstruktur'],
'50P1' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat fixed ends'],
'50P2' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat fixed posts'],
'50P3' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat folding ends (collapsible)'],
'50P4' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Flat folding posts'],
'50P5' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform-based skeletal (open)'],
'50P6' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Platform dengan corner posts dan top member lepas'],
'50P7' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Car carrier (platform)'],
'50P8' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Timber/pipe carrier'],
'50P9' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'P', 'jenis' => 'Platform/Flat', 'keterangan' => 'Coil carrier (platform)'],
// Dry Bulk (B)
'50B0' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: box type tertutup'],
'50B1' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: kedap udara'],
'50B2' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/partial width'],
'50B3' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/cat flap'],
'50B4' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/full width opening'],
// Dry Bulk (B) - lanjutan
'50B5' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: rear discharge/full width fixed'],
'50B6' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: removable hard top + bottom discharge'],
'50B7' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: open top + bottom discharge'],
'50B8' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: front discharge/full width'],
'50B9' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'B', 'jenis' => 'Dry Bulk', 'keterangan' => 'Dry bulk: side discharge'],

// Refrigerated (R)
'50R0' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer mekanis (dingin saja)'],
'50R1' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer mekanis (dingin & panas)'],
'50R2' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer self-powered (genset terpasang)'],
'50R3' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer self-powered (dingin & panas)'],
'50R4' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer integrated machinery (dingin saja)'],
'50R5' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer integrated machinery (dingin & panas)'],
'50R6' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer dengan atmosphere control'],
'50R7' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer heated only'],
'50R8' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer heated self-powered'],
'50R9' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'R', 'jenis' => 'Refrigerated (Reefer)', 'keterangan' => 'Reefer dengan sistem khusus'],

// Insulated/Heated (H)
'50H0' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment eksternal (K=0.4)'],
'50H1' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment internal'],
'50H2' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment eksternal (K=0.7)'],
'50H3' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: removable equipment dengan heating'],
'50H4' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Thermal: fixed equipment eksternal'],
'50H5' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated (K=0.4)'],
'50H6' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated (K=0.7)'],
'50H7' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Heated (self-powered)'],
'50H8' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Eutectic, remote mechanical refrigeration'],
'50H9' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'H', 'jenis' => 'Insulated/Heated', 'keterangan' => 'Insulated dengan sistem khusus'],

// Tank (Liquids/Gases) (K)
'50K0' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank cairan non-regulated'],
'50K1' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank bahan berbahaya ≤2.65 bar'],
'50K2' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank bahan berbahaya >2.65 dan ≤10 bar'],
'50K3' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank tekanan tinggi >10 bar'],
'50K4' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank non-regulated dengan power supply'],
'50K5' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank berbahaya ≤10 bar dengan power supply'],
'50K6' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank berbahaya >10 bar dengan power supply'],
'50K7' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank kriogenik'],
'50K8' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank gas'],
'50K9' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'K', 'jenis' => 'Tank (Liquids/Gases)', 'keterangan' => 'Tank dengan sistem khusus'],

// Tank (Dry Bulk Press/Non-press) (N)
'50N0' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Hopper vertical discharge (non-press)'],
'50N1' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Hopper rear discharge'],
'50N2' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized front discharge'],
'50N3' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized rear discharge'],
'50N4' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized side discharge'],
'50N5' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Non-pressurized tipping discharge'],
'50N6' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized front discharge'],
'50N7' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized rear discharge'],
'50N8' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized side discharge'],
'50N9' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'N', 'jenis' => 'Tank (Dry Bulk Press/Non-press)', 'keterangan' => 'Pressurized tipping discharge'],

// Named Cargoes & Non-cargo Carrying (S)
'50S0' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Livestock carrier'],
'50S1' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Automotive carrier'],
'50S2' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Live fish carrier'],
'50S3' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Named Cargo', 'keterangan' => 'Garment carrier'],
'50S4' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Generator container'],
'50S5' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Office container'],
'50S6' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Workshop container'],
'50S7' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Laboratory container'],
'50S8' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Equipment container (sensitive)'],
'50S9' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'S', 'jenis' => 'Non-cargo Carrying', 'keterangan' => 'Residential/commercial use'],

// Foldable Containers (W)
'50W0' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding on base structure'],
'50W1' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding on side structure'],
'50W2' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'W', 'jenis' => 'Foldable', 'keterangan' => 'Container folding dengan top removable'],

// Air/Surface Containers (A)
'50A0' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface container'],
'50A1' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface dengan loading equipment'],
'50A2' => ['old_code' => '', 'size' => "50' x 8'6\" x 8'", 'type_group' => 'A', 'jenis' => 'Air/Surface', 'keterangan' => 'Air/surface dengan sistem khusus'],
   ];
}
}
class IsoCodeHelper
{

    /** Get ISO code info by ISO code */
    public static function getByIsoCode($isoCode)
    {
        $map = self::getIsoMap();
        return $map[$isoCode] ?? null;
    }

    /** Get all ISO codes by type group */
    public static function getByTypeGroup($typeGroup)
    {
        return array_filter(self::getIsoMap(), function ($item) use ($typeGroup) {
            return $item['type_group'] === $typeGroup;
        });
    }

    /** Get all ISO codes by container size */
    public static function getBySize($size)
    {
        return array_filter(self::getIsoMap(), function ($item) use ($size) {
            return $item['size'] === $size;
        });
    }

    /** Get ISO code by old_code */
    public static function getIsoCodeByOldCode($oldCode)
    {
        foreach (self::getIsoMap() as $isoCode => $data) {
            if ($data['old_code'] === $oldCode) {
                return $isoCode;
            }
        }
        return null;
    }

    /** Get container info by old_code */
    public static function getByOldCode($oldCode)
    {
        $isoCode = self::getIsoCodeByOldCode($oldCode);
        return $isoCode ? self::getByIsoCode($isoCode) : null;
    }

    /** Convert old_code → ISO code (pattern-based, optional) */
    public static function convertOldCodeToIsoCode($oldCode, $defaultTypeGroup = 'G')
    {
        if (strlen($oldCode) !== 4 || !ctype_digit($oldCode)) {
            return null;
        }

        $lengthCode = substr($oldCode, 0, 2);
        $typeDigit  = substr($oldCode, 2, 1);

        $isoCode = $lengthCode . $defaultTypeGroup . $typeDigit;
        $map     = self::getIsoMap();

        if (isset($map[$isoCode])) {
            return $isoCode;
        }

        // fallback → last digit '0'
        $isoCodeAlt = $lengthCode . $defaultTypeGroup . '0';
        return $map[$isoCodeAlt] ?? null;
    }

    /** Get container info by old_code with auto conversion */
    public static function getByOldCodeAuto($oldCode, $defaultTypeGroup = 'G')
    {
        $isoCode = self::convertOldCodeToIsoCode($oldCode, $defaultTypeGroup);
        return $isoCode ? self::getByIsoCode($isoCode) : null;
    }
}
