<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


return new class extends Migration {
public function up(): void {
Schema::create('containers', function (Blueprint $table) {
$table->id();
$table->foreignId('voyage_id')->constrained()->cascadeOnDelete();
$table->foreignId('baplie_file_id')->nullable()->constrained()->nullOnDelete();
$table->string('container_no', 11);
$table->string('iso_type', 4)->nullable(); // ex: 22G1
$table->enum('status', ['F','E'])->default('F'); // F=Full, E=Empty
$table->string('carrier_code', 10)->nullable(); // ex: YM


$table->integer('weight_kg')->nullable();


$table->smallInteger('bay')->nullable();
$table->smallInteger('row')->nullable();
$table->smallInteger('tier')->nullable();


$table->string('pol_locode', 5)->nullable(); // ex: SGSIN
$table->string('pod_locode', 5)->nullable(); // ex: IDSRG
$table->string('delivery_locode', 5)->nullable(); // ex: IDSRG


$table->string('bl_no', 50)->nullable();
$table->string('imdg_class', 10)->nullable();
$table->string('un_number', 10)->nullable();
$table->text('remarks')->nullable();
$table->timestamps();


$table->index(['container_no']);
$table->unique(['voyage_id','bay','row','tier']); // cegah 2 kontainer di satu slot
});
}
public function down(): void {
Schema::dropIfExists('containers');
}
};