@extends('layouts.app')

@section('content')
<div class="container-fluid py-4">

    {{-- Alerts --}}
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Page Header --}}
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">BAPLIE MANAGEMENT</h1>
        </div>
        <div class="col-md-4 text-md-end">
            <div class="btn-group" role="group">
            </div>
        </div>
    </div>

    {{-- Dashboard Panels --}}
    @php
        $totalContainers = count($containers);
        $totalWeight = 0;
        
        // Hitung total weight dengan aman
        foreach($containers as $container) {
            if (isset($container['weight_kg']) && is_numeric($container['weight_kg'])) {
                $totalWeight += (float) $container['weight_kg'];
            }
        }
    @endphp

    <div class="row">
        {{-- VOYAGE DETAILS --}}
        <div class="col-lg-6 mb-4">
            <div class="card h-100 border-primary">
                <div class="card-header bg-primary text-black">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-ship"></i> VOYAGE DETAILS
                    </h5>
                </div>
                <div class="card-body">
                    @if(!empty($voyage))
                        <div class="text-center mb-3">
                            <h4 class="text-primary">{{ $voyage['vessel_name'] ?? 'N/A' }}</h4>
                            <p class="text-muted mb-0">
                                Voyage: <strong>{{ $voyage['voyage_no'] ?? 'N/A' }}</strong>
                                @if(!empty($voyage['call_sign']))
                                    | Call Sign: <strong>{{ $voyage['call_sign'] }}</strong>
                                @endif
                            </p>
                        </div>
                        
                        <div class="row text-center">
                            <div class="col-6">
                                <div class="border-end">
                                    <h3 class="text-info mb-0">{{ $totalContainers }}</h3>
                                    <small class="text-muted">Total Containers</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <h3 class="text-success mb-0">{{ number_format($totalWeight / 1000, 1) }}</h3>
                                <small class="text-muted">Total Weight (tons)</small>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <table class="table table-sm table-borderless">
                            <tbody>
                                @if(isset($voyage['carrier_code']))
                                    <tr>
                                        <th style="width: 40%">Vessel Code:</th>
                                        <td><span class="badge bg-secondary">{{ $voyage['carrier_code'] }}</span></td>
                                    </tr>
                                @endif
                                @if(isset($voyage['port_of_departure']))
                                    <tr>
                                        <th>Port of Departure:</th>
                                        <td><span class="badge bg-info">{{ $voyage['port_of_departure'] }}</span></td>
                                    </tr>
                                @endif
                                @if(isset($voyage['port_of_discharge']))
                                    <tr>
                                        <th>Port of Discharge:</th>
                                        <td><span class="badge bg-info">{{ $voyage['port_of_discharge'] }}</span></td>
                                    </tr>
                                @endif
                                @if(isset($voyage['departure_date']))
                                    <tr>
                                        <th>Departure:</th>
                                        <td>{{ $voyage['departure_date'] }}</td>
                                    </tr>
                                @endif
                                @if(isset($voyage['arrival_date']))
                                    <tr>
                                        <th>Arrival:</th>
                                        <td>{{ $voyage['arrival_date'] }}</td>
                                    </tr>
                                @endif
                                @if(isset($voyage['actual_arrival_date']))
                                    <tr>
                                        <th>Actual Arrival:</th>
                                        <td>{{ $voyage['actual_arrival_date'] }}</td>
                                    </tr>
                                @endif
                                @if(isset($voyage['sender']))
                                    <tr>
                                        <th>Sender:</th>
                                        <td><small>{{ $voyage['sender'] }}</small></td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    @else
                        <div class="text-center text-muted py-5">
                            <i class="bi bi-ship" style="font-size: 4rem; opacity: 0.3;"></i>
                            <h5 class="mt-3">No Voyage Data</h5>
                            <p>Upload a BAPLIE file to see voyage details</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        {{-- DISCHARGE PORTS SUMMARY --}}
        <div class="col-lg-6 mb-4">
            <div class="card h-100 border-info">
                <div class="card-header bg-info text-black">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-geo-alt"></i> DISCHARGE PORTS SUMMARY
                    </h5>
                </div>
                <div class="card-body">
                    @php
                        $portSummary = [];
                        foreach($containers as $c) {
                            if(!empty($c['pod_locode'])) {
                                if(!isset($portSummary[$c['pod_locode']])) {
                                    $portSummary[$c['pod_locode']] = ['count' => 0, 'weight' => 0];
                                }
                                $portSummary[$c['pod_locode']]['count']++;
                                if (isset($c['weight_kg']) && is_numeric($c['weight_kg'])) {
                                    $portSummary[$c['pod_locode']]['weight'] += (float) $c['weight_kg'];
                                }
                            }
                        }
                        arsort($portSummary); // Sort by container count desc
                    @endphp
                    
                    @if(count($portSummary) > 0)
                        <div class="table-responsive">
                            <table class="table table-sm table-striped">
                                <thead class="table-dark">
                                    <tr>
                                        <th>Port Code</th>
                                        <th class="text-center">Containers</th>
                                        <th class="text-end">Weight (tons)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($portSummary as $port => $data)
                                        <tr>
                                            <td>
                                                <strong>{{ $port }}</strong>
                                            </td>
                                            <td class="text-center">
                                                <span class="badge bg-primary">{{ $data['count'] }}</span>
                                            </td>
                                            <td class="text-end">{{ number_format($data['weight'] / 1000, 1) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        @if(count($portSummary) > 5)
                            <div class="text-center mt-3">
                                <a href="{{ route('containers.index') }}" class="btn btn-sm btn-outline-info">
                                    View All Containers
                                </a>
                            </div>
                        @endif
                    @else
                        <div class="text-center text-muted py-5">
                            <i class="bi bi-geo-alt" style="font-size: 4rem; opacity: 0.3;"></i>
                            <h5 class="mt-3">No Port Data</h5>
                            <p>Upload a BAPLIE file to see port summary</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    {{-- Container Status Overview --}}
    @if(!empty($containers))
        <div class="card mb-4">
            <div class="card-header bg-secondary text-black">
                <h5 class="card-title mb-0">
                    <i class="bi bi-bar-chart"></i> CONTAINER STATUS OVERVIEW
                </h5>
            </div>
            <div class="card-body">
                @php
                    $statusCounts = [
                        '5' => count(array_filter($containers, fn($c) => ($c['status'] ?? '') === '5')),
                        '4' => count(array_filter($containers, fn($c) => ($c['status'] ?? '') === '4')),
                        'unknown' => count(array_filter($containers, fn($c) => empty($c['status']) || !in_array($c['status'], ['5', '4'])))
                    ];
                    $positionedContainers = count(array_filter($containers, fn($c) => !empty($c['bay']) && !empty($c['row']) && !empty($c['tier'])));
                    $dangerousGoods = count(array_filter($containers, fn($c) => !empty($c['imdg_class'])));
                @endphp
                
                <div class="row">
                    <div class="col-md-2">
                        <div class="text-center">
                            <div class="display-6 text-success">{{ $statusCounts['5'] }}</div>
                            <small class="text-muted">Full Containers</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <div class="display-6 text-warning">{{ $statusCounts['4'] }}</div>
                            <small class="text-muted">Empty Containers</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <div class="display-6 text-info">{{ $positionedContainers }}</div>
                            <small class="text-muted">Positioned</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <div class="display-6 text-danger">{{ $dangerousGoods }}</div>
                            <small class="text-muted">Dangerous Goods</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <div class="display-6 text-secondary">{{ $statusCounts['unknown'] }}</div>
                            <small class="text-muted">Unknown Status</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <div class="display-6 text-primary">{{ count($portSummary) }}</div>
                            <small class="text-muted">Discharge Ports</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Container Details Table --}}
            
    <div class="card mb-4">
                <div class="card-header bg-dark text-black">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-boxes"></i> CONTAINER DETAILS
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Container No</th>
                                    <th>ISO Type</th>
                                    <th>Size</th>
                                    <th>Type Group</th>
                                    <th>Jenis</th>
                                    <th>Keterangan</th>
                                    <th>Weight (kg)</th>
                                    <th>Position</th>
                                    <th>PoL</th>
                                    <th>PoD</th>
                                    <th>Delivery</th>
                                    <th>B/L No</th>
                                    <th>Operator</th>
                                    <th>Handling</th>
                                    <th>IMDG</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($containers as $index => $container)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $container['container_no'] ?? 'N/A' }}</td>
                                        <td>{{ $container['iso_type'] ?? 'N/A' }}</td>
                                        <td>{{ $container['size'] ?? 'N/A' }}</td>
                                        <td>{{ $container['type_group'] ?? 'N/A' }}</td>
                                        <td>{{ $container['jenis'] ?? 'N/A' }}</td>
                                        <td>{{ $container['keterangan'] ?? 'N/A' }}</td>
                                        <td>{{ isset($container['weight_kg']) && is_numeric($container['weight_kg']) ? number_format($container['weight_kg'], 0) : 'N/A' }}</td>
                                        <td>
                                            @if(!empty($container['bay']) && !empty($container['row']) && !empty($container['tier']))
                                                {{ sprintf('%03d-%02d-%02d', $container['bay'], $container['row'], $container['tier']) }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td><span class="badge bg-info">{{ $container['pol_locode'] ?? 'N/A' }}</span></td>
                                        <td><span class="badge bg-info">{{ $container['pod_locode'] ?? 'N/A' }}</span></td>
                                        <td><span class="badge bg-info">{{ $container['delivery_locode'] ?? 'N/A' }}</span></td>
                                        <td>{{ $container['bl_no'] ?? 'N/A' }}</td>
                                        <td>{{ $container['operator_code'] ?? 'N/A' }}</td>
                                        <td>{{ $container['handling_instruction'] ?? 'N/A' }}</td>
                                        <td>{{ $container['imdg_class'] ?? 'N/A' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @endif
    </div>
    @endsection