<style>
    .form-control,
    .form-select {
        border: 1px solid #dee2e6 !important;
        background-color: #f8f9fa;
        font-size: 0.85rem;
        padding: 0.5rem 0.75rem;
    }

    .form-control:focus,
    .form-select:focus {
        border-color: #0d6efd !important;
        box-shadow: 0 0 4px rgba(13,110,253,0.25);
        background-color: #fff;
    }

    .form-label {
        font-size: 0.8rem;
        font-weight: 600;
        margin-bottom: 0.3rem;
    }

    .card {
        font-size: 0.85rem;
    }

    .table-sm th,
    .table-sm td {
        padding: 0.2rem 0.4rem;
        font-size: 0.7rem;
        vertical-align: middle;
        border: none;
    }

    .section-header {
        font-size: 0.9rem;
        font-weight: 600;
        color: #495057;
        border-bottom: 1px solid #e9ecef;
        padding-bottom: 0.5rem;
        margin-bottom: 1rem;
    }

    .container-preview {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border: 1px solid #dee2e6;
        font-size: 0.75rem;
    }

    .alert-sm {
        padding: 0.4rem 0.6rem;
        margin-bottom: 0.5rem;
        font-size: 0.7rem;
    }

    .btn {
        font-size: 0.85rem;
        padding: 0.5rem 1rem;
    }

    .input-group-text {
        font-size: 0.8rem;
        padding: 0.5rem 0.75rem;
    }
</style>



<?php $__env->startSection('content'); ?>

<div class="container-fluid py-3">
    
    
    <div class="row mb-3">
        <div class="col-12">
            <div class="position-relative text-center text-white rounded-3 shadow-sm overflow-hidden" style="height: 120px;">
                <!-- Background image -->
                <div class="position-absolute top-0 start-0 w-100 h-100" 
                     style="background: url('/images/backgroundpelindo.jpg') center/cover no-repeat;">
                </div>

                <!-- Overlay biru transparan -->
                <div class="position-absolute top-0 start-0 w-100 h-100" 
                     style="background: rgba(13, 110, 253, 0.7);">
                </div>

                <!-- Content -->
                <div class="position-relative d-flex flex-column justify-content-center align-items-center h-100">
                    <h4 class="fw-bold mb-1">EDIT CONTAINER</h4>
                    <p class="mb-0 small">Container #<?php echo e($container + 1); ?> - <?php echo e($containerData['container_no'] ?? 'N/A'); ?></p>
                    <nav aria-label="breadcrumb" class="mt-2">
                        <ol class="breadcrumb breadcrumb-sm justify-content-center mb-0" style="font-size: 0.75rem;">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>" class="text-white text-decoration-none">BAPLIE Management</a></li>
                            <li class="breadcrumb-item text-white-50">Edit Container</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row g-3">
        
        <div class="col-lg-8">
            <div class="card shadow-sm border-0 rounded-3">
                <div class="card-header text-white py-2"
                     style="background: linear-gradient(90deg, #0d6efd 0%, #0a58ca 100%);">
                    <h6 class="card-title mb-0 fw-semibold">Container Details</h6>
                </div>
                <div class="card-body p-3">
                    <form action="<?php echo e(route('baplie.containers.update', $container)); ?>" method="POST" novalidate>
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        
                        <div class="section-header">Basic Information</div>
                        <div class="row g-2 mb-3">
                            <div class="col-md-6">
                                <label for="container_no" class="form-label">Container Number *</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['container_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="container_no" 
                                       name="container_no" 
                                       value="<?php echo e(old('container_no', $containerData['container_no'] ?? '')); ?>"
                                       maxlength="15" required>
                                <?php $__errorArgs = ['container_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label for="iso_type" class="form-label">ISO Type</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['iso_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="iso_type" 
                                       name="iso_type" 
                                       value="<?php echo e(old('iso_type', $containerData['iso_type'] ?? '')); ?>"
                                       maxlength="4" placeholder="e.g., 22G1">
                                <?php $__errorArgs = ['iso_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        
                        <div class="section-header">Size & Type Information</div>
                        <?php
                        $currentSize = old('size', $containerData['size'] ?? '');
                        $standardSizes = ["20'", "40'", "45'", "20", "40", "45"];
                        $isStandardSize = in_array($currentSize, $standardSizes);
                        
                        $normalizedSize = $currentSize;
                        if ($currentSize === "20'" || $currentSize === "20") $normalizedSize = "20'";
                        if ($currentSize === "40'" || $currentSize === "40") $normalizedSize = "40'"; 
                        if ($currentSize === "45'" || $currentSize === "45") $normalizedSize = "45'";
                        
                        $currentJenis = old('jenis', $containerData['jenis'] ?? '');
                        $standardJenis = ['dry', 'reefer', 'tank', 'flat', 'open_top', 'bulk', 'empty'];
                        $isStandardJenis = in_array(strtolower($currentJenis), $standardJenis);
                        ?>

                        <div class="row g-2 mb-3">
                            <div class="col-md-4">
                                <label for="size" class="form-label">Size</label>
                                <select class="form-select <?php $__errorArgs = ['size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="size" name="size" onchange="toggleSizeCustom()">
                                    <option value="" <?php echo e(empty($currentSize) ? 'selected' : ''); ?>>Select Size</option>
                                    <option value="20'" <?php echo e($normalizedSize === "20'" ? 'selected' : ''); ?>>20ft</option>
                                    <option value="40'" <?php echo e($normalizedSize === "40'" ? 'selected' : ''); ?>>40ft</option>
                                    <option value="45'" <?php echo e($normalizedSize === "45'" ? 'selected' : ''); ?>>45ft</option>
                                    <?php if(!empty($currentSize) && !$isStandardSize): ?>
                                        <option value="<?php echo e($currentSize); ?>" selected><?php echo e($currentSize); ?> (Current)</option>
                                    <?php endif; ?>
                                    <option value="other" <?php echo e(old('size') === 'other' ? 'selected' : ''); ?>>Custom...</option>
                                </select>
                                <input type="text" class="form-control mt-1 <?php $__errorArgs = ['size_custom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="size_custom" name="size_custom" placeholder="Enter custom size"
                                    style="display: <?php echo e(old('size') === 'other' ? 'block' : 'none'); ?>;"
                                    value="<?php echo e(old('size_custom', '')); ?>">
                                <?php $__errorArgs = ['size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-4">
                                <label for="type_group" class="form-label">Type Group</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['type_group'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="type_group" name="type_group" placeholder="Type Group"
                                    value="<?php echo e(old('type_group', $containerData['type_group'] ?? '')); ?>">
                                <?php $__errorArgs = ['type_group'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-4">
                                <label for="jenis" class="form-label">Jenis</label>
                                <select class="form-select <?php $__errorArgs = ['jenis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="jenis" name="jenis" onchange="toggleJenisCustom()">
                                    <option value="" <?php echo e(empty($currentJenis) ? 'selected' : ''); ?>>Select Jenis</option>
                                    <option value="dry" <?php echo e(strtolower($currentJenis) === 'dry' ? 'selected' : ''); ?>>Dry</option>
                                    <option value="reefer" <?php echo e(strtolower($currentJenis) === 'reefer' ? 'selected' : ''); ?>>Reefer</option>
                                    <option value="tank" <?php echo e(strtolower($currentJenis) === 'tank' ? 'selected' : ''); ?>>Tank</option>
                                    <option value="flat" <?php echo e(strtolower($currentJenis) === 'flat' ? 'selected' : ''); ?>>Flat Rack</option>
                                    <option value="open_top" <?php echo e(strtolower($currentJenis) === 'open_top' ? 'selected' : ''); ?>>Open Top</option>
                                    <option value="bulk" <?php echo e(strtolower($currentJenis) === 'bulk' ? 'selected' : ''); ?>>Bulk</option>
                                    <option value="empty" <?php echo e(strtolower($currentJenis) === 'empty' ? 'selected' : ''); ?>>Empty</option>
                                    <?php if(!empty($currentJenis) && !$isStandardJenis): ?>
                                        <option value="<?php echo e($currentJenis); ?>" selected><?php echo e(ucfirst($currentJenis)); ?> (Current)</option>
                                    <?php endif; ?>
                                    <option value="other" <?php echo e(old('jenis') === 'other' ? 'selected' : ''); ?>>Custom...</option>
                                </select>
                                <input type="text" class="form-control mt-1 <?php $__errorArgs = ['jenis_custom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="jenis_custom" name="jenis_custom" placeholder="Enter custom jenis"
                                       style="display: <?php echo e(old('jenis') === 'other' ? 'block' : 'none'); ?>;"
                                       value="<?php echo e(old('jenis_custom', '')); ?>">
                                <?php $__errorArgs = ['jenis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        
                        <div class="section-header">Status & Weight</div>
                        <div class="row g-2 mb-3">
                            <div class="col-md-6">
                                <label for="status" class="form-label">Container Status</label>
                                <select class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="status" name="status">
                                    <option value="">Select Status</option>
                                    <option value="5" <?php echo e(old('status', $containerData['status'] ?? $containerData['status_code'] ?? '') === '5' ? 'selected' : ''); ?>>Full</option>
                                    <option value="4" <?php echo e(old('status', $containerData['status'] ?? $containerData['status_code'] ?? '') === '4' ? 'selected' : ''); ?>>Empty</option>
                                </select>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label for="weight_kg" class="form-label">Weight (kg)</label>
                                <input type="number" class="form-control <?php $__errorArgs = ['weight_kg'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="weight_kg" name="weight_kg" 
                                       value="<?php echo e(old('weight_kg', $containerData['weight_kg'] ?? '')); ?>"
                                       min="0" step="0.01">
                                <?php $__errorArgs = ['weight_kg'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        
                        <div class="section-header">Position on Vessel</div>
                        <div class="row g-2 mb-3">
                            <div class="col-md-4">
                                <label for="bay" class="form-label">Bay</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['bay'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="bay" name="bay" 
                                       value="<?php echo e(old('bay', $containerData['bay'] ?? '')); ?>"
                                       placeholder="001">
                                <?php $__errorArgs = ['bay'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4">
                                <label for="row" class="form-label">Row</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['row'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="row" name="row" 
                                       value="<?php echo e(old('row', $containerData['row'] ?? '')); ?>"
                                       placeholder="01">
                                <?php $__errorArgs = ['row'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4">
                                <label for="tier" class="form-label">Tier</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['tier'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="tier" name="tier" 
                                       value="<?php echo e(old('tier', $containerData['tier'] ?? '')); ?>"
                                       placeholder="01">
                                <?php $__errorArgs = ['tier'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        
                        <div class="section-header">Port Information</div>
                        <div class="row g-2 mb-3">
                            <div class="col-md-4">
                                <label for="pol_locode" class="form-label">Port of Loading</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['pol_locode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="pol_locode" name="pol_locode" 
                                       value="<?php echo e(old('pol_locode', $containerData['pol_locode'] ?? '')); ?>"
                                       maxlength="5" placeholder="IDTPK">
                                <?php $__errorArgs = ['pol_locode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4">
                                <label for="pod_locode" class="form-label">Port of Discharge</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['pod_locode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="pod_locode" name="pod_locode" 
                                       value="<?php echo e(old('pod_locode', $containerData['pod_locode'] ?? '')); ?>"
                                       maxlength="5" placeholder="SGSIN">
                                <?php $__errorArgs = ['pod_locode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4">
                                <label for="delivery_locode" class="form-label">Delivery Location</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['delivery_locode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="delivery_locode" name="delivery_locode" 
                                       value="<?php echo e(old('delivery_locode', $containerData['delivery_locode'] ?? '')); ?>"
                                       maxlength="5" placeholder="MYPEN">
                                <?php $__errorArgs = ['delivery_locode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        
                        <div class="section-header">Additional Information</div>
                        <div class="row g-2 mb-3">
                            <div class="col-md-4">
                                <label for="bl_no" class="form-label">B/L Number</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['bl_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="bl_no" name="bl_no" 
                                       value="<?php echo e(old('bl_no', $containerData['bl_no'] ?? '')); ?>" maxlength="35">
                                <?php $__errorArgs = ['bl_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4">
                                <label for="operator_code" class="form-label">Operator</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['operator_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="operator_code" name="operator_code" 
                                       value="<?php echo e(old('operator_code', $containerData['operator_code'] ?? '')); ?>"
                                       maxlength="10" placeholder="YM">
                                <?php $__errorArgs = ['operator_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4">
                                <label for="imdg_class" class="form-label">IMDG Class</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['imdg_class'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="imdg_class" name="imdg_class" 
                                       value="<?php echo e(old('imdg_class', $containerData['imdg_class'] ?? '')); ?>"
                                       maxlength="10" placeholder="3">
                                <?php $__errorArgs = ['imdg_class'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="row g-2 mb-3">
                            <div class="col-12">
                                <label for="handling_instruction" class="form-label">Handling Instructions</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['handling_instruction'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="handling_instruction" name="handling_instruction" 
                                       value="<?php echo e(old('handling_instruction', $containerData['handling_instruction'] ?? '')); ?>"
                                       maxlength="100" placeholder="UDAB, CAREFUL">
                                <?php $__errorArgs = ['handling_instruction'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        
                        <div id="reeferSection" style="display: <?php echo e(($containerData['is_reefer'] ?? false) || strtolower($containerData['jenis'] ?? '') === 'reefer' ? 'block' : 'none'); ?>;">
                            <div class="section-header">Reefer Temperature Settings</div>
                            <div class="row g-2 mb-3">
                                <div class="col-md-4">
                                    <label for="is_reefer" class="form-label">Reefer Container</label>
                                    <select class="form-select" id="is_reefer" name="is_reefer">
                                        <option value="0" <?php echo e(!($containerData['is_reefer'] ?? false) ? 'selected' : ''); ?>>No</option>
                                        <option value="1" <?php echo e(($containerData['is_reefer'] ?? false) ? 'selected' : ''); ?>>Yes</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label for="set_temperature" class="form-label">Set Temperature</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" id="set_temperature" name="set_temperature" 
                                            value="<?php echo e(old('set_temperature', $containerData['set_temperature'] ?? '')); ?>"
                                            step="0.1" min="-50" max="50">
                                        <span class="input-group-text">°C</span>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label for="temperature_unit" class="form-label">Unit</label>
                                    <select class="form-select" id="temperature_unit" name="temperature_unit">
                                        <option value="CEL" <?php echo e(old('temperature_unit', $containerData['temperature_unit'] ?? 'CEL') === 'CEL' ? 'selected' : ''); ?>>Celsius</option>
                                        <option value="FAH" <?php echo e(old('temperature_unit', $containerData['temperature_unit'] ?? 'CEL') === 'FAH' ? 'selected' : ''); ?>>Fahrenheit</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="row g-2 mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Temperature Range</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="temp_range_min" 
                                            placeholder="Min" step="0.1" min="-50" max="50"
                                            value="<?php echo e(old('temp_range_min', $containerData['temperature_range']['min'] ?? '')); ?>">
                                        <span class="input-group-text">to</span>
                                        <input type="number" class="form-control" name="temp_range_max" 
                                            placeholder="Max" step="0.1" min="-50" max="50"
                                            value="<?php echo e(old('temp_range_max', $containerData['temperature_range']['max'] ?? '')); ?>">
                                        <span class="input-group-text">°C</span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="reefer_instructions" class="form-label">Reefer Instructions</label>
                                    <input type="text" class="form-control" id="reefer_instructions" name="reefer_instructions"
                                        value="<?php echo e(old('reefer_instructions', $containerData['reefer_instructions'] ?? '')); ?>"
                                        placeholder="Keep frozen">
                                </div>
                            </div>
                        </div>

                        
                        <div class="d-flex justify-content-between pt-3 border-top">
                            <a href="<?php echo e(route('baplie.management')); ?>" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left"></i> Back to List
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-save"></i> Update Container
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        
        <div class="col-lg-4">
            <div class="card shadow-sm border-0 rounded-3">
                <div class="card-header text-white py-2"
                     style="background: linear-gradient(90deg, #198754 0%, #157347 100%);">
                    <h6 class="card-title mb-0 fw-semibold">Container Preview</h6>
                </div>
                <div class="card-body p-2">
                    <div class="container-preview rounded p-2">
                        <h6 class="text-center mb-2 text-primary fw-bold" style="font-size: 0.9rem;">
                            <?php echo e($containerData['container_no'] ?? 'N/A'); ?>

                        </h6>
                        
                        <table class="table table-sm table-borderless mb-1">
                            <tbody>
                                <tr><th>ISO:</th><td><?php echo e($containerData['iso_type'] ?? 'N/A'); ?></td></tr>
                                <tr><th>Size:</th><td><?php echo e($containerData['size'] ?? 'N/A'); ?></td></tr>
                                <tr><th>Type:</th><td><?php echo e($containerData['type_group'] ?? 'N/A'); ?></td></tr>
                                <tr><th>Jenis:</th><td><?php echo e(ucfirst($containerData['jenis'] ?? 'N/A')); ?></td></tr>
                                <tr>
                                    <th>Status:</th>
                                    <td>
                                        <?php
                                        $status = $containerData['status'] ?? $containerData['status_code'] ?? '';
                                        $statusDisplay = 'N/A';
                                        $badgeClass = 'bg-secondary';
                                        
                                        if (in_array($status, ['5', 'F'])) {
                                            $statusDisplay = 'Full';
                                            $badgeClass = 'bg-success';
                                        } elseif (in_array($status, ['4', 'E'])) {
                                            $statusDisplay = 'Empty'; 
                                            $badgeClass = 'bg-warning text-dark';
                                        }
                                        ?>
                                        <span class="badge <?php echo e($badgeClass); ?>" style="font-size: 0.6rem;"><?php echo e($statusDisplay); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Weight:</th>
                                    <td><?php echo e(isset($containerData['weight_kg']) && $containerData['weight_kg'] > 0 ? number_format($containerData['weight_kg']) . ' kg' : 'N/A'); ?></td>
                                </tr>
                                <tr>
                                    <th>Position:</th>
                                    <td>
                                        <?php if(!empty($containerData['bay']) && !empty($containerData['row']) && !empty($containerData['tier'])): ?>
                                            <span class="badge bg-info" style="font-size: 0.6rem;">
                                                <?php echo e(sprintf('%03d-%02d-%02d', $containerData['bay'], $containerData['row'], $containerData['tier'])); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted" style="font-size: 0.65rem;">Not assigned</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        
                        <div class="border-top pt-1 mt-1">
                            <div class="row g-1 mb-1"><div class="col-4"><strong>POL:</strong></div><div class="col-8"><?php echo e($containerData['pol_locode'] ?? 'N/A'); ?></div></div>
                            <div class="row g-1 mb-1"><div class="col-4"><strong>POD:</strong></div><div class="col-8"><?php echo e($containerData['pod_locode'] ?? 'N/A'); ?></div></div>
                            <div class="row g-1"><div class="col-4"><strong>Del:</strong></div><div class="col-8"><?php echo e($containerData['delivery_locode'] ?? 'N/A'); ?></div></div>
                        </div>
                        
                        <?php if(!empty($containerData['operator_code']) || !empty($containerData['bl_no'])): ?>
                            <div class="border-top pt-1 mt-1">
                                <?php if(!empty($containerData['operator_code'])): ?>
                                    <div style="font-size: 0.65rem;"><strong>Operator:</strong> <?php echo e($containerData['operator_code']); ?></div>
                                <?php endif; ?>
                                <?php if(!empty($containerData['bl_no'])): ?>
                                    <div style="font-size: 0.65rem;"><strong>B/L:</strong> <?php echo e($containerData['bl_no']); ?></div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if(!empty($containerData['imdg_class'])): ?>
                            <div class="alert alert-warning alert-sm py-1 mt-1">
                                <div style="font-size: 0.65rem;">
                                    <i class="bi bi-exclamation-triangle"></i>
                                    <strong>Dangerous</strong><br>
                                    IMDG: <?php echo e($containerData['imdg_class']); ?>

                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if(!empty($containerData['handling_instruction'])): ?>
                            <div class="mt-1 pt-1 border-top">
                                <div style="font-size: 0.65rem;"><strong>Handling:</strong> <?php echo e($containerData['handling_instruction']); ?></div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Toggle reefer section visibility
document.getElementById('jenis').addEventListener('change', function() {
    const reeferSection = document.getElementById('reeferSection');
    const isReeferCheckbox = document.getElementById('is_reefer');
    
    if (this.value === 'reefer') {
        reeferSection.style.display = 'block';
        isReeferCheckbox.value = '1';
    } else if (this.value !== 'other') {
        reeferSection.style.display = 'none';
        isReeferCheckbox.value = '0';
    }
});

document.getElementById('is_reefer').addEventListener('change', function() {
    const reeferSection = document.getElementById('reeferSection');
    const jenisSelect = document.getElementById('jenis');
    
    if (this.value === '1') {
        reeferSection.style.display = 'block';
        if (jenisSelect.value !== 'reefer') {
            jenisSelect.value = 'reefer';
        }
    }
});

// Toggle functions for custom inputs
function toggleSizeCustom() {
    const select = document.getElementById('size');
    const customInput = document.getElementById('size_custom');
    
    if (select.value === 'other') {
        customInput.style.display = 'block';
        customInput.setAttribute('required', 'required');
        customInput.focus();
    } else {
        customInput.style.display = 'none';
        customInput.removeAttribute('required');
        customInput.value = '';
    }
}

function toggleJenisCustom() {
    const select = document.getElementById('jenis');
    const customInput = document.getElementById('jenis_custom');
    
    if (select.value === 'other') {
        customInput.style.display = 'block';
        customInput.setAttribute('required', 'required');
        customInput.focus();
    } else {
        customInput.style.display = 'none';
        customInput.removeAttribute('required');
        customInput.value = '';
    }
}
function formatPosition(inputElement, maxLength) {
    let value = inputElement.value.replace(/\D/g, ''); // Hapus non-digit
    
    if (value.length > 0) {
        // Pad dengan 0 di depan
        value = value.padStart(maxLength, '0');
        
        // Ambil hanya X digit terakhir jika lebih panjang
        if (value.length > maxLength) {
            value = value.slice(-maxLength);
        }
    }
    
    inputElement.value = value;
}

// Auto-uppercase container number input
document.getElementById('container_no').addEventListener('input', function() {
    this.value = this.value.toUpperCase();
});

// Auto-uppercase port codes inputs
['pol_locode', 'pod_locode', 'delivery_locode'].forEach(id => {
    const el = document.getElementById(id);
    if (el) {
        el.addEventListener('input', () => {
            el.value = el.value.toUpperCase();
        });
    }
});


document.getElementById('bay').addEventListener('blur', function() {
    formatPosition(this, 3);
});

['row', 'tier'].forEach(id => {
    document.getElementById(id).addEventListener('blur', function() {
        formatPosition(this, 2);
    });
});


['bay', 'row', 'tier'].forEach(id => {
    document.getElementById(id).addEventListener('input', function() {
        // Hanya hapus non-digit, TIDAK format
        this.value = this.value.replace(/\D/g, '');
    });
});


document.querySelector('form').addEventListener('submit', function(e) {
    // ✅ CRITICAL: Format position sebelum submit
    formatPosition(document.getElementById('bay'), 3);
    formatPosition(document.getElementById('row'), 2);
    formatPosition(document.getElementById('tier'), 2);
    
    // Validasi custom inputs
    const sizeSelect = document.getElementById('size');
    const sizeCustom = document.getElementById('size_custom');
    const jenisSelect = document.getElementById('jenis');
    const jenisCustom = document.getElementById('jenis_custom');
    
    if (sizeSelect.value === 'other' && !sizeCustom.value.trim()) {
        e.preventDefault();
        alert('Please enter a custom size value.');
        sizeCustom.focus();
        return false;
    }
    
    if (jenisSelect.value === 'other' && !jenisCustom.value.trim()) {
        e.preventDefault();
        alert('Please enter a custom jenis value.');
        jenisCustom.focus();
        return false;
    }
    
    
    const bay = document.getElementById('bay').value;
    const row = document.getElementById('row').value;
    const tier = document.getElementById('tier').value;
    
    if (!bay || !row || !tier) {
        const confirmSubmit = confirm(' Position (Bay-Row-Tier) tidak lengkap.\n\nContainer ini akan terdeteksi sebagai anomaly "Missing Position".\n\nLanjutkan submit?');
        if (!confirmSubmit) {
            e.preventDefault();
            return false;
        }
    }
});

<?php if(session('force_reload')): ?>
    console.log('🔄 Data updated, reloading containers array...');
    
    // Tunggu sebentar agar session tersimpan
    setTimeout(function() {
        console.log('✅ Reloading page to refresh data...');
        location.reload(); // Reload halaman untuk ambil data terbaru
    }, 500);
<?php endif; ?>

// DEBUG: Log saat halaman load (untuk troubleshooting)
window.addEventListener('DOMContentLoaded', function() {
    console.log('📝 Edit Container Form Loaded');
    console.log('Current Position:', {
        bay: document.getElementById('bay').value,
        row: document.getElementById('row').value,
        tier: document.getElementById('tier').value
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\baplie\laravel\resources\views/containers/edit.blade.php ENDPATH**/ ?>