<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'BAPLIE Manager')); ?></title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

    <!-- Custom Pelindo CSS -->
    <style>
        :root {
            /* Pelindo Blue Color Palette */
            --pelindo-primary: #0052CC;
            --pelindo-secondary: #1B365D;
            --pelindo-accent: #00A0E6;
            --pelindo-light-blue: #E6F3FF;
            --pelindo-dark-blue: #003D99;
            --pelindo-gray: #F8FAFC;
            --pelindo-border: #E2E8F0;
            --pelindo-text-primary: #1E293B;
            --pelindo-text-secondary: #64748B;
            --pelindo-success: #059669;
            --pelindo-warning: #D97706;
            --pelindo-danger: #DC2626;
            
            /* Bootstrap Variable Overrides */
            --bs-primary: var(--pelindo-primary);
            --bs-secondary: var(--pelindo-secondary);
            --bs-info: var(--pelindo-accent);
            --bs-success: var(--pelindo-success);
            --bs-warning: var(--pelindo-warning);
            --bs-danger: var(--pelindo-danger);
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: linear-gradient(135deg, var(--pelindo-light-blue) 0%, #ffffff 100%);
            color: var(--pelindo-text-primary);
            line-height: 1.6;
            min-height: 100vh;
        }

        /* Navigation Styling */
        .navbar {
            background: linear-gradient(135deg, var(--pelindo-primary) 0%, var(--pelindo-secondary) 100%) !important;
            box-shadow: 0 4px 20px rgba(0, 82, 204, 0.15);
            padding: 1rem 0;
            border-bottom: 3px solid var(--pelindo-accent);
        }

        .navbar-brand {
            font-weight: 700;
            font-size: 1.5rem;
            color: white !important;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .navbar-brand img {
            filter: brightness(0) invert(1);
        }

        .nav-link {
            color: rgba(255, 255, 255, 0.9) !important;
            font-weight: 500;
            padding: 0.75rem 1rem !important;
            border-radius: 8px;
            transition: all 0.3s ease;
            margin: 0 2px;
        }

        .nav-link:hover,
        .nav-link.active {
            background: rgba(255, 255, 255, 0.1);
            color: white !important;
            transform: translateY(-1px);
        }

        .navbar-text {
            background: rgba(255, 255, 255, 0.1);
            padding: 0.5rem 1rem;
            border-radius: 20px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            color: white !important;
            font-size: 0.875rem;
        }

        /* Card Styling */
        .card {
            background: white;
            border: none;
            border-radius: 16px;
            box-shadow: 0 4px 25px rgba(0, 82, 204, 0.08);
            transition: all 0.3s ease;
            overflow: hidden;
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 35px rgba(0, 82, 204, 0.12);
        }

        .card-header {
            background: linear-gradient(135deg, var(--pelindo-light-blue) 0%, #ffffff 100%);
            border-bottom: 2px solid var(--pelindo-border);
            padding: 1.25rem;
            font-weight: 600;
            color: var(--pelindo-primary);
        }

        .card-body {
            padding: 1.5rem;
        }

        /* Button Styling */
        .btn {
            border-radius: 10px;
            font-weight: 500;
            padding: 0.75rem 1.5rem;
            border: none;
            transition: all 0.3s ease;
            text-decoration: none;
            position: relative;
            overflow: hidden;
        }

        .btn:disabled {
            opacity: 0.6;
            transform: none !important;
            pointer-events: none;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--pelindo-primary) 0%, var(--pelindo-accent) 100%);
            box-shadow: 0 4px 15px rgba(0, 82, 204, 0.3);
        }

        .btn-primary:hover:not(:disabled) {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0, 82, 204, 0.4);
            background: linear-gradient(135deg, var(--pelindo-dark-blue) 0%, var(--pelindo-primary) 100%);
        }

        .btn-outline-primary {
            border: 2px solid var(--pelindo-primary);
            color: var(--pelindo-primary);
            background: transparent;
        }

        .btn-outline-primary:hover:not(:disabled) {
            background: var(--pelindo-primary);
            border-color: var(--pelindo-primary);
            transform: translateY(-1px);
        }

        .btn-outline-info {
            border: 2px solid var(--pelindo-accent);
            color: var(--pelindo-accent);
        }

        .btn-outline-info:hover:not(:disabled) {
            background: var(--pelindo-accent);
            border-color: var(--pelindo-accent);
        }

        .btn-outline-secondary {
            border: 2px solid var(--pelindo-text-secondary);
            color: var(--pelindo-text-secondary);
        }

        .btn-outline-secondary:hover:not(:disabled) {
            background: var(--pelindo-text-secondary);
            border-color: var(--pelindo-text-secondary);
        }

        .btn-sm {
            padding: 0.5rem 1rem;
            font-size: 0.875rem;
        }

        /* Alert Styling */
        .alert {
            border: none;
            border-radius: 12px;
            padding: 1rem 1.25rem;
            margin-bottom: 1.5rem;
            border-left: 4px solid;
        }

        .alert-success {
            background: linear-gradient(135deg, #ECFDF5 0%, #F0FDF4 100%);
            border-left-color: var(--pelindo-success);
            color: #065F46;
        }

        .alert-info {
            background: linear-gradient(135deg, var(--pelindo-light-blue) 0%, #F0F9FF 100%);
            border-left-color: var(--pelindo-accent);
            color: var(--pelindo-primary);
        }

        .alert-warning {
            background: linear-gradient(135deg, #FFFBEB 0%, #FEF3C7 100%);
            border-left-color: var(--pelindo-warning);
            color: #92400E;
        }

        .alert-danger {
            background: linear-gradient(135deg, #FEF2F2 0%, #FECACA 100%);
            border-left-color: var(--pelindo-danger);
            color: #991B1B;
        }

        /* Table Styling */
        .table {
            background: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 25px rgba(0, 82, 204, 0.05);
        }

        .table th {
            background: linear-gradient(135deg, var(--pelindo-primary) 0%, var(--pelindo-accent) 100%);
            color: rgb(247, 240, 240);
            font-weight: 600;
            border-bottom: 2px solid var(--pelindo-border);
            padding: 1rem;
            text-align: center;
        }

        .table td {
            padding: 1rem;
            vertical-align: middle;
            border-bottom: 1px solid var(--pelindo-border);
            color: #1e293b;
            background-color: #f9fafb;
        }

        .table-striped tbody tr:nth-of-type(odd) {
            background: rgba(0, 82, 204, 0.02);
        }

        /* Badge Styling */
        .badge {
            font-weight: 500;
            padding: 0.5rem 0.75rem;
            border-radius: 20px;
            font-size: 0.75rem;
        }

        .badge.bg-success {
            background: linear-gradient(135deg, var(--pelindo-success) 0%, #10B981 100%) !important;
        }

        .badge.bg-warning {
            background: linear-gradient(135deg, var(--pelindo-warning) 0%, #F59E0B 100%) !important;
        }

        .badge.bg-danger {
            background: linear-gradient(135deg, var(--pelindo-danger) 0%, #EF4444 100%) !important;
        }

        .badge.bg-primary {
            background: linear-gradient(135deg, var(--pelindo-primary) 0%, var(--pelindo-accent) 100%) !important;
        }

        /* Form Styling */
        .form-control,
        .form-select {
            border: 2px solid var(--pelindo-border);
            border-radius: 10px;
            padding: 0.75rem 1rem;
            transition: all 0.3s ease;
            background: white;
        }

        .form-control:focus,
        .form-select:focus {
            border-color: var(--pelindo-accent);
            box-shadow: 0 0 0 0.2rem rgba(0, 160, 230, 0.15);
            outline: none;
        }

        .form-label {
            font-weight: 500;
            color: var(--pelindo-text-primary);
            margin-bottom: 0.5rem;
        }

        /* ✅ UPLOAD CARD STYLING - NEW */
        .upload-card {
            border: 2px dashed var(--pelindo-border);
            border-radius: 16px;
            padding: 1.5rem;
            background: linear-gradient(135deg, #F8FAFC 0%, #FFFFFF 100%);
            transition: all 0.3s ease;
            cursor: pointer;
            position: relative;
        }

        .upload-card:hover {
            border-color: var(--pelindo-accent);
            background: linear-gradient(135deg, var(--pelindo-light-blue) 0%, #FFFFFF 100%);
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0, 82, 204, 0.1);
        }

        .upload-card.has-file {
            border-color: var(--pelindo-success);
            border-style: solid;
            background: linear-gradient(135deg, #ECFDF5 0%, #FFFFFF 100%);
        }

        .upload-card.has-error {
            border-color: var(--pelindo-danger);
            border-style: solid;
            background: linear-gradient(135deg, #FEF2F2 0%, #FFFFFF 100%);
        }

        .upload-icon {
            font-size: 3rem;
            color: var(--pelindo-accent);
            opacity: 0.6;
            transition: all 0.3s ease;
        }

        .upload-card:hover .upload-icon {
            opacity: 1;
            transform: scale(1.1);
        }

        .upload-card.has-file .upload-icon {
            color: var(--pelindo-success);
            opacity: 1;
        }

        .file-input-wrapper {
            position: relative;
            overflow: hidden;
        }

        .file-input-wrapper input[type="file"] {
            position: absolute;
            left: 0;
            top: 0;
            opacity: 0;
            cursor: pointer;
            width: 100%;
            height: 100%;
        }

        .file-info-box {
            background: white;
            border: 1px solid var(--pelindo-border);
            border-radius: 10px;
            padding: 0.75rem 1rem;
            margin-top: 0.75rem;
            display: none;
        }

        .file-info-box.show {
            display: block;
            animation: slideDown 0.3s ease;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .upload-scenario-badge {
            position: absolute;
            top: 1rem;
            right: 1rem;
            font-size: 0.75rem;
            padding: 0.35rem 0.75rem;
        }

        /* Dropdown Styling */
        .dropdown-menu {
            border: none;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0, 82, 204, 0.15);
            padding: 0.5rem 0;
        }

        .dropdown-item {
            padding: 0.75rem 1.5rem;
            transition: all 0.2s ease;
            border-radius: 8px;
            margin: 0 0.5rem;
        }

        .dropdown-item:hover {
            background: var(--pelindo-light-blue);
            color: var(--pelindo-primary);
        }

        /* Footer Styling */
        .footer {
            background: linear-gradient(135deg, var(--pelindo-secondary) 0%, var(--pelindo-primary) 100%);
            color: white;
            margin-top: 3rem;
            padding: 2rem 0;
            border-top: 3px solid var(--pelindo-accent);
        }

        .footer a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .footer a:hover {
            color: white;
        }

        /* Page Header Styling */
        .page-header {
            background: linear-gradient(135deg, var(--pelindo-light-blue) 0%, white 100%);
            padding: 2rem 0;
            margin-bottom: 2rem;
            border-bottom: 1px solid var(--pelindo-border);
        }

        .page-header h1,
        .page-header h2 {
            color: var(--pelindo-primary);
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .page-header .text-muted {
            color: var(--pelindo-text-secondary) !important;
        }

        /* Custom Container Fluid */
        .container-fluid {
            max-width: 1400px;
            margin: 0 auto;
        }

        /* Loading Animation */
        .loading {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        /* Status Indicators */
        .status-indicator {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 8px;
        }

        .status-success {
            background: var(--pelindo-success);
            box-shadow: 0 0 0 3px rgba(5, 150, 105, 0.2);
        }

        .status-warning {
            background: var(--pelindo-warning);
            box-shadow: 0 0 0 3px rgba(217, 119, 6, 0.2);
        }

        .status-danger {
            background: var(--pelindo-danger);
            box-shadow: 0 0 0 3px rgba(220, 38, 38, 0.2);
        }

        /* Enhanced Spacing */
        .py-4 { padding-top: 2rem !important; padding-bottom: 2rem !important; }
        .mb-4 { margin-bottom: 2rem !important; }
        .mt-4 { margin-top: 2rem !important; }

        /* Modal Backdrop Fix */
        .modal-backdrop {
            z-index: 1040;
        }

        .modal {
            z-index: 1050;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .navbar-brand {
                font-size: 1.25rem;
            }
            
            .card {
                margin-bottom: 1rem;
            }
            
            .btn {
                padding: 0.625rem 1.25rem;
            }
            
            .container-fluid {
                padding-left: 1rem;
                padding-right: 1rem;
            }

            .upload-card {
                padding: 1rem;
            }

            .upload-icon {
                font-size: 2rem;
            }
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="d-flex flex-column min-vh-100">
    
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-ship"></i>
            </a>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="#">
                            <img src="<?php echo e(asset('images/logo pelindo.png')); ?>" alt="Logo" height="32" style="filter: brightness(0) invert(1);">
                        </a>
                    </li>
                </ul>
                
                <!-- Navbar menu kanan -->
                <ul class="navbar-nav ms-auto">
                    <!-- Dropdown File -->
                    <?php if(request()->routeIs('dashboard') || request()->routeIs('baplie.management')): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-file-earmark"></i> File
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#uploadModal">
                                    <i class="bi bi-upload"></i> Upload Files
                                </a>
                            </li>
                            <?php if(session('containers')): ?>
                            <li>
                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#uploadAdditionalModal">
                                    <i class="bi bi-file-earmark-plus"></i> Add Excel Data
                                </a>
                            </li>
                            <?php endif; ?>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('baplie.export-edi')); ?>">
                                    <i class="bi bi-download"></i> Export EDI
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(asset('documents/buku-petunjuk.pdf')); ?>" target="_blank">
                                    <i class="bi bi-book"></i> Buku Petunjuk
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <form action="<?php echo e(route('data.delete')); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure to delete all data?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="dropdown-item text-danger">
                                        <i class="bi bi-trash"></i> Delete All Data
                                    </button>
                                </form>
                            </li>
                        </ul>
                    </li>
                    <?php endif; ?>
                    
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>" 
                           href="<?php echo e(route('dashboard')); ?>">
                            <i class="bi bi-house-door"></i> Dashboard
                        </a>
                    </li>
                    
                    <?php if(session('containers')): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(request()->routeIs('bayplan.*') ? 'active' : ''); ?>" 
                               href="<?php echo e(route('bayplan.index')); ?>">
                                <i class="bi bi-grid-3x3"></i> Bayview
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- ✅ MODAL UPLOAD UTAMA - IMPROVED -->
    <div class="modal fade" id="uploadModal" tabindex="-1" aria-labelledby="uploadModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <form action="<?php echo e(route('baplie.upload')); ?>" method="POST" enctype="multipart/form-data" class="modal-content" id="uploadForm">
                <?php echo csrf_field(); ?>
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="uploadModalLabel">
                        <i class="bi bi-cloud-upload"></i> Upload Files
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- Upload Scenarios Info -->
                    <div class="alert alert-info mb-4">
                        <h6 class="alert-heading mb-2">
                            <i class="bi bi-info-circle"></i> Upload Options
                        </h6>
                        <ul class="mb-0 small">
                            <li><strong>BAPLIE only:</strong> Upload .edi/.txt file for container data</li>
                            <li><strong>Excel only:</strong> Upload .xlsx/.xls file with container data</li>
                            <li><strong>Both files:</strong> BAPLIE data will be merged with Excel data</li>
                            <li><strong>Sequential:</strong> Upload BAPLIE first, then add Excel later via "Add Excel Data"</li>
                        </ul>
                    </div>

                    <!-- Upload Scenario Badge -->
                    <div class="text-center mb-3">
                        <span class="badge bg-secondary" id="scenarioBadge">
                            <i class="bi bi-question-circle"></i> Select file(s) to upload
                        </span>
                    </div>

                    <div class="row g-4">
                        <!-- BAPLIE File Upload -->
                        <div class="col-md-6">
                            <div class="upload-card" id="baplieCard">
                                <div class="upload-scenario-badge">
                                    <span class="badge bg-info">Optional</span>
                                </div>
                                <div class="text-center">
                                    <i class="bi bi-file-earmark-code upload-icon"></i>
                                    <h6 class="mt-3 mb-2">BAPLIE File</h6>
                                    <p class="text-muted small mb-3">
                                        .edi or .txt format<br>
                                        Maximum 5MB
                                    </p>
                                    <div class="file-input-wrapper">
                                        <button type="button" class="btn btn-outline-primary btn-sm">
                                            <i class="bi bi-folder2-open"></i> Browse File
                                        </button>
                                        <input type="file" 
                                               class="form-control <?php $__errorArgs = ['baplie_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               id="baplie_file" 
                                               name="baplie_file" 
                                               accept=".edi,.txt">
                                    </div>
                                </div>
                                <div class="file-info-box" id="baplieInfo"></div>
                                <?php $__errorArgs = ['baplie_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger small mt-2"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Excel File Upload -->
                        <div class="col-md-6">
                            <div class="upload-card" id="excelCard">
                                <div class="upload-scenario-badge">
                                    <span class="badge bg-info">Optional</span>
                                </div>
                                <div class="text-center">
                                    <i class="bi bi-file-earmark-spreadsheet upload-icon"></i>
                                    <h6 class="mt-3 mb-2">Excel File</h6>
                                    <p class="text-muted small mb-3">
                                        .xlsx or .xls format<br>
                                        Maximum 5MB
                                    </p>
                                    <div class="file-input-wrapper">
                                        <button type="button" class="btn btn-outline-success btn-sm">
                                            <i class="bi bi-folder2-open"></i> Browse File
                                        </button>
                                        <input type="file" 
                                               class="form-control <?php $__errorArgs = ['excel_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               id="excel_file" 
                                               name="excel_file" 
                                               accept=".xlsx,.xls">
                                    </div>
                                </div>
                                <div class="file-info-box" id="excelInfo"></div>
                                <?php $__errorArgs = ['excel_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger small mt-2"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <!-- Warning Message -->
                    <div class="alert alert-warning mt-4" id="fileWarning" style="display: none;">
                        <i class="bi bi-exclamation-triangle"></i>
                        Please select at least one file to upload.
                    </div>

                    <!-- Upload Progress (Hidden by default) -->
                    <div class="mt-4" id="uploadProgress" style="display: none;">
                        <div class="progress" style="height: 25px;">
                            <div class="progress-bar progress-bar-striped progress-bar-animated" 
                                 role="progressbar" 
                                 style="width: 0%"
                                 id="progressBar">
                                <span id="progressText">Uploading...</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="bi bi-x-circle"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-primary" id="uploadBtn" disabled>
                        <i class="bi bi-cloud-upload"></i> Upload & Process
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- ✅ MODAL UPLOAD EXCEL TAMBAHAN (Muncul jika sudah ada data) -->
    <?php if(session('containers')): ?>
    <div class="modal fade" id="uploadAdditionalModal" tabindex="-1" aria-labelledby="uploadAdditionalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <form action="<?php echo e(route('baplie.upload-additional-excel')); ?>" method="POST" enctype="multipart/form-data" class="modal-content" id="additionalForm">
                <?php echo csrf_field(); ?>
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title" id="uploadAdditionalLabel">
                        <i class="bi bi-file-earmark-plus"></i> Add Excel Data
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info">
                        <h6 class="alert-heading">
                            <i class="bi bi-info-circle"></i> Add or Update Container Data
                        </h6>
                        <p class="mb-0 small">
                            Upload an Excel file to add new containers or update existing ones. 
                            The system will automatically merge the data with your current BAPLIE data.
                        </p>
                    </div>

                    <div class="upload-card" id="additionalExcelCard">
                        <div class="text-center">
                            <i class="bi bi-file-earmark-spreadsheet upload-icon"></i>
                            <h6 class="mt-3 mb-2">Select Excel File</h6>
                            <p class="text-muted small mb-3">
                                .xlsx or .xls format • Maximum 5MB
                            </p>
                            <div class="file-input-wrapper">
                                <button type="button" class="btn btn-success">
                                    <i class="bi bi-folder2-open"></i> Browse Excel File
                                </button>
                                <input type="file" 
                                       class="form-control" 
                                       id="additional_excel_file" 
                                       name="excel_file" 
                                       accept=".xlsx,.xls"
                                       required>
                            </div>
                        </div>
                        <div class="file-info-box" id="additionalExcelInfo"></div>
                    </div>

                    <div class="alert alert-warning mt-3" id="additionalFileWarning" style="display: none;">
                        <i class="bi bi-exclamation-triangle"></i>
                        Please select an Excel file to upload.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="bi bi-x-circle"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-success" id="additionalUploadBtn" disabled>
                        <i class="bi bi-file-earmark-plus"></i> Add Excel Data
                    </button>
                </div>
            </form>
        </div>
    </div>
    <?php endif; ?>

    <main class="flex-grow-1" style="padding-top: 70px;">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-md-6">
                </div>
                <div class="col-md-6 text-md-end">
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- ✅ ENHANCED JAVASCRIPT -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // ===== MAIN UPLOAD FORM =====
            const uploadForm = document.getElementById('uploadForm');
            const uploadBtn = document.getElementById('uploadBtn');
            const baplieInput = document.getElementById('baplie_file');
            const excelInput = document.getElementById('excel_file');
            const fileWarning = document.getElementById('fileWarning');
            const baplieInfo = document.getElementById('baplieInfo');
            const excelInfo = document.getElementById('excelInfo');
            const baplieCard = document.getElementById('baplieCard');
            const excelCard = document.getElementById('excelCard');
            const scenarioBadge = document.getElementById('scenarioBadge');
            const uploadProgress = document.getElementById('uploadProgress');
            const progressBar = document.getElementById('progressBar');
            const progressText = document.getElementById('progressText');

            // ===== ADDITIONAL EXCEL FORM =====
            const additionalForm = document.getElementById('additionalForm');
            const additionalUploadBtn = document.getElementById('additionalUploadBtn');
            const additionalExcelInput = document.getElementById('additional_excel_file');
            const additionalExcelInfo = document.getElementById('additionalExcelInfo');
            const additionalExcelCard = document.getElementById('additionalExcelCard');
            const additionalFileWarning = document.getElementById('additionalFileWarning');

            // ===== UPDATE SCENARIO BADGE =====
            function updateScenarioBadge() {
                const hasBaplie = baplieInput && baplieInput.files.length > 0;
                const hasExcel = excelInput && excelInput.files.length > 0;
                
                let badgeHTML = '';
                let badgeClass = 'bg-secondary';

                if (hasBaplie && hasExcel) {
                    badgeHTML = '<i class="bi bi-files"></i> Both Files (BAPLIE + Excel Merge)';
                    badgeClass = 'bg-primary';
                } else if (hasBaplie) {
                    badgeHTML = '<i class="bi bi-file-earmark-code"></i> BAPLIE Only';
                    badgeClass = 'bg-info';
                } else if (hasExcel) {
                    badgeHTML = '<i class="bi bi-file-earmark-spreadsheet"></i> Excel Only';
                    badgeClass = 'bg-success';
                } else {
                    badgeHTML = '<i class="bi bi-question-circle"></i> Select file(s) to upload';
                    badgeClass = 'bg-secondary';
                }

                if (scenarioBadge) {
                    scenarioBadge.className = `badge ${badgeClass}`;
                    scenarioBadge.innerHTML = badgeHTML;
                }
            }

            // ===== VALIDATE DUAL FILE UPLOAD =====
            function validateDualFileUpload() {
                const hasBaplie = baplieInput && baplieInput.files.length > 0;
                const hasExcel = excelInput && excelInput.files.length > 0;
                
                if (!hasBaplie && !hasExcel) {
                    if (fileWarning) fileWarning.style.display = 'block';
                    if (uploadBtn) uploadBtn.disabled = true;
                } else {
                    if (fileWarning) fileWarning.style.display = 'none';
                    
                    // Check if any file has validation error
                    const baplieHasError = baplieInput && baplieInput.classList.contains('is-invalid');
                    const excelHasError = excelInput && excelInput.classList.contains('is-invalid');
                    
                    if (uploadBtn) {
                        uploadBtn.disabled = baplieHasError || excelHasError;
                    }
                }

                updateScenarioBadge();
            }

            // ===== VALIDATE INDIVIDUAL FILE =====
            function validateFile(input, infoDiv, card, allowedExtensions, maxSize = 5) {
                const file = input.files[0];
                
                // Reset validation
                input.classList.remove('is-invalid', 'is-valid');
                if (card) card.classList.remove('has-file', 'has-error');
                if (infoDiv) {
                    infoDiv.innerHTML = '';
                    infoDiv.classList.remove('show');
                }
                
                if (!file) {
                    validateDualFileUpload();
                    return true; // File optional
                }
                
                // Validate extension
                const fileExtension = '.' + file.name.split('.').pop().toLowerCase();
                if (!allowedExtensions.includes(fileExtension)) {
                    input.classList.add('is-invalid');
                    if (card) card.classList.add('has-error');
                    if (infoDiv) {
                        infoDiv.innerHTML = `
                            <div class="d-flex align-items-center text-danger">
                                <i class="bi bi-x-circle me-2"></i>
                                <div>
                                    <strong>Invalid format</strong><br>
                                    <small>Allowed: ${allowedExtensions.join(', ')}</small>
                                </div>
                            </div>
                        `;
                        infoDiv.classList.add('show');
                    }
                    validateDualFileUpload();
                    return false;
                }
                
                // Validate size
                const maxSizeBytes = maxSize * 1024 * 1024;
                if (file.size > maxSizeBytes) {
                    input.classList.add('is-invalid');
                    if (card) card.classList.add('has-error');
                    if (infoDiv) {
                        infoDiv.innerHTML = `
                            <div class="d-flex align-items-center text-danger">
                                <i class="bi bi-x-circle me-2"></i>
                                <div>
                                    <strong>File too large</strong><br>
                                    <small>Maximum: ${maxSize}MB</small>
                                </div>
                            </div>
                        `;
                        infoDiv.classList.add('show');
                    }
                    validateDualFileUpload();
                    return false;
                }
                
                // File valid
                input.classList.add('is-valid');
                if (card) card.classList.add('has-file');
                const fileSizeMB = (file.size / 1024 / 1024).toFixed(2);
                if (infoDiv) {
                    infoDiv.innerHTML = `
                        <div class="d-flex align-items-center justify-content-between text-success">
                            <div class="d-flex align-items-center">
                                <i class="bi bi-check-circle-fill me-2"></i>
                                <div>
                                    <strong>${file.name}</strong><br>
                                    <small>${fileSizeMB} MB</small>
                                </div>
                            </div>
                            <button type="button" class="btn btn-sm btn-outline-danger" onclick="this.closest('.upload-card').querySelector('input[type=file]').value=''; this.closest('.upload-card').querySelector('input[type=file]').dispatchEvent(new Event('change'));">
                                <i class="bi bi-x"></i>
                            </button>
                        </div>
                    `;
                    infoDiv.classList.add('show');
                }
                validateDualFileUpload();
                return true;
            }

            // ===== EVENT LISTENERS FOR MAIN FORM =====
            if (baplieInput) {
                baplieInput.addEventListener('change', function() {
                    validateFile(this, baplieInfo, baplieCard, ['.edi', '.txt'], 5);
                });
            }

            if (excelInput) {
                excelInput.addEventListener('change', function() {
                    validateFile(this, excelInfo, excelCard, ['.xlsx', '.xls'], 5);
                });
            }

            // ===== MAIN FORM SUBMISSION =====
            if (uploadForm) {
                uploadForm.addEventListener('submit', function(e) {
                    // Validate at least one file selected
                    const hasBaplie = baplieInput && baplieInput.files.length > 0;
                    const hasExcel = excelInput && excelInput.files.length > 0;
                    
                    if (!hasBaplie && !hasExcel) {
                        e.preventDefault();
                        if (fileWarning) fileWarning.style.display = 'block';
                        if (uploadBtn) uploadBtn.disabled = true;
                        return false;
                    }

                    // Validate file formats
                    let isValid = true;
                    if (hasBaplie && baplieInput.classList.contains('is-invalid')) {
                        isValid = false;
                    }
                    if (hasExcel && excelInput.classList.contains('is-invalid')) {
                        isValid = false;
                    }

                    if (!isValid) {
                        e.preventDefault();
                        return false;
                    }

                    // Show loading state
                    if (uploadBtn) {
                        uploadBtn.disabled = true;
                        uploadBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Processing...';
                    }

                    // Show progress bar
                    if (uploadProgress) {
                        uploadProgress.style.display = 'block';
                        let progress = 0;
                        const interval = setInterval(() => {
                            progress += Math.random() * 15;
                            if (progress > 90) progress = 90;
                            if (progressBar) {
                                progressBar.style.width = progress + '%';
                                progressText.textContent = `Uploading... ${Math.round(progress)}%`;
                            }
                        }, 500);

                        // Store interval for cleanup
                        window.uploadInterval = interval;
                    }
                });
            }

            // ===== ADDITIONAL EXCEL FORM VALIDATION =====
            if (additionalExcelInput) {
                additionalExcelInput.addEventListener('change', function() {
                    const file = this.files[0];
                    
                    // Reset
                    this.classList.remove('is-invalid', 'is-valid');
                    if (additionalExcelCard) additionalExcelCard.classList.remove('has-file', 'has-error');
                    if (additionalExcelInfo) {
                        additionalExcelInfo.innerHTML = '';
                        additionalExcelInfo.classList.remove('show');
                    }
                    if (additionalFileWarning) additionalFileWarning.style.display = 'none';
                    
                    if (!file) {
                        if (additionalUploadBtn) additionalUploadBtn.disabled = true;
                        if (additionalFileWarning) additionalFileWarning.style.display = 'block';
                        return;
                    }
                    
                    // Validate
                    const fileExtension = '.' + file.name.split('.').pop().toLowerCase();
                    const allowedExtensions = ['.xlsx', '.xls'];
                    const maxSizeBytes = 5 * 1024 * 1024;
                    
                    if (!allowedExtensions.includes(fileExtension)) {
                        this.classList.add('is-invalid');
                        if (additionalExcelCard) additionalExcelCard.classList.add('has-error');
                        if (additionalExcelInfo) {
                            additionalExcelInfo.innerHTML = `
                                <div class="d-flex align-items-center text-danger">
                                    <i class="bi bi-x-circle me-2"></i>
                                    <div>
                                        <strong>Invalid format</strong><br>
                                        <small>Allowed: .xlsx, .xls</small>
                                    </div>
                                </div>
                            `;
                            additionalExcelInfo.classList.add('show');
                        }
                        if (additionalUploadBtn) additionalUploadBtn.disabled = true;
                        return;
                    }
                    
                    if (file.size > maxSizeBytes) {
                        this.classList.add('is-invalid');
                        if (additionalExcelCard) additionalExcelCard.classList.add('has-error');
                        if (additionalExcelInfo) {
                            additionalExcelInfo.innerHTML = `
                                <div class="d-flex align-items-center text-danger">
                                    <i class="bi bi-x-circle me-2"></i>
                                    <div>
                                        <strong>File too large</strong><br>
                                        <small>Maximum: 5MB</small>
                                    </div>
                                </div>
                            `;
                            additionalExcelInfo.classList.add('show');
                        }
                        if (additionalUploadBtn) additionalUploadBtn.disabled = true;
                        return;
                    }
                    
                    // Valid
                    this.classList.add('is-valid');
                    if (additionalExcelCard) additionalExcelCard.classList.add('has-file');
                    const fileSizeMB = (file.size / 1024 / 1024).toFixed(2);
                    if (additionalExcelInfo) {
                        additionalExcelInfo.innerHTML = `
                            <div class="d-flex align-items-center justify-content-between text-success">
                                <div class="d-flex align-items-center">
                                    <i class="bi bi-check-circle-fill me-2"></i>
                                    <div>
                                        <strong>${file.name}</strong><br>
                                        <small>${fileSizeMB} MB</small>
                                    </div>
                                </div>
                                <button type="button" class="btn btn-sm btn-outline-danger" onclick="document.getElementById('additional_excel_file').value=''; document.getElementById('additional_excel_file').dispatchEvent(new Event('change'));">
                                    <i class="bi bi-x"></i>
                                </button>
                            </div>
                        `;
                        additionalExcelInfo.classList.add('show');
                    }
                    if (additionalUploadBtn) additionalUploadBtn.disabled = false;
                });
            }

            // ===== ADDITIONAL FORM SUBMISSION =====
            if (additionalForm) {
                additionalForm.addEventListener('submit', function(e) {
                    const hasFile = additionalExcelInput && additionalExcelInput.files.length > 0;
                    
                    if (!hasFile) {
                        e.preventDefault();
                        if (additionalFileWarning) additionalFileWarning.style.display = 'block';
                        return false;
                    }

                    if (additionalExcelInput.classList.contains('is-invalid')) {
                        e.preventDefault();
                        return false;
                    }

                    // Show loading
                    if (additionalUploadBtn) {
                        additionalUploadBtn.disabled = true;
                        additionalUploadBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Adding Data...';
                    }
                });
            }

            // ===== MODAL RESET HANDLERS =====
            const uploadModal = document.getElementById('uploadModal');
            if (uploadModal) {
                uploadModal.addEventListener('hidden.bs.modal', function() {
                    // Reset form
                    if (uploadForm) uploadForm.reset();
                    
                    // Clear intervals
                    if (window.uploadInterval) {
                        clearInterval(window.uploadInterval);
                        window.uploadInterval = null;
                    }
                    
                    // Reset validation
                    [baplieInput, excelInput].forEach(input => {
                        if (input) input.classList.remove('is-valid', 'is-invalid');
                    });
                    
                    // Reset cards
                    [baplieCard, excelCard].forEach(card => {
                        if (card) card.classList.remove('has-file', 'has-error');
                    });
                    
                    // Clear info
                    [baplieInfo, excelInfo].forEach(info => {
                        if (info) {
                            info.innerHTML = '';
                            info.classList.remove('show');
                        }
                    });
                    
                    // Reset button
                    if (uploadBtn) {
                        uploadBtn.disabled = true;
                        uploadBtn.innerHTML = '<i class="bi bi-cloud-upload"></i> Upload & Process';
                    }
                    
                    // Hide warnings and progress
                    if (fileWarning) fileWarning.style.display = 'none';
                    if (uploadProgress) uploadProgress.style.display = 'none';
                    if (progressBar) progressBar.style.width = '0%';
                    
                    // Reset badge
                    updateScenarioBadge();
                });
            }

            const additionalModal = document.getElementById('uploadAdditionalModal');
            if (additionalModal) {
                additionalModal.addEventListener('hidden.bs.modal', function() {
                    // Reset form
                    if (additionalForm) additionalForm.reset();
                    
                    // Reset validation
                    if (additionalExcelInput) {
                        additionalExcelInput.classList.remove('is-valid', 'is-invalid');
                    }
                    
                    // Reset card
                    if (additionalExcelCard) {
                        additionalExcelCard.classList.remove('has-file', 'has-error');
                    }
                    
                    // Clear info
                    if (additionalExcelInfo) {
                        additionalExcelInfo.innerHTML = '';
                        additionalExcelInfo.classList.remove('show');
                    }
                    
                    // Reset button
                    if (additionalUploadBtn) {
                        additionalUploadBtn.disabled = true;
                        additionalUploadBtn.innerHTML = '<i class="bi bi-file-earmark-plus"></i> Add Excel Data';
                    }
                    
                    // Hide warning
                    if (additionalFileWarning) additionalFileWarning.style.display = 'none';
                });
            }

            // ===== INITIAL VALIDATION =====
            validateDualFileUpload();

            // ===== AUTO-HIDE ALERTS =====
            const alerts = document.querySelectorAll('.alert-dismissible');
            alerts.forEach(function(alert) {
                alert.style.opacity = '0';
                alert.style.transform = 'translateX(-20px)';
                
                setTimeout(() => {
                    alert.style.transition = 'all 0.3s ease';
                    alert.style.opacity = '1';
                    alert.style.transform = 'translateX(0)';
                }, 100);
                
                setTimeout(function() {
                    alert.style.transition = 'all 0.5s ease';
                    alert.style.opacity = '0';
                    alert.style.transform = 'translateX(20px)';
                    
                    setTimeout(() => {
                        if (alert.parentNode) {
                            alert.parentNode.removeChild(alert);
                        }
                    }, 500);
                }, 5000);
            });

            // ===== SMOOTH SCROLLING =====
            const anchorLinks = document.querySelectorAll('a[href^="#"]');
            anchorLinks.forEach(function(link) {
                link.addEventListener('click', function(e) {
                    const href = this.getAttribute('href');
                    
                    if (!href || href === '#' || href.length <= 1 || this.hasAttribute('data-bs-toggle')) {
                        return;
                    }
                    
                    e.preventDefault();
                    const target = document.querySelector(href);
                    if (target) {
                        target.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                });
            });

            // ===== TOOLTIP INITIALIZATION =====
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl, {
                    animation: true,
                    delay: { show: 300, hide: 100 }
                });
            });
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\xampp82\htdocs\laravel-app\resources\views/layouts/app.blade.php ENDPATH**/ ?>