

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">
    <style>
        :root {
            --primary-blue: #0052cc;
            --secondary-blue: #0a3d91;
            --accent-green: #28a745;
            --accent-red: #dc3545;
            --accent-orange: #fd7e14;
            --light-bg: #f8f9fa;
            --white: #ffffff;
            --border-color: #dee2e6;
            --text-muted: #6c757d;
        }

        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
        }
        
        .navbar {
            background: linear-gradient(90deg, var(--primary-blue), var(--secondary-blue)) !important;
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        }
        
        /* View Tabs */
        .view-tabs {
            display: flex;
            gap: 8px;
            padding: 12px 20px;
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            border-bottom: 2px solid var(--border-color);
        }

        .view-tab {
            padding: 10px 20px;
            border-radius: 8px;
            background: white;
            border: 2px solid #dee2e6;
            color: #6c757d;
            font-weight: 600;
            font-size: 13px;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .view-tab:hover {
            border-color: var(--primary-blue);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }

        .view-tab.active {
            background: linear-gradient(135deg, var(--primary-blue), var(--secondary-blue));
            color: white;
            border-color: var(--primary-blue);
        }

        .view-content {
            display: none;
        }

        .view-content.active {
            display: block;
        }
        
        .main-container {
            display: flex;
            height: calc(100vh - 140px);
            gap: 12px;
            padding: 12px;
        }
        
        .bayplan-section {
            flex: 1;
            background: var(--white);
            border-radius: 12px;
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .container-list-section {
            width: 320px;
            background: var(--white);
            border-radius: 12px;
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
            display: flex;
            flex-direction: column;
        }
        
        .section-header {
            background: linear-gradient(90deg, var(--primary-blue), var(--secondary-blue));
            color: white;
            padding: 12px 18px;
            font-weight: 600;
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 14px;
        }
        
        .vessel-info {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 0;
        }
        
        .vessel-info i {
            font-size: 18px;
        }
        
        .controls-bar {
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            padding: 10px 15px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            gap: 12px;
            align-items: center;
            flex-wrap: wrap;
            justify-content: space-between;
        }
        
        .filter-section {
            display: flex;
            gap: 12px;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .bayplan-panel {
            background: var(--white);
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
            margin-bottom: 12px;
            padding: 12px;
        }
        
        .panel-title {
            font-size: 11px;
            font-weight: 700;
            color: #495057;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border-bottom: 2px solid var(--primary-blue);
            padding-bottom: 6px;
            margin-bottom: 10px;
        }
        
        .bayplan-grid-container {
            flex: 1;
            overflow: auto;
            padding: 12px;
            background: #fafbfc;
        }
        
        .bayplan-grid {
            display: grid;
            gap: 2px;
            min-width: 750px;
            background: white;
            padding: 0;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.06);
        }
        
        .grid-header, .row-header {
            background: linear-gradient(135deg, #495057, #6c757d);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 9px;
            font-weight: bold;
            border-radius: 3px;
            padding: 2px;
        }
        
        .container-slot {
            border: 1px solid #e9ecef;
            border-radius: 3px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 7px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.2s ease;
            position: relative;
            overflow: hidden;
            min-height: 26px;
        }
        
        .container-slot:hover {
            transform: scale(1.08);
            z-index: 10;
            box-shadow: 0 6px 16px rgba(0,0,0,0.25);
            border-color: var(--primary-blue);
        }
        
        .container-slot.empty {
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            border-color: #dee2e6;
            opacity: 0.5;
        }
        
        .container-slot.length-20 {
            background: linear-gradient(135deg, #ffd700, #ffed4a);
            color: #8b4513;
            border-color: #d4a017;
        }
        
        .container-slot.length-40 {
            background: linear-gradient(135deg, #87ceeb, #4682b4);
            color: #000080;
            border-color: #4682b4;
        }
        
        .container-slot.length-45 {
            background: linear-gradient(135deg, #dda0dd, #9370db);
            color: #4b0082;
            border-color: #9370db;
        }

        .container-slot.status-full {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
            border-color: #28a745;
        }

        .container-slot.status-empty {
            background: linear-gradient(135deg, #6c757d, #adb5bd);
            color: white;
            border-color: #6c757d;
        }

        .container-slot.weight-light {
            background: linear-gradient(135deg, #17a2b8, #20c997);
            color: white;
            border-color: #17a2b8;
        }

        .container-slot.weight-medium {
            background: linear-gradient(135deg, #ffc107, #fd7e14);
            color: #212529;
            border-color: #ffc107;
        }

        .container-slot.weight-heavy {
            background: linear-gradient(135deg, #dc3545, #c82333);
            color: white;
            border-color: #dc3545;
        }
        
        .container-slot.selected {
            border: 2px solid #dc3545 !important;
            background: linear-gradient(135deg, rgba(220, 53, 69, 0.2), rgba(220, 53, 69, 0.1)) !important;
            animation: pulse 1.5s infinite;
        }

        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(220, 53, 69, 0.7); }
            70% { box-shadow: 0 0 0 8px rgba(220, 53, 69, 0); }
            100% { box-shadow: 0 0 0 0 rgba(220, 53, 69, 0); }
        }
        
        .container-text {
            font-size: 7px;
            line-height: 1.1;
            text-align: center;
            width: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            text-shadow: 0 1px 2px rgba(0,0,0,0.1);
        }
        
        .legend {
            display: flex;
            gap: 15px;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .legend-item {
            display: flex;
            align-items: center;
            gap: 6px;
            font-size: 11px;
            font-weight: 500;
        }
        
        .legend-color {
            width: 20px;
            height: 14px;
            border-radius: 3px;
            border: 1px solid #ccc;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        
        .container-list {
            flex: 1;
            max-height: calc(100vh - 380px); 
            overflow-y: auto;
            padding: 0;
        }
        
        .container-item {
            display: flex;
            align-items: center;
            padding: 8px 12px;
            border-bottom: 1px solid #f1f1f1;
            cursor: pointer;
            transition: all 0.2s ease;
        }
        
        .container-item:hover {
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            transform: translateX(3px);
        }
        
        .container-item.selected {
            background: linear-gradient(135deg, #e3f2fd, #bbdefb);
            border-left: 3px solid var(--primary-blue);
        }
        
        .container-number {
            font-family: 'Courier New', monospace;
            font-weight: bold;
            font-size: 10px;
            width: 85px;
        }
        
        .container-details {
            flex: 1;
            font-size: 9px;
            line-height: 1.3;
        }
        
        .container-type-indicator {
            width: 12px;
            height: 12px;
            border-radius: 2px;
            margin-right: 8px;
            border: 1px solid #ccc;
            flex-shrink: 0;
        }
        
        .search-container {
            padding: 12px 15px;
            border-bottom: 1px solid var(--border-color);
            background: var(--light-bg);
        }
        
        .search-input {
            border: 2px solid #ddd;
            border-radius: 0 8px 8px 0;
            padding: 8px 12px;
            width: 100%;
            font-size: 12px;
            transition: border-color 0.3s ease;
            height: 36px;
        }
        
        .search-container .input-group > span { 
            display: flex;
            align-items: center;
            justify-content: center;
            height: 36px;
            padding: 0 10px; 
            background: var(--light-bg);
            border: 2px solid #ddd;
            border-right: none;
            border-radius: 8px 0 0 8px;
        }

        .search-input:focus {
            border-color: var(--primary-blue);
            outline: none;
            box-shadow: 0 0 0 3px rgba(0, 82, 204, 0.1);
        }
        
        .stats-bar {
            padding: 12px 15px;
            background: linear-gradient(135deg, var(--light-bg), #e9ecef);
            border-top: 1px solid var(--border-color);
            font-size: 11px;
            display: flex;
            justify-content: space-between;
            font-weight: 500;
        }
        
        .btn-enhanced {
            border-radius: 8px;
            padding: 6px 14px;
            font-weight: 500;
            font-size: 13px;
            transition: all 0.3s ease;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .btn-enhanced:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        }
        
        .form-select, .form-control {
            border-radius: 6px;
            border: 2px solid #ddd;
            transition: border-color 0.3s ease;
            font-size: 12px;
        }

        .form-select:focus, .form-control:focus {
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 3px rgba(0, 82, 204, 0.1);
        }
        
        .form-label {
            font-size: 12px;
        }

        /* Canvas View Styles */
        .canvas-container {
            background: #e0e0e0;
            padding: 0;
            height: calc(100vh - 200px);
            overflow: auto;
        }

        .canvas-paper {
            background: white;
            width: 297mm;
            min-height: 210mm;
            margin: 20px auto;
            padding: 15mm;
            box-shadow: 0 0 30px rgba(0,0,0,0.2);
            border: 1px solid #999;
        }

        .canvas-page-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 10px;
            padding-bottom: 10px;
            border-bottom: 2px solid #000;
        }

        .canvas-left-info {
            font-size: 9px;
            line-height: 1.6;
        }

        .canvas-center-info {
            text-align: center;
            font-size: 9px;
            line-height: 1.6;
        }

        .canvas-right-info {
            text-align: right;
            font-size: 9px;
            line-height: 1.6;
        }

        .canvas-bay-title {
            text-align: center;
            font-size: 11px;
            font-weight: bold;
            margin: 15px 0 10px 0;
            padding: 5px;
            background: #f0f0f0;
            border: 1px solid #000;
        }

        .canvas-bayplan-grid {
            display: table;
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
            font-size: 7px;
        }

        .canvas-row {
            display: table-row;
        }

        .canvas-cell {
            display: table-cell;
            border: 1px solid #000;
            padding: 2px;
            text-align: center;
            vertical-align: middle;
            min-width: 45px;
            height: 50px;
            position: relative;
        }

        .canvas-cell.header {
            background: #d0d0d0;
            font-weight: bold;
            font-size: 8px;
            height: 25px;
        }

        .canvas-cell.tier-header {
            background: #d0d0d0;
            font-weight: bold;
            font-size: 8px;
            width: 35px;
        }

        .canvas-cell.empty {
            background: white;
        }

        .canvas-cell.occupied {
            background: white;
            padding: 3px;
        }

        .canvas-container-box {
            border: 2px solid #000;
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            padding: 2px;
            font-size: 6px;
            line-height: 1.2;
        }

        .canvas-container-box.length-20 {
            border-style: solid;
        }

        .canvas-container-box.length-40 {
            border-style: solid;
            border-width: 3px;
        }

        .canvas-container-top {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }

        .canvas-container-id {
            font-size: 6px;
            font-weight: bold;
            word-break: break-all;
        }

        .canvas-container-type {
            font-size: 5px;
        }

        .canvas-container-status {
            font-size: 6px;
            text-align: center;
            margin: 2px 0;
        }

        .canvas-container-weight {
            font-size: 6px;
            text-align: right;
        }

        .canvas-footer {
            margin-top: 15px;
            padding-top: 10px;
            border-top: 1px solid #000;
            font-size: 8px;
            display: flex;
            justify-content: space-between;
        }

        .canvas-actions {
            position: sticky;
            top: 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 10px;
            z-index: 1000;
            background: white;
            padding: 15px 25px;
            border-bottom: 2px solid #e0e0e0;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }

        .canvas-filter-group {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .canvas-filter-item {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .canvas-filter-item label {
            font-size: 13px;
            font-weight: 600;
            color: #495057;
            white-space: nowrap;
            margin: 0;
        }

        .canvas-actions select {
            min-width: 150px;
            font-size: 13px;
            padding: 8px 12px;
            border: 2px solid #dee2e6;
            border-radius: 8px;
            background: white;
            transition: all 0.3s ease;
        }

        .canvas-actions select:focus {
            border-color: var(--primary-blue);
            outline: none;
            box-shadow: 0 0 0 3px rgba(0, 82, 204, 0.1);
        }

        .canvas-actions select:hover {
            border-color: #adb5bd;
        }

        .canvas-button-group {
            display: flex;
            gap: 10px;
        }

        .canvas-actions .btn {
            padding: 10px 20px;
            font-size: 13px;
            font-weight: 600;
            border-radius: 8px;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
            white-space: nowrap;
        }

        .canvas-actions .btn-primary {
            background: var(--primary-blue);
            border: none;
        }

        .canvas-actions .btn-primary:hover {
            background: var(--secondary-blue);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 82, 204, 0.3);
        }

        .canvas-actions .btn-secondary {
            background: #6c757d;
            border: none;
        }

        .canvas-actions .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(108, 117, 125, 0.3);
        }

        .control-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
            font-size: 11px;
            padding: 8px;
            background: #f8f9fa;
            border-radius: 6px;
        }

        .control-item span:first-child {
            font-weight: 600;
            color: #495057;
        }

        .control-item span:last-child {
            color: #6c757d;
            font-size: 10px;
        }

        /* Modal Styles */
        .modal-content {
            border-radius: 12px;
            border: none;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        }

        .modal-header {
            background: linear-gradient(135deg, var(--primary-blue), var(--secondary-blue));
            color: white;
            border-radius: 12px 12px 0 0;
            padding: 16px 20px;
        }

        .modal-body {
            padding: 20px;
        }

        .container-detail-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }

        .detail-card {
            background: var(--light-bg);
            padding: 12px;
            border-radius: 8px;
            border-left: 3px solid var(--primary-blue);
        }

        .detail-label {
            font-weight: 600;
            color: var(--text-muted);
            font-size: 11px;
            text-transform: uppercase;
            margin-bottom: 4px;
        }

        .detail-value {
            font-size: 14px;
            font-weight: 500;
            color: #212529;
        }

        .container-3d-preview {
            background: linear-gradient(135deg, #e3f2fd, #bbdefb);
            border-radius: 8px;
            padding: 18px;
            text-align: center;
            margin: 12px 0;
        }

        .badge-custom {
            padding: 6px 10px;
            border-radius: 5px;
            font-size: 10px;
            font-weight: 600;
        }

        .tooltip-custom {
            position: absolute;
            background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(33, 37, 41, 0.9));
            color: white;
            padding: 10px 14px;
            border-radius: 6px;
            font-size: 11px;
            pointer-events: none;
            z-index: 1000;
            display: none;
            max-width: 220px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
        }

        .empty-state {
            text-align: center;
            padding: 30px 15px;
            color: var(--text-muted);
        }

        .empty-state i {
            font-size: 40px;
            margin-bottom: 12px;
            opacity: 0.4;
        }

        /* Filter Toggle Buttons */
        .filter-toggle {
            display: flex;
            gap: 4px;
        }

        .filter-toggle .btn {
            border-radius: 16px;
            padding: 5px 10px;
            font-size: 10px;
            border: 1px solid #dee2e6;
            background: white;
            color: #6c757d;
            transition: all 0.3s ease;
        }

        .filter-toggle .btn.active {
            background: var(--primary-blue);
            color: white;
            border-color: var(--primary-blue);
        }

        /* Scrollbar Styling */
        .bayplan-grid-container::-webkit-scrollbar,
        .container-list::-webkit-scrollbar,
        .canvas-container::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }

        .bayplan-grid-container::-webkit-scrollbar-track,
        .container-list::-webkit-scrollbar-track,
        .canvas-container::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 4px;
        }

        .bayplan-grid-container::-webkit-scrollbar-thumb,
        .container-list::-webkit-scrollbar-thumb,
        .canvas-container::-webkit-scrollbar-thumb {
            background: #888;
            border-radius: 4px;
        }

        .bayplan-grid-container::-webkit-scrollbar-thumb:hover,
        .container-list::-webkit-scrollbar-thumb:hover,
        .canvas-container::-webkit-scrollbar-thumb:hover {
            background: #555;
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .container-list-section {
                width: 280px;
            }
            .bayplan-grid {
                min-width: 700px;
            }
        }

        @media (max-width: 992px) {
            .main-container {
                flex-direction: column;
                height: auto;
            }
            .container-list-section {
                width: 100%;
                max-height: 400px;
            }
        }

        @media print {
            .view-tabs, .canvas-actions, .navbar {
                display: none !important;
            }
            .canvas-container {
                height: auto;
            }
        }
    </style>

    <!-- View Tabs -->
    <div class="view-tabs">
        <div class="view-tab active" data-view="grid">
            <i class="bi bi-grid-3x3"></i>
            Grid View
        </div>
        <div class="view-tab" data-view="canvas">
            <i class="bi bi-file-earmark-text"></i>
            PDF View
        </div>
    </div>

    <!-- Grid View (Original) -->
    <div class="view-content active" id="gridView">
        <div class="main-container">
            <!-- Bayplan Section -->
            <div class="bayplan-section">
                <div class="section-header">
                    <div class="vessel-info">
                        <i class="bi bi-grid-3x3"></i>
                        <div>
                            <div style="font-size: 13px;">DEMO VESSEL</div>
                            <small style="font-size: 10px;">Interactive Container Bay Plan</small>
                        </div>
                    </div>
                    <div class="text-end">
                        <small style="font-size: 10px;">Updated: <span id="lastUpdate">Just Now</span></small>
                    </div>
                </div>
                
                <div class="controls-bar">
                    <div class="filter-section">
                        <div class="d-flex align-items-center gap-2">
                            <label class="form-label mb-0 fw-bold">Bay:</label>
                            <select class="form-select form-select-sm" id="baySelect" style="width: 130px;">
                                <option value="all">All Bays</option>
                            </select>
                        </div>
                        
                        <div class="d-flex align-items-center gap-2">
                            <label class="form-label mb-0 fw-bold">Color:</label>
                            <select class="form-select form-select-sm" id="colorBySelect" style="width: 120px;">
                                <option value="length">Length</option>
                                <option value="weight">Weight</option>
                                <option value="status">Status</option>
                                <option value="pod">POD</option>
                            </select>
                        </div>

                        <div class="d-flex align-items-center gap-2">
                            <label class="form-label mb-0 fw-bold">Size:</label>
                            <div class="filter-toggle" id="sizeFilters">
                                <button class="btn active" data-size="all">All</button>
                                <button class="btn" data-size="20">20'</button>
                                <button class="btn" data-size="40">40'</button>
                                <button class="btn" data-size="45">45'</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="controls-bar" style="padding: 8px 15px;">
                    <div class="legend" id="legendContainer">
                        <!-- Legend will be populated by JavaScript -->
                    </div>
                </div>
                
                <div class="bayplan-grid-container">
                    <div class="bayplan-panel on-deck-panel">
                        <h5 class="panel-title">ON DECK (T72 - T92)</h5>
                        <div id="bayplanGridOnDeck" class="bayplan-grid"></div>
                    </div>

                    <div class="bayplan-panel under-deck-panel">
                        <h5 class="panel-title">UNDER DECK (T02 - T22)</h5>
                        <div id="bayplanGridUnderDeck" class="bayplan-grid"></div>
                    </div>
                </div>
            </div>
            
            <!-- Container List Section -->
            <div class="container-list-section">
                <div class="section-header">
                    <div>
                        <div style="font-size: 13px;"><i class="bi bi-box-seam me-1"></i>Containers</div>
                        <small id="containerCount" style="font-size: 10px;">Loading...</small>
                    </div>
                    <div class="text-end">
                        <button class="btn btn-outline-light btn-sm" style="font-size: 10px; padding: 4px 8px;" onclick="clearAllSelections()">
                            <i class="bi bi-x-circle"></i> Clear
                        </button>
                    </div>
                </div>
                
                <div class="search-container">
                    <div class="input-group">
                        <span class="input-group-text bg-light border-end-0">
                            <i class="bi bi-search" style="font-size: 12px;"></i>
                        </span>
                        <input type="text" class="search-input border-start-0" placeholder="Search..." 
                               id="searchInput" onkeyup="filterContainers()">
                    </div>
                </div>
                
                <div class="container-list" id="containerList">
                    <!-- Container list will be generated by JavaScript -->
                </div>
                
                <div class="stats-bar">
                    <span><i class="bi bi-boxes"></i> <strong id="totalCount">0</strong></span>
                    <span><i class="bi bi-check-circle"></i> <strong id="selectedCount">0</strong></span>
                </div>
            </div>
        </div>
    </div>

<!-- Canvas View -->
<div class="view-content" id="canvasView">
    <div class="canvas-actions">
        <div class="canvas-filter-group">
            <div class="canvas-filter-item">
                <label>Bay:</label>
                <select class="form-select" id="canvasBaySelect">
                    <option value="all">All Bays</option>
                </select>
            </div>

            <div class="canvas-filter-item">
                <label>Deck:</label>
                <select class="form-select" id="canvasDeckSelect">
                    <option value="both">Both Decks</option>
                    <option value="ondeck">On Deck</option>
                    <option value="underdeck">Under Deck</option>
                </select>
            </div>
        </div>

        <div class="canvas-button-group">
            <button class="btn btn-primary" onclick="window.bayplanViz.downloadPDF()">
                <i class="bi bi-download"></i>
                Download PDF
            </button>
        </div>
    </div>

    <div class="canvas-container">
        <div class="canvas-paper" id="canvasPaper">
            <!-- Canvas content will be generated by JavaScript -->
        </div>
    </div>
</div>

    <!-- Container Detail Modal -->
    <div class="modal fade" id="containerModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="containerModalLabel">
                        <i class="bi bi-box-seam me-2"></i>Container Details
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="modalBody"></div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary btn-sm" onclick="selectContainerFromModal()">
                        <i class="bi bi-check-circle me-1"></i>Select
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        window.serverContainers = <?php echo json_encode($containerData ?? [], 15, 512) ?>;
    </script>

    <div id="tooltip" class="tooltip-custom"></div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.1.3/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    
    <script>
        class EnhancedBayplanVisualization {
            constructor() {
                this.containers = [];
                this.filteredContainers = [];
                this.selectedContainers = new Set();
                this.currentContainer = null;
                this.colorMode = 'length';
                this.currentBay = 'all';
                this.sizeFilter = 'all';
                this.canvasBay = 'all';
                this.canvasDeck = 'both';
                this.modal = null;
                this.currentView = 'grid';
                this.podColors = {};
                this.containers = window.serverContainers || [];
                this.initializeComponents();
                this.generatePODColors();
                this.loadContainerData();
                this.setupEventListeners();
                this.renderAll();
            }

            initializeComponents() {
                this.modal = new bootstrap.Modal(document.getElementById('containerModal'));
                this.updateTimestamp();
                this.setupViewTabs();
            }

            setupViewTabs() {
                document.querySelectorAll('.view-tab').forEach(tab => {
                    tab.addEventListener('click', (e) => {
                        const view = e.currentTarget.dataset.view;
                        this.switchView(view);
                    });
                });
            }

            switchView(view) {
                this.currentView = view;
                
                // Update tabs
                document.querySelectorAll('.view-tab').forEach(tab => {
                    tab.classList.remove('active');
                    if (tab.dataset.view === view) {
                        tab.classList.add('active');
                    }
                });

                // Update views
                document.querySelectorAll('.view-content').forEach(content => {
                    content.classList.remove('active');
                });

                if (view === 'grid') {
                    document.getElementById('gridView').classList.add('active');
                } else if (view === 'canvas') {
                    document.getElementById('canvasView').classList.add('active');
                    this.renderCanvasView();
                } else if (view === '3d') {
                    document.getElementById('view3d').classList.add('active');
                    setTimeout(() => this.init3DView(), 100);
                }
            }

            updateTimestamp() {
                document.getElementById('lastUpdate').textContent = new Date().toLocaleTimeString();
            }
            
            loadContainerData() {
                let sourceData = window.containerData || [];
                this.containers = sourceData.map((container, index) => ({
                    ...container,
                    id: container.id || container.container_number || `DEMO${index.toString().padStart(7, '0')}`,
                    position: container.position || `${container.bay}-${container.row}-${container.tier}`,
                    weight: parseInt(container.weight) || 10000,
                    length: parseInt(container.length) || 20,
                    status: container.status || 'Unknown'
                }));
                this.filteredContainers = [...this.containers];
                this.initializeBaySelector();
            }
            
            initializeBaySelector() {
                const baySelect = document.getElementById('baySelect');
                const canvasBaySelect = document.getElementById('canvasBaySelect');
                const bays = [...new Set(this.containers.map(c => c.bay.toString()))].sort();
                
                const bayOptions = '<option value="all">All Bays</option>' + 
                    bays.map(bay => {
                        const count = this.containers.filter(c => c.bay.toString() === bay).length;
                        return `<option value="${bay}">Bay ${bay} (${count})</option>`;
                    }).join('');
                
                baySelect.innerHTML = bayOptions;
                if (canvasBaySelect) canvasBaySelect.innerHTML = bayOptions;
            }
            generatePODColors() {
                const uniquePODs = [...new Set(this.containers.map(c => c.pod).filter(pod => pod))];
                
                const colorPalette = [
                    '#FF6B6B', '#4ECDC4', '#45B7D1', '#FFA07A', '#98D8C8',
                    '#F7DC6F', '#BB8FCE', '#85C1E2', '#F8B739', '#52B788',
                    '#E76F51', '#2A9D8F', '#E9C46A', '#F4A261', '#264653',
                    '#8E44AD', '#3498DB', '#1ABC9C', '#F39C12', '#E74C3C'
                ];
                
                uniquePODs.forEach((pod, index) => {
                    this.podColors[pod] = colorPalette[index % colorPalette.length];
                });
            }
            adjustBrightness(color, amount) {
                const num = parseInt(color.replace("#",""), 16);
                const r = Math.max(0, Math.min(255, (num >> 16) + amount));
                const g = Math.max(0, Math.min(255, ((num >> 8) & 0x00FF) + amount));
                const b = Math.max(0, Math.min(255, (num & 0x0000FF) + amount));
                return "#" + ((r << 16) | (g << 8) | b).toString(16).padStart(6, '0');
            }

            getContrastColor(hexColor) {
                const r = parseInt(hexColor.substr(1,2), 16);
                const g = parseInt(hexColor.substr(3,2), 16);
                const b = parseInt(hexColor.substr(5,2), 16);
                const brightness = ((r * 299) + (g * 587) + (b * 114)) / 1000;
                return brightness > 155 ? '#000000' : '#ffffff';
            }
            
            setupEventListeners() {
                document.getElementById('baySelect').addEventListener('change', (e) => {
                    this.currentBay = e.target.value;
                    this.applyFilters();
                    this.renderAll();
                });
                
                document.getElementById('colorBySelect').addEventListener('change', (e) => {
                    this.colorMode = e.target.value;
                    this.updateLegend();
                    this.renderBayplan();
                });
                
                document.getElementById('sizeFilters').addEventListener('click', (e) => {
                    if (e.target.classList.contains('btn')) {
                        document.querySelectorAll('#sizeFilters .btn').forEach(btn => btn.classList.remove('active'));
                        e.target.classList.add('active');
                        this.sizeFilter = e.target.dataset.size;
                        this.applyFilters();
                        this.renderAll();
                    }
                });
                
                // Canvas view filters
                const canvasBaySelect = document.getElementById('canvasBaySelect');
                const canvasDeckSelect = document.getElementById('canvasDeckSelect');
                
                if (canvasBaySelect) {
                    canvasBaySelect.addEventListener('change', (e) => {
                        this.canvasBay = e.target.value;
                        if (this.currentView === 'canvas') {
                            this.renderCanvasView();
                        }
                    });
                }
                
                if (canvasDeckSelect) {
                    canvasDeckSelect.addEventListener('change', (e) => {
                        this.canvasDeck = e.target.value;
                        if (this.currentView === 'canvas') {
                            this.renderCanvasView();
                        }
                    });
                }
                
                document.addEventListener('mousemove', this.handleTooltip.bind(this));
            }
            
            applyFilters() {
                this.filteredContainers = this.containers.filter(container => {
                    if (this.currentBay !== 'all' && container.bay.toString() !== this.currentBay) return false;
                    if (this.sizeFilter !== 'all' && container.length.toString() !== this.sizeFilter) return false;
                    
                    const searchTerm = document.getElementById('searchInput').value.toLowerCase();
                    if (searchTerm) {
                        const searchableText = [container.id, container.line, container.position].join(' ').toLowerCase();
                        if (!searchableText.includes(searchTerm)) return false;
                    }
                    return true;
                });
            }
            
            renderAll() {
                this.renderBayplan();
                this.renderContainerList();
                this.updateStats();
                this.updateLegend();
                
                if (this.currentView === 'canvas') {
                    this.renderCanvasView();
                } else if (this.currentView === '3d' && this.scene) {
                    this.update3DView();
                }
            }
            
            renderBayplan() {
                const gridOnDeck = document.getElementById('bayplanGridOnDeck');
                const gridUnderDeck = document.getElementById('bayplanGridUnderDeck');
                gridOnDeck.innerHTML = '';
                gridUnderDeck.innerHTML = '';

                if (this.filteredContainers.length === 0) return;
                
                const { maxRow } = { maxRow: 24 };
                const oddRows = [], evenRows = [];
                for (let r = 1; r <= maxRow; r++) {
                    const rowString = r.toString().padStart(2, '0');
                    if (r % 2 !== 0) oddRows.push(rowString);
                    else evenRows.push(rowString);
                }
                const rows = [...oddRows.reverse(), '00', ...evenRows];
                
                const ON_DECK_TIERS = [];
                for (let t = 92; t >= 72; t -= 2) ON_DECK_TIERS.push(t.toString().padStart(2, '0'));
                
                const UNDER_DECK_TIERS = [];
                for (let t = 22; t >= 2; t -= 2) UNDER_DECK_TIERS.push(t.toString().padStart(2, '0'));

                this.renderPanel(gridOnDeck, rows, ON_DECK_TIERS, rows.length);
                this.renderPanel(gridUnderDeck, rows, UNDER_DECK_TIERS, rows.length);
                this.updateVesselInfo();
            }

            renderPanel(grid, rows, tiers, totalCols) {
                grid.style.gridTemplateColumns = `25px repeat(${totalCols}, 28px)`;
                grid.style.gridTemplateRows = `25px repeat(${tiers.length}, 28px)`;

                const emptyHeader = document.createElement('div');
                emptyHeader.className = 'grid-header';
                emptyHeader.innerHTML = '<i class="bi bi-grid-3x2-gap"></i>';
                grid.appendChild(emptyHeader);
                
                rows.forEach(row => {
                    const header = document.createElement('div');
                    header.className = 'grid-header';
                    header.textContent = `R${row}`;
                    grid.appendChild(header);
                });
                
                tiers.forEach(tier => {
                    const tierHeader = document.createElement('div');
                    tierHeader.className = 'row-header';
                    tierHeader.textContent = `T${tier}`;
                    grid.appendChild(tierHeader);
                    
                    rows.forEach(row => {
                        const cell = document.createElement('div');
                        cell.className = 'container-slot';
                        
                        const container = this.filteredContainers.find(c => 
                            c.tier.toString().padStart(2, '0') === tier && 
                            c.row.toString().padStart(2, '0') === row
                        );
                        
                        if (container) {
                            this.styleContainerSlot(cell, container);
                            cell.dataset.container = JSON.stringify(container);
                            const text = document.createElement('div');
                            text.className = 'container-text';
                            text.textContent = container.line || container.id.substring(0, 4);
                            cell.appendChild(text);
                            cell.addEventListener('click', () => this.showContainerDetail(container));
                        } else {
                            cell.classList.add('empty');
                        }
                        grid.appendChild(cell);
                    });
                });
            }
          
            styleContainerSlot(cell, container) {
            if (this.selectedContainers.has(container.id)) {
                cell.classList.add('selected');
            }
            
            switch (this.colorMode) {
                case 'length':
                    cell.classList.add(`length-${container.length}`);
                    break;
                case 'status':
                    cell.classList.add(`status-${container.status.toLowerCase()}`);
                    break;
                case 'weight':
                    if (container.weight < 10000) cell.classList.add('weight-light');
                    else if (container.weight < 20000) cell.classList.add('weight-medium');
                    else cell.classList.add('weight-heavy');
                    break;
                case 'pod':
                    // ✅ TAMBAHKAN CASE INI:
                    if (container.pod && this.podColors[container.pod]) {
                        cell.style.background = `linear-gradient(135deg, ${this.podColors[container.pod]}, ${this.adjustBrightness(this.podColors[container.pod], -20)})`;
                        cell.style.borderColor = this.podColors[container.pod];
                        cell.style.color = this.getContrastColor(this.podColors[container.pod]);
                    } else {
                        cell.style.background = 'linear-gradient(135deg, #6c757d, #adb5bd)';
                        cell.style.color = 'white';
                    }
                    break;
            }
            
            if (container.imdg) {
                const icon = document.createElement('i');
                icon.className = 'bi bi-exclamation-triangle position-absolute';
                icon.style.cssText = 'top: 1px; right: 1px; color: #ffc107; font-size: 7px;';
                cell.appendChild(icon);
            }
            
            if (container.reefer) {
                const icon = document.createElement('i');
                icon.className = 'bi bi-snow position-absolute';
                icon.style.cssText = 'top: 1px; left: 1px; color: #17a2b8; font-size: 7px;';
                cell.appendChild(icon);
            }
        }
            
            renderContainerList() {
                const list = document.getElementById('containerList');
                list.innerHTML = '';
                
                if (this.filteredContainers.length === 0) {
                    list.innerHTML = `
                        <div class="empty-state">
                            <i class="bi bi-search"></i>
                            <h6>No containers found</h6>
                        </div>
                    `;
                    return;
                }
                
                this.filteredContainers.forEach(container => {
                    const item = document.createElement('div');
                    item.className = 'container-item';
                    if (this.selectedContainers.has(container.id)) item.classList.add('selected');
                    
                    const displayId = container.id.length > 11 ? container.id.substring(0, 11) : container.id;
                    
                    item.innerHTML = `
                        <div class="container-type-indicator length-${container.length}"></div>
                        <div class="container-number">${displayId}</div>
                        <div class="container-details">
                            <div class="d-flex justify-content-between mb-1">
                                <strong>${container.line || 'N/A'}</strong>
                                <small class="text-muted">${container.pod || 'N/A'}</small>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span>${container.position} • ${container.length}ft</span>
                                <span class="badge ${container.status === 'Full' ? 'bg-success' : 'bg-secondary'}" style="font-size: 8px;">
                                    ${container.status}
                                </span>
                            </div>
                        </div>
                    `;
                    
                    item.addEventListener('click', () => this.showContainerDetail(container));
                    list.appendChild(item);
                });
            }
            
            showContainerDetail(container) {
                this.currentContainer = container;
                const modalBody = document.getElementById('modalBody');
                
                modalBody.innerHTML = `
                    <div class="container-3d-preview">
                        <div style="font-size: 40px; color: var(--primary-blue);">
                            <i class="bi bi-box-seam"></i>
                        </div>
                        <h5 class="mt-2 mb-0">${container.id}</h5>
                        <p class="text-muted mb-0">${container.length}ft Container</p>
                    </div>
                    
                    <div class="container-detail-grid">
                        <div class="detail-card">
                            <div class="detail-label">Position</div>
                            <div class="detail-value">${container.position}</div>
                        </div>
                        <div class="detail-card">
                            <div class="detail-label">Status</div>
                            <div class="detail-value">
                                <span class="badge ${container.status === 'Full' ? 'bg-success' : 'bg-secondary'} badge-custom">
                                    ${container.status}
                                </span>
                            </div>
                        </div>
                        <div class="detail-card">
                            <div class="detail-label">Weight</div>
                            <div class="detail-value">${container.weight.toLocaleString()} kg</div>
                        </div>
                        <div class="detail-card">
                            <div class="detail-label">Length</div>
                            <div class="detail-value">${container.length} feet</div>
                        </div>
                    </div>
                `;
                
                document.getElementById('containerModalLabel').innerHTML = `
                    <i class="bi bi-box-seam me-2"></i>Container - ${container.id}
                `;
                
                this.modal.show();
            }

            // Canvas/PDF View Methods
            renderCanvasView() {
                const paper = document.getElementById('canvasPaper');
                const date = new Date();
                const formattedDate = date.toLocaleDateString('en-US', { 
                    weekday: 'long', month: 'long', day: 'numeric', year: 'numeric'
                });
                const formattedTime = date.toLocaleTimeString('en-US', { 
                    hour: '2-digit', minute: '2-digit' 
                });
                
                // Get filtered containers based on canvas filters
                let canvasContainers = this.containers;
                
                // Filter by bay
                if (this.canvasBay !== 'all') {
                    canvasContainers = canvasContainers.filter(c => c.bay.toString() === this.canvasBay);
                }
                
                const vesselName = this.containers[0]?.vessel || 'SITC SHENGMING';
                const voyageNumber = this.containers[0]?.voyage || '2515N';
                const currentBayDisplay = this.canvasBay === 'all' ? '001' : this.canvasBay.padStart(3, '0');
                
                // Count containers by length
                const count20 = canvasContainers.filter(c => c.length === 20).length;
                const count40 = canvasContainers.filter(c => c.length === 40).length;
                const count45 = canvasContainers.filter(c => c.length === 45).length;
                
                let html = `
                    <div class="canvas-page-header">
                        <div class="canvas-left-info">
                            <strong>Sender:</strong><br>
                            <strong>Recipient: TSB</strong><br>
                            Message reference number: 1<br>
                            Document number: 0<br>
                            Carrier code: VRVE3
                        </div>
                        <div class="canvas-center-info">
                            Time of preparation: ${formattedDate} ${formattedTime}<br>
                            Message compilation time: Friday, January 7, 2022 09:18<br>
                            Message type: First or basic message<br>
                            <br>
                            Discharge voyage number: ${voyageNumber}<br>
                            <strong>Bay: ${currentBayDisplay} (${this.canvasDeck === 'ondeck' ? 'On Deck' : this.canvasDeck === 'underdeck' ? 'In Hold' : 'Both Decks'}), 20FT Units = ${count20}, 40FT Units = ${count40 + count45}, Active filter: ${this.colorMode === 'length' ? 'No Colors' : this.colorMode}</strong>
                        </div>
                        <div class="canvas-right-info">
                            Page: 1 of ${this.canvasDeck === 'both' ? '2' : '1'}<br>
                            <br>
                            Place of departure: Jakarta - Java<br>
                            Vessel name: ${vesselName}<br>
                            Vessel call sign: VRVE3<br>
                            File: SHEN029.EDI
                        </div>
                    </div>
                `;

                // Render based on deck selection
                if (this.canvasDeck === 'both' || this.canvasDeck === 'ondeck') {
                    html += this.renderProfessionalBayplan('On Deck', false, canvasContainers);
                }
                
                if (this.canvasDeck === 'both' || this.canvasDeck === 'underdeck') {
                    html += this.renderProfessionalBayplan('In Hold', true, canvasContainers);
                }
                

                paper.innerHTML = html;
            }

            renderProfessionalBayplan(title, isUnderDeck, containers) {
                // Define rows in shipping standard order (odd numbers descending, 00, even numbers ascending)
                const maxRow = 18;
                const oddRows = [];
                const evenRows = [];
                
                for (let r = 1; r <= maxRow; r++) {
                    if (r % 2 !== 0) oddRows.push(r);
                    else evenRows.push(r);
                }
                
                const rows = [...oddRows.reverse(), 0, ...evenRows];
                
                // Define tiers based on deck type
                const tiers = isUnderDeck 
                    ? [2, 4, 6, 8, 10, 12, 14, 16, 18]  // Under deck
                    : [72, 74, 76, 78, 80, 82, 84, 86, 88, 90, 92];  // On deck
                
                let html = `
                    <div class="canvas-bay-title">
                        Bay: ${this.canvasBay === 'all' ? '001' : this.canvasBay.padStart(3, '0')} (${title})
                    </div>
                    <div class="canvas-bayplan-grid">
                `;
                
                // Header row with row numbers
                html += '<div class="canvas-row">';
                html += '<div class="canvas-cell header"></div>'; // Top-left corner
                
                rows.forEach(row => {
                    const rowStr = row.toString().padStart(2, '0');
                    html += `<div class="canvas-cell header">${rowStr}</div>`;
                });
                html += '</div>';
                
                // Data rows with tier numbers
                tiers.forEach(tier => {
                    html += '<div class="canvas-row">';
                    
                    // Tier header
                    const tierStr = tier.toString().padStart(2, '0');
                    html += `<div class="canvas-cell tier-header">${tierStr}</div>`;
                    
                    // Container cells
                    rows.forEach(row => {
                        const rowStr = row.toString().padStart(2, '0');
                        const tierPadded = tier.toString().padStart(2, '0');
                        
                        // Find container at this position
                        const container = containers.find(c => 
                            c.row.toString().padStart(2, '0') === rowStr && 
                            c.tier.toString().padStart(2, '0') === tierPadded
                        );
                        
                        if (container) {
                            const lengthClass = `length-${container.length}`;
                            const weight = (container.weight / 1000).toFixed(1);
                            const containerIdShort = container.id.length > 11 ? container.id.substring(0, 11) : container.id;
                            
                            html += `
                                <div class="canvas-cell occupied">
                                    <div class="canvas-container-box ${lengthClass}">
                                        <div class="canvas-container-top">
                                            <div class="canvas-container-id">${containerIdShort}</div>
                                            <div class="canvas-container-type">${container.status === 'Full' ? 'F' : 'E'}</div>
                                        </div>
                                        <div class="canvas-container-status">Occupied<br>by ${container.length}'</div>
                                        <div class="canvas-container-weight">${weight}t ${container.length === 40 ? '4000' : '2000'}</div>
                                    </div>
                                </div>
                            `;
                        } else {
                            html += '<div class="canvas-cell empty"></div>';
                        }
                    });
                    
                    html += '</div>';
                });
                
                html += '</div>';
                
                // Bottom scale (weights/positions)
                html += '<div style="display: flex; justify-content: space-between; margin-top: 5px; font-size: 7px; padding: 0 35px;">';
                rows.forEach(row => {
                    const weight = (row * 5).toFixed(1);
                    html += `<div style="width: 45px; text-align: center;">${weight}</div>`;
                });
                html += '</div>';
                
                return html;
            }

            downloadPDF() {
                const { jsPDF } = window.jspdf;
                const paper = document.getElementById('canvasPaper');
                
                // Show loading
                const originalHTML = paper.innerHTML;
                paper.innerHTML = '<div style="text-align: center; padding: 50px;"><h3>Generating PDF...</h3><p>Please wait</p></div>';
                
                setTimeout(() => {
                    paper.innerHTML = originalHTML;
                    
                    html2canvas(paper, {
                        scale: 2,
                        useCORS: true,
                        logging: false,
                        backgroundColor: '#ffffff'
                    }).then(canvas => {
                        const imgData = canvas.toDataURL('image/png');
                        const pdf = new jsPDF('landscape', 'mm', 'a4');
                        const pdfWidth = pdf.internal.pageSize.getWidth();
                        const pdfHeight = pdf.internal.pageSize.getHeight();
                        const imgWidth = canvas.width;
                        const imgHeight = canvas.height;
                        const ratio = Math.min(pdfWidth / imgWidth, pdfHeight / imgHeight);
                        const imgX = (pdfWidth - imgWidth * ratio) / 2;
                        const imgY = 5;

                        pdf.addImage(imgData, 'PNG', imgX, imgY, imgWidth * ratio, imgHeight * ratio);
                        
                        const fileName = `BayPlan_${this.currentBay}_${new Date().getTime()}.pdf`;
                        pdf.save(fileName);
                    });
                }, 100);
            }

setupMouseControls() {
    const canvas = this.renderer.domElement;
    let isDragging = false;
    let isRightDrag = false;
    let previousMousePosition = { x: 0, y: 0 };
    let rotationSpeed = 0.005;
    let panSpeed = 0.1;

    canvas.addEventListener('mousedown', (e) => {
        isDragging = true;
        isRightDrag = e.button === 2;
        previousMousePosition = { x: e.clientX, y: e.clientY };
    });

    canvas.addEventListener('mousemove', (e) => {
        if (!isDragging) return;

        const deltaX = e.clientX - previousMousePosition.x;
        const deltaY = e.clientY - previousMousePosition.y;

        if (isRightDrag) {
            // Pan
            this.camera.position.x -= deltaX * panSpeed;
            this.camera.position.y += deltaY * panSpeed;
        } else {
            // Rotate around center
            const angle = deltaX * rotationSpeed;
            const verticalAngle = deltaY * rotationSpeed;
            
            // Horizontal rotation
            const x = this.camera.position.x;
            const z = this.camera.position.z;
            this.camera.position.x = x * Math.cos(angle) - z * Math.sin(angle);
            this.camera.position.z = x * Math.sin(angle) + z * Math.cos(angle);
            
            // Vertical rotation (limit to prevent flipping)
            const currentY = this.camera.position.y;
            const newY = currentY - verticalAngle * 30;
            this.camera.position.y = Math.max(10, Math.min(100, newY));
            
            this.camera.lookAt(0, 0, 0);
        }

        previousMousePosition = { x: e.clientX, y: e.clientY };
    });

    canvas.addEventListener('mouseup', () => {
        isDragging = false;
        isRightDrag = false;
    });

    canvas.addEventListener('wheel', (e) => {
        e.preventDefault();
        const zoomSpeed = 0.1;
        const direction = e.deltaY > 0 ? 1 : -1;
        
        const distance = this.camera.position.length();
        const newDistance = distance + direction * zoomSpeed * distance;
        
        if (newDistance > 20 && newDistance < 250) {
            const factor = newDistance / distance;
            this.camera.position.multiplyScalar(factor);
            this.camera.lookAt(0, 0, 0);
        }
    });

    canvas.addEventListener('contextmenu', (e) => e.preventDefault());
} 
           updateLegend() {
    const legendContainer = document.getElementById('legendContainer');
    const legend = document.createElement('div');
    legend.className = 'legend';
    
    if (this.colorMode === 'length') {
        legend.innerHTML = `
            <div class="legend-item">
                <div class="legend-color length-20"></div>
                <span>20ft</span>
            </div>
            <div class="legend-item">
                <div class="legend-color length-40"></div>
                <span>40ft</span>
            </div>
            <div class="legend-item">
                <div class="legend-color length-45"></div>
                <span>45ft</span>
            </div>
        `;
    } else if (this.colorMode === 'status') {
        legend.innerHTML = `
            <div class="legend-item">
                <div class="legend-color status-full"></div>
                <span>Full</span>
            </div>
            <div class="legend-item">
                <div class="legend-color status-empty"></div>
                <span>Empty</span>
            </div>
        `;
    } else if (this.colorMode === 'weight') {
        legend.innerHTML = `
            <div class="legend-item">
                <div class="legend-color weight-light"></div>
                <span>Light (&lt;10T)</span>
            </div>
            <div class="legend-item">
                <div class="legend-color weight-medium"></div>
                <span>Medium (10-20T)</span>
            </div>
            <div class="legend-item">
                <div class="legend-color weight-heavy"></div>
                <span>Heavy (&gt;20T)</span>
            </div>
        `;
    } else if (this.colorMode === 'pod') {
        // ✅ TAMBAHKAN CASE INI:
        const uniquePODs = [...new Set(this.filteredContainers.map(c => c.pod).filter(pod => pod))].sort();
        const legendItems = uniquePODs.map(pod => `
            <div class="legend-item">
                <div class="legend-color" style="background: ${this.podColors[pod]}; border-color: ${this.podColors[pod]};"></div>
                <span>${pod}</span>
            </div>
        `).join('');
        
        legend.innerHTML = legendItems || '<span class="text-muted">No POD data</span>';
    }
    
    legendContainer.innerHTML = '';
    legendContainer.appendChild(legend);
}
            updateVesselInfo() {
                const vesselInfoElement = document.querySelector('.section-header .vessel-info div');
                if (vesselInfoElement && this.filteredContainers.length > 0) {
                    const firstContainer = this.filteredContainers[0];
                    const bayText = this.currentBay === 'all' ? 'All Bays' : `Bay ${this.currentBay}`;
                    vesselInfoElement.innerHTML = `
                        <div style="font-size: 13px;">${firstContainer.vessel || 'DEMO VESSEL'}</div>
                        <small style="font-size: 10px;">${bayText} - ${this.filteredContainers.length} containers</small>
                    `;
                }
            }
            
            updateStats() {
                document.getElementById('totalCount').textContent = this.containers.length;
                document.getElementById('selectedCount').textContent = this.selectedContainers.size;
                document.getElementById('containerCount').textContent = 
                    `${this.filteredContainers.length} containers`;
            }
            
            clearSelection() {
                this.selectedContainers.clear();
                this.renderAll();
            }
            
            handleTooltip(event) {
                const cell = event.target.closest('.container-slot');
                const tooltip = document.getElementById('tooltip');
                
                if (cell && cell.dataset.container && !cell.classList.contains('empty')) {
                    const container = JSON.parse(cell.dataset.container);
                    tooltip.innerHTML = `
                        <div><strong>${container.id}</strong></div>
                        <div>${container.position}</div>
                        <div>${container.length}ft • ${container.status}</div>
                        <div>${(container.weight/1000).toFixed(1)}T</div>
                    `;
                    tooltip.style.display = 'block';
                    tooltip.style.left = (event.pageX + 12) + 'px';
                    tooltip.style.top = (event.pageY - 8) + 'px';
                } else {
                    tooltip.style.display = 'none';
                }
            }
        }
        
        function filterContainers() {
            if (window.bayplanViz) {
                window.bayplanViz.applyFilters();
                window.bayplanViz.renderAll();
            }
        }
        
        function clearAllSelections() {
            if (window.bayplanViz) window.bayplanViz.clearSelection();
        }
        
        function selectContainerFromModal() {
            if (window.bayplanViz && window.bayplanViz.currentContainer) {
                window.bayplanViz.modal.hide();
            }
        }
        
        document.addEventListener('DOMContentLoaded', () => {
            try {
                if (typeof serverContainers !== 'undefined') {
                    window.containerData = serverContainers;
                }
            } catch (error) {
                console.log('No server data');
            }
            
            window.bayplanViz = new EnhancedBayplanVisualization();
        });
    </script>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\baplie-viewer-and-editor\resources\views/bayplan/index.blade.php ENDPATH**/ ?>