# 📱 Customer Dashboard - Panduan Lengkap

## 🎯 Fitur Customer Dashboard

Dashboard khusus untuk customer yang telah dibuat dengan fitur lengkap dan tampilan modern tanpa sidebar dan navbar admin.

### ✨ Fitur Utama

1. **Dashboard Overview**
   - Statistik pembelian dan service
   - Total pembelian produk
   - Total pengeluaran
   - Jumlah service aktif
   - Total service yang pernah dilakukan

2. **Service Aktif (Real-time)**
   - Menampilkan service yang sedang dikerjakan
   - Status service real-time (menunggu diagnosa, dalam pengerjaan, dll)
   - Informasi device dan keluhan
   - Akses cepat ke detail service

3. **Riwayat Pembelian**
   - Daftar semua pembelian produk
   - Detail produk yang dibeli
   - Total pembayaran
   - Tanggal transaksi
   - Metode pembayaran

4. **Riwayat Service**
   - Semua service yang pernah dilakukan
   - Status setiap service
   - Informasi device
   - Biaya service

5. **Detail Service Lengkap**
   - Informasi device (merk, model, IMEI)
   - Keluhan dan diagnosa
   - Status service real-time dengan animasi
   - Timeline riwayat status
   - Daftar sparepart yang digunakan
   - Rincian biaya lengkap
   - Informasi teknisi

6. **Informasi Kontak**
   - Data customer lengkap
   - Nama, email, WhatsApp, alamat

## 🚀 Cara Mengakses

### URL Dashboard Customer
```
http://localhost:8082/umi-cell/public/customer/dashboard
```

### Login sebagai Customer
1. Akses halaman login
2. Gunakan email dan password customer (default password: `customer123`)
3. Setelah login, otomatis redirect ke customer dashboard

## 📂 File Structure

```
app/
├── Http/Controllers/Customer/
│   └── CustomerDashboardController.php    # Controller untuk customer
├── Http/Controllers/Auth/
│   └── LoginController.php                # Updated dengan redirect logic
└── Models/
    ├── Customer.php                       # Updated dengan relasi user
    ├── Sale.php
    └── Service.php

resources/views/
├── layouts/
│   └── customer.blade.php                 # Layout khusus customer
└── customer/
    ├── dashboard.blade.php                # Halaman dashboard
    └── service-detail.blade.php           # Detail service

routes/
└── web.php                                # Routes customer dashboard
```

## 🎨 Fitur Desain

### Tanpa Sidebar & Navbar
- Clean design tanpa sidebar admin
- Header sederhana dengan info user dan logout
- Fokus pada konten customer

### Modern & Responsive
- Gradient colors yang menarik
- Card design dengan shadow dan hover effects
- Fully responsive untuk mobile
- Animasi smooth pada interactive elements

### Status Service Real-time
- Badge status berwarna
- Timeline interaktif untuk riwayat status
- Animasi pulse pada status aktif
- Visual feedback yang jelas

## 🔐 Security & Authorization

### Middleware Protection
```php
Route::prefix('customer')
    ->middleware(['auth', 'role:customer'])
    ->group(function () {
        // Customer routes here
    });
```

### Data Validation
- Customer hanya bisa melihat data miliknya sendiri
- Validasi customer_id pada setiap request
- Protected routes dengan role-based access

## 💡 Ide Tambahan yang Sudah Diimplementasikan

1. **Statistik Visual**
   - Card statistik dengan icon dan warna berbeda
   - Hover effects untuk better UX
   - Informasi ringkas yang mudah dipahami

2. **Service Aktif Highlight**
   - Banner khusus untuk service yang sedang dikerjakan
   - Warna gradient yang eye-catching
   - Call-to-action untuk lihat detail

3. **Timeline Status**
   - Visual timeline untuk tracking progress
   - Dot indicator dengan animasi
   - Informasi lengkap setiap perubahan status
   - User yang mengupdate status

4. **Rincian Biaya Transparan**
   - Breakdown biaya service
   - Biaya sparepart terpisah
   - Informasi DP dan sisa pembayaran
   - Total yang jelas dan mudah dibaca

5. **Product List pada Pembelian**
   - Badge untuk setiap produk
   - Quantity ditampilkan
   - Compact dan informatif

## 🔄 Flow Pengguna

1. **Customer baru ditambahkan** → User akun otomatis dibuat
2. **Customer login** → Redirect ke customer dashboard
3. **Lihat dashboard** → Overview semua data
4. **Cek service aktif** → Lihat status real-time
5. **Klik detail service** → Informasi lengkap dengan timeline
6. **Logout** → Kembali ke login page

## 📊 Database Relations

```php
Customer hasOne User (via user_id)
Customer hasMany Sales
Customer hasMany Services
Service hasMany ServiceDetails (spareparts)
Service hasMany ServiceStatusHistory
```

## 🎯 Status Service yang Didukung

- Menunggu diagnosa (warning)
- Dalam pengerjaan (info)
- Menunggu sparepart (secondary)
- Selesai (success)
- Diambil (success)
- Dibatalkan (danger)

## 🛠️ Customization

### Mengubah Warna Tema
Edit file `resources/views/layouts/customer.blade.php`:
```css
background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
```

### Menambah Informasi di Dashboard
Edit `resources/views/customer/dashboard.blade.php` dan tambahkan section baru.

### Mengubah Jumlah Item yang Ditampilkan
Di controller `CustomerDashboardController.php`:
```php
$purchases->take(5)  // Ubah angka 5 sesuai kebutuhan
```

## 📱 Mobile Responsive

Dashboard sudah fully responsive dengan:
- Breakpoint untuk tablet dan mobile
- Flexible grid layout
- Touch-friendly buttons
- Readable font sizes

## 🎉 Fitur Bonus

1. **Auto-refresh** (bisa ditambahkan dengan JavaScript)
2. **Notifikasi** (bisa ditambahkan untuk update status)
3. **Download invoice** (bisa extend dari fitur admin)
4. **Chat support** (bisa integrate WhatsApp)

## 📝 Notes

- Password default customer: `customer123`
- Role 'customer' harus sudah ada di database
- Email customer harus unique
- Customer akan otomatis di-assign role 'customer'

---

**Developed with ❤️ for UMI Cell**
