# Permission untuk Modul Transaksi

Setelah membuat modul transaksi, Anda perlu menambahkan permission berikut ke database agar sistem role & permission berfungsi dengan baik.

## Cara Menambahkan Permission

Ada 2 cara untuk menambahkan permission:

### 1. Melalui Interface Web (Recommended)
Login sebagai Super Admin, lalu masuk ke menu **Pengaturan > Permissions** dan tambahkan permission berikut satu per satu:

### 2. Melalui Database/Seeder
Atau jalankan SQL query berikut di database:

```sql
-- Permission untuk Purchases (Pembelian)
INSERT INTO permissions (name, guard_name, created_at, updated_at) VALUES
('purchases.index', 'web', NOW(), NOW()),
('purchases.create', 'web', NOW(), NOW()),
('purchases.edit', 'web', NOW(), NOW()),
('purchases.delete', 'web', NOW(), NOW()),
('purchases.show', 'web', NOW(), NOW());

-- Permission untuk Sales (Penjualan)
INSERT INTO permissions (name, guard_name, created_at, updated_at) VALUES
('sales.index', 'web', NOW(), NOW()),
('sales.create', 'web', NOW(), NOW()),
('sales.edit', 'web', NOW(), NOW()),
('sales.delete', 'web', NOW(), NOW()),
('sales.show', 'web', NOW(), NOW());

-- Permission untuk Stock Movements (Pergerakan Stok)
INSERT INTO permissions (name, guard_name, created_at, updated_at) VALUES
('stock-movements.index', 'web', NOW(), NOW());

-- Permission untuk Stock Opnames
INSERT INTO permissions (name, guard_name, created_at, updated_at) VALUES
('stock-opnames.index', 'web', NOW(), NOW()),
('stock-opnames.create', 'web', NOW(), NOW()),
('stock-opnames.edit', 'web', NOW(), NOW()),
('stock-opnames.delete', 'web', NOW(), NOW()),
('stock-opnames.show', 'web', NOW(), NOW());
```

## Daftar Permission yang Dibuat

### Purchases (Pembelian)
- `purchases.index` - Melihat daftar pembelian
- `purchases.create` - Membuat pembelian baru
- `purchases.edit` - Mengubah pembelian
- `purchases.delete` - Menghapus pembelian
- `purchases.show` - Melihat detail pembelian

### Sales (Penjualan)
- `sales.index` - Melihat daftar penjualan
- `sales.create` - Membuat penjualan baru
- `sales.edit` - Mengubah penjualan
- `sales.delete` - Menghapus penjualan
- `sales.show` - Melihat detail penjualan

### Stock Movements (Pergerakan Stok)
- `stock-movements.index` - Melihat histori pergerakan stok

### Stock Opnames
- `stock-opnames.index` - Melihat daftar stock opname
- `stock-opnames.create` - Membuat stock opname baru
- `stock-opnames.edit` - Mengubah stock opname
- `stock-opnames.delete` - Menghapus stock opname
- `stock-opnames.show` - Melihat detail stock opname

## Assign Permission ke Role

Setelah permission dibuat, jangan lupa assign permission tersebut ke role yang sesuai melalui menu **Pengaturan > Roles**.

Contoh:
- **Super Admin**: Berikan semua permission
- **Manager**: Berikan semua permission transaksi
- **Kasir**: Berikan hanya `sales.*` permission
- **Staff Gudang**: Berikan `purchases.*`, `stock-movements.index`, `stock-opnames.*`
