<?php

namespace App\Http\Controllers\Spatie;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ProductStock;
use App\Models\SaleDetail;
use App\Models\Sale;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    /**
     * index
     *
     * @return void
     */
    public function index()
    {
        $title = "home";

        // 1. Produk yang sudah mencapai batas minimum stok
        // Mengambil produk dengan stok di bawah atau sama dengan minimum stok
        $lowStockProducts = ProductStock::with(['product', 'branch'])
            ->select('product_stocks.*')
            ->join('products', 'product_stocks.product_id', '=', 'products.id')
            ->whereRaw('product_stocks.quantity <= products.min_stock')
            ->orderBy('product_stocks.quantity', 'asc')
            ->limit(10)
            ->get();

        // 2. Peringkat produk terlaris
        // Menghitung total quantity terjual per produk
        $topSellingProducts = SaleDetail::select(
                'product_id',
                DB::raw('SUM(quantity) as total_sold'),
                DB::raw('SUM(subtotal) as total_revenue')
            )
            ->with(['product.brand'])
            ->groupBy('product_id')
            ->orderBy('total_sold', 'desc')
            ->limit(10)
            ->get();

        // 3. Peringkat customer
        // Menghitung total transaksi dan total pembelian per customer
        $topCustomers = Sale::select(
                'customer_id',
                DB::raw('COUNT(*) as total_transactions'),
                DB::raw('SUM(total_amount) as total_spending')
            )
            ->with('customer')
            ->whereNotNull('customer_id')
            ->groupBy('customer_id')
            ->orderBy('total_spending', 'desc')
            ->limit(10)
            ->get();

        return view('spatie.home', compact(
            'title',
            'lowStockProducts',
            'topSellingProducts',
            'topCustomers'
        ));
    }
}
