<?php

namespace App\Http\Controllers\Spatie;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Permission;

class PermissionController extends Controller
{

    /**
     * __construct
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware(['permission:permissions.index'])->only('index');
    }

    /**
     * function index
     *
     * @return void
     */
    public function index()
    {
        $title = "permission";
        $permissions = Permission::orderBy('id', 'desc')->get();

        return view('spatie.permission', compact('permissions','title'));
    }
}
