@section('heading', 'Detail Produk')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Detail Produk</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{route('product')}}">Produk</a></li>
                    <li class="breadcrumb-item active">Detail</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <!-- Product Info Card -->
            <div class="col-md-4">
                <div class="card card-primary card-outline">
                    <div class="card-body box-profile">
                        <div class="text-center mb-3">
                            <div class="p-3 bg-light rounded">
                                {!! generateQrCode($product->barcode, 150) !!}
                            </div>
                            <p class="text-muted mt-2 mb-0">Scan untuk detail</p>
                            <small class="text-muted">{{$product->barcode}}</small>
                            <div class="mt-2">
                                <a href="{{ route('product.qrcode-jpg', $product->id) }}" class="btn btn-success btn-sm">
                                    <i class="fas fa-download"></i> Unduh QR Code (JPG)
                                </a>
                            </div>
                        </div>

                        <h3 class="profile-username text-center">{{$product->name}}</h3>

                        <p class="text-muted text-center">
                            <span class="badge badge-info">{{$product->category->name}}</span>
                            <span class="badge badge-secondary">{{$product->brand->name}}</span>
                        </p>

                        <ul class="list-group list-group-unbordered mb-3">
                            <li class="list-group-item">
                                <b>Total Stok</b>
                                <a class="float-right">
                                    <span class="badge badge-lg badge-{{$totalStock < $product->min_stock ? 'danger' : 'success'}}">
                                        {{number_format($totalStock, 0, ',', '.')}} {{$product->unit}}
                                    </span>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>Min. Stok</b>
                                <a class="float-right">
                                    <span class="badge badge-warning">
                                        {{number_format($product->min_stock, 0, ',', '.')}} {{$product->unit}}
                                    </span>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>Nilai Stok</b>
                                <a class="float-right">
                                    <strong class="text-success">Rp {{number_format($stockValue, 0, ',', '.')}}</strong>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>Status Stok</b>
                                <a class="float-right">
                                    @if($totalStock >= $product->min_stock)
                                    <span class="badge badge-success">Tersedia</span>
                                    @elseif($totalStock > 0)
                                    <span class="badge badge-warning">Stok Rendah</span>
                                    @else
                                    <span class="badge badge-danger">Habis</span>
                                    @endif
                                </a>
                            </li>
                        </ul>

                        @if($product->description)
                        <hr>
                        <strong><i class="fas fa-info-circle mr-1"></i> Deskripsi</strong>
                        <p class="text-muted mt-2" style="white-space: pre-line;">
                            {{$product->description}}
                        </p>
                        @endif

                        <a href="{{route('product')}}" class="btn btn-secondary btn-block">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-md-8">
                <!-- Stock per Branch -->
                <div class="card card-success">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-warehouse mr-2"></i>Stok Per Cabang</h3>
                    </div>
                    <div class="card-body">
                        @if($product->productStocks->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Cabang</th>
                                        <th class="text-center">Stok</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-right">Nilai Stok</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($product->productStocks as $stock)
                                    @php
                                        $price = $product->productPrices
                                            ->where('branch_id', $stock->branch_id)
                                            ->sortByDesc('effective_date')
                                            ->first();
                                        $value = $price ? ($stock->quantity * $price->purchase_price) : 0;
                                    @endphp
                                    <tr>
                                        <td>
                                            <i class="far fa-building mr-2 text-primary"></i>
                                            <strong>{{$stock->branch->name}}</strong>
                                        </td>
                                        <td class="text-center">
                                            <h5 class="mb-0">
                                                <span class="badge badge-{{$stock->quantity < $product->min_stock ? 'danger' : 'info'}}">
                                                    {{number_format($stock->quantity, 0, ',', '.')}} {{$product->unit}}
                                                </span>
                                            </h5>
                                        </td>
                                        <td class="text-center">
                                            @if($stock->quantity >= $product->min_stock)
                                            <span class="badge badge-success">Aman</span>
                                            @elseif($stock->quantity > 0)
                                            <span class="badge badge-warning">Rendah</span>
                                            @else
                                            <span class="badge badge-danger">Habis</span>
                                            @endif
                                        </td>
                                        <td class="text-right">
                                            <strong class="text-success">Rp {{number_format($value, 0, ',', '.')}}</strong>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr class="bg-light">
                                        <th>Total</th>
                                        <th class="text-center">
                                            <span class="badge badge-primary badge-lg">
                                                {{number_format($totalStock, 0, ',', '.')}} {{$product->unit}}
                                            </span>
                                        </th>
                                        <th></th>
                                        <th class="text-right">
                                            <strong class="text-success">Rp {{number_format($stockValue, 0, ',', '.')}}</strong>
                                        </th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        @else
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle mr-2"></i>
                            Belum ada data stok untuk produk ini.
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Price per Branch -->
                <div class="card card-warning">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-tags mr-2"></i>Harga Per Cabang</h3>
                    </div>
                    <div class="card-body">
                        @if($product->productPrices->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Cabang</th>
                                        <th class="text-right">Harga Beli</th>
                                        <th class="text-right">Harga Jual</th>
                                        <th class="text-right">Margin</th>
                                        <th class="text-center">Efektif</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($product->productPrices->sortBy('branch.name') as $price)
                                    @php
                                        $margin = $price->selling_price - $price->purchase_price;
                                        $marginPercent = $price->purchase_price > 0 ? ($margin / $price->purchase_price * 100) : 0;
                                    @endphp
                                    <tr>
                                        <td>
                                            <i class="far fa-building mr-2 text-warning"></i>
                                            <strong>{{$price->branch->name}}</strong>
                                        </td>
                                        <td class="text-right">
                                            <span class="badge badge-info">
                                                Rp {{number_format($price->purchase_price, 0, ',', '.')}}
                                            </span>
                                        </td>
                                        <td class="text-right">
                                            <span class="badge badge-success">
                                                Rp {{number_format($price->selling_price, 0, ',', '.')}}
                                            </span>
                                        </td>
                                        <td class="text-right">
                                            <strong class="text-{{$margin > 0 ? 'success' : 'danger'}}">
                                                Rp {{number_format($margin, 0, ',', '.')}}
                                                <small>({{number_format($marginPercent, 1)}}%)</small>
                                            </strong>
                                        </td>
                                        <td class="text-center">
                                            <small class="text-muted">{{date('d/m/Y', strtotime($price->effective_date))}}</small>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @else
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle mr-2"></i>
                            Belum ada data harga untuk produk ini.
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Product Statistics -->
                <div class="row">
                    <div class="col-md-4">
                        <div class="info-box bg-info">
                            <span class="info-box-icon"><i class="fas fa-boxes"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Total Stok</span>
                                <span class="info-box-number">{{number_format($totalStock, 0, ',', '.')}} {{$product->unit}}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-box bg-success">
                            <span class="info-box-icon"><i class="fas fa-dollar-sign"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Nilai Total</span>
                                <span class="info-box-number">Rp {{number_format($stockValue, 0, ',', '.')}}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-box bg-warning">
                            <span class="info-box-icon"><i class="fas fa-warehouse"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Tersedia di</span>
                                <span class="info-box-number">{{$product->productStocks->count()}} Cabang</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
