@section('heading', 'Edit Penjualan')
@extends('layouts.app')

@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Edit Penjualan</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('sale') }}">Penjualan</a></li>
                    <li class="breadcrumb-item active">Edit</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">

        <form action="{{ route('sale.update', $sale->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="row">
                <!-- ================= LEFT ================= -->
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Detail Produk</h3>
                        </div>

                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Produk</th>
                                            <th>Satuan</th>
                                            <th>Qty</th>
                                            <th>Harga</th>
                                            <th>Diskon</th>
                                            <th>Sub Total</th>
                                        </tr>
                                    </thead>

                                    <tbody id="detailBody">
                                        @foreach($sale->saleDetails as $i => $detail)
                                        <tr>
                                            <input type="hidden" name="details[{{ $i }}][purchase_price]" value="{{ $detail->purchase_price }}">


                                            <td>
                                                {{ $detail->product->name }}
                                                <input type="hidden" name="details[{{ $i }}][product_id]" value="{{ $detail->product_id }}">
                                                <input type="hidden" name="details[{{ $i }}][purchase_price]" value="{{ $detail->purchase_price }}">
                                            </td>

                                            <td class="text-center">{{ $detail->product->unit }}</td>
                                            <td>
                                                <input type="number" name="details[{{ $i }}][quantity]" class="form-control qty-input" value="{{ $detail->quantity }}" min="1">
                                            </td>
                                            <td>
                                                <input type="number" name="details[{{ $i }}][selling_price]" class="form-control price-input" value="{{ $detail->selling_price }}" min="0">
                                            </td>
                                            <td>
                                                <input type="number" name="details[{{ $i }}][discount]" class="form-control discount-input" value="{{ $detail->discount }}" min="0">
                                            </td>
                                            <td class="text-right">
                                                <strong class="subtotal-text" data-subtotal="{{ $detail->subtotal }}">
                                                    Rp {{ number_format($detail->subtotal,0,',','.') }}
                                                </strong>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ================= RIGHT ================= -->
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Informasi Penjualan</h3>
                        </div>

                        <div class="card-body">

                            <div class="form-group">
                                <label>No Penjualan</label>
                                <input type="text" class="form-control" value="{{ $sale->sale_number }}" readonly>
                            </div>

                            <div class="form-group">
                                <label>Cabang</label>
                                <input type="text" class="form-control" value="{{ $sale->branch->name }}" readonly>
                                <input type="hidden" name="branch_id" value="{{ $sale->branch_id }}">
                            </div>

                            <div class="form-group">
                                <label>Customer</label>
                                <input type="text" class="form-control" value="{{ $sale->customer->name ?? 'Umum' }}" readonly>
                                <input type="hidden" name="customer_id" value="{{ $sale->customer_id }}">
                            </div>

                            <div class="form-group">
                                <label>Tanggal Penjualan</label>
                                <input type="text" class="form-control" value="{{ \Carbon\Carbon::parse($sale->sale_date)->format('d/m/Y') }}" readonly>
                                <input type="hidden" name="sale_date" value="{{ $sale->sale_date }}">
                            </div>

                            <div class="form-group">
                                <label>Metode Pembayaran</label>
                                <input type="text" class="form-control" value="{{ ucfirst($sale->payment_method) }}" readonly>
                                <input type="hidden" name="payment_method" value="{{ $sale->payment_method }}">
                            </div>

                            <div class="form-group">
                                <label>Catatan</label>
                                <textarea class="form-control" readonly>{{ $sale->notes }}</textarea>
                                <input type="hidden" name="notes" value="{{ $sale->notes }}">
                            </div>

                            <hr>

                            <div class="form-group">
                                <label>Total Penjualan</label>
                                <h3 class="text-success" id="totalAmount">
                                    Rp {{ number_format($sale->total_amount,0,',','.') }}
                                </h3>
                            </div>

                        </div>

                        <div class="card-footer">
                            <button type="submit" class="btn btn-success btn-block">
                                <i class="fas fa-save"></i> Update Penjualan
                            </button>
                            <a href="{{ route('sale') }}" class="btn btn-secondary btn-block">
                                Kembali
                            </a>
                        </div>

                    </div>
                </div>

            </div>
        </form>

    </div>
</section>
@endsection

<!-- ================= HITUNG SUBTOTAL & TOTAL ================= -->
<script>
    function formatRupiah(number) {
        return 'Rp ' + number.toLocaleString('id-ID');
    }

    function updateRowSubtotal(row) {
        const qty = parseFloat(row.querySelector('.qty-input').value) || 0;
        const price = parseFloat(row.querySelector('.price-input').value) || 0;
        const discount = parseFloat(row.querySelector('.discount-input').value) || 0;

        const subtotal = (qty * price) - discount;

        const subtotalText = row.querySelector('.subtotal-text');
        subtotalText.textContent = formatRupiah(subtotal);
        subtotalText.dataset.subtotal = subtotal;

        updateTotal();
    }

    function updateTotal() {
        let total = 0;
        document.querySelectorAll('.subtotal-text').forEach(el => {
            total += parseFloat(el.dataset.subtotal) || 0;
        });

        document.getElementById('totalAmount').textContent = formatRupiah(total);
    }

    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.qty-input, .price-input, .discount-input')
            .forEach(input => {
                input.addEventListener('input', function() {
                    updateRowSubtotal(this.closest('tr'));
                });
            });
    });

</script>
