<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Nota Service - {{$service->service_number}}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        .header h2 {
            margin: 5px 0;
            font-size: 20px;
            font-weight: bold;
        }
        .header p {
            margin: 3px 0;
            font-size: 10px;
        }
        .title {
            text-align: center;
            font-size: 16px;
            font-weight: bold;
            margin: 15px 0;
            text-decoration: underline;
        }
        .info-section {
            margin-bottom: 20px;
        }
        .info-row {
            margin-bottom: 5px;
        }
        .info-left {
            width: 50%;
            float: left;
        }
        .info-right {
            width: 50%;
            float: right;
        }
        .clear {
            clear: both;
        }
        .device-box {
            border: 2px solid #000;
            padding: 10px;
            margin-bottom: 20px;
            background-color: #f5f5f5;
        }
        .device-box h3 {
            margin: 0 0 10px 0;
            font-size: 14px;
            border-bottom: 1px solid #000;
            padding-bottom: 5px;
        }
        .complaint-box {
            border: 1px solid #000;
            padding: 10px;
            margin-bottom: 15px;
            min-height: 50px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        table.bordered {
            border: 1px solid #000;
        }
        table.bordered th,
        table.bordered td {
            border: 1px solid #000;
            padding: 5px 8px;
        }
        table.bordered th {
            background-color: #e0e0e0;
            font-weight: bold;
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .font-bold {
            font-weight: bold;
        }
        .summary-table {
            margin-top: 20px;
            width: 50%;
            float: right;
        }
        .summary-table td {
            padding: 5px 10px;
        }
        .total-row {
            background-color: #e0e0e0;
            font-weight: bold;
            font-size: 12px;
        }
        .status-badge {
            display: inline-block;
            padding: 3px 10px;
            border: 1px solid #000;
            background-color: #f0f0f0;
            font-weight: bold;
        }
        .signature-section {
            margin-top: 80px;
            clear: both;
        }
        .signature-box {
            width: 30%;
            text-align: center;
        }
        .signature-left {
            float: left;
        }
        .signature-center {
            float: left;
            margin-left: 5%;
        }
        .signature-right {
            float: right;
        }
        .signature-line {
            margin-top: 60px;
            border-top: 1px solid #000;
            padding-top: 5px;
        }
        .notes-box {
            border: 1px dashed #000;
            padding: 10px;
            margin-top: 20px;
            background-color: #fffef0;
        }
    </style>
</head>
<body>
    @php
        $logoPath = base_path('../logo/logo-umi.png');
        $logoExists = file_exists($logoPath);
        $logoBase64 = '';
        if($logoExists) {
            $imageData = base64_encode(file_get_contents($logoPath));
            $logoBase64 = 'data:image/png;base64,' . $imageData;
        }
    @endphp

    <div class="header">
        <div style="
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center;
            width: 100%;
            white-space: nowrap;
        ">
            @if($logoExists)
                <img src="{{ $logoBase64 }}"
                    style="
                        height:50px;
                        width:50px;
                        display:inline-block !important;
                        vertical-align: middle;
                        margin-right:10px;
                    ">
            @endif

            <span style="
                font-size:24px;
                font-weight:bold;
                display:inline-block;
                vertical-align: middle;
            ">
                UMI CELL
            </span>
        </div>

        <p>Jl. Raya Semarang-Boja, Jatisari, Kec. Mijen, Kota Semarang Jawa Tengah 50275</p>
        <p>Telp: 0882005564342</p>
    </div>

    <div class="title">NOTA SERVICE</div>

    <div class="info-section">
        <div class="info-left">
            <div class="info-row">
                <strong>No. Service:</strong> {{$service->service_number}}
            </div>
            <div class="info-row">
                <strong>Tanggal Terima:</strong> {{date('d/m/Y', strtotime($service->service_date))}}
            </div>
            <div class="info-row">
                <strong>Cabang:</strong> {{$service->branch->name}}
            </div>
        </div>
        <div class="info-right">
            <div class="info-row">
                <strong>Customer:</strong> {{$service->customer->name}}
            </div>
            <div class="info-row">
                <strong>Telp:</strong> {{$service->customer->phone ?? '-'}}
            </div>
            <div class="info-row">
                <strong>Alamat:</strong> {{$service->customer->address ?? '-'}}
            </div>
        </div>
        <div class="clear"></div>
    </div>

    <div class="device-box">
        <h3>INFORMASI PERANGKAT</h3>
        <table style="border: none;">
            <tr>
                <td style="width: 30%; border: none;"><strong>Jenis Perangkat:</strong></td>
                <td style="border: none;">{{$service->device_type}}</td>
            </tr>
            <tr>
                <td style="border: none;"><strong>Merek:</strong></td>
                <td style="border: none;">{{$service->device_brand}}</td>
            </tr>
            <tr>
                <td style="border: none;"><strong>Model:</strong></td>
                <td style="border: none;">{{$service->device_model}}</td>
            </tr>
            @if($service->imei)
            <tr>
                <td style="border: none;"><strong>IMEI:</strong></td>
                <td style="border: none;">{{$service->imei}}</td>
            </tr>
            @endif
        </table>
    </div>

    <div style="margin-bottom: 15px;">
        <strong>KELUHAN PELANGGAN:</strong>
        <div class="complaint-box">
            {{$service->complaint}}
        </div>
    </div>

    @if($service->diagnosis)
    <div style="margin-bottom: 15px;">
        <strong>DIAGNOSA TEKNISI:</strong>
        <div class="complaint-box">
            {{$service->diagnosis}}
        </div>
    </div>
    @endif

    @if($service->serviceDetails->count() > 0)
    <div style="margin-top: 20px;">
        <strong>SPARE PART YANG DIGUNAKAN:</strong>
        <table class="bordered">
            <thead>
                <tr>
                    <th style="width: 5%;">No</th>
                    <th style="width: 45%;">Nama Spare Part</th>
                    <th style="width: 15%;">Qty</th>
                    <th style="width: 17.5%;">Harga Satuan</th>
                    <th style="width: 17.5%;">Subtotal</th>
                </tr>
            </thead>
            <tbody>
                @foreach($service->serviceDetails as $index => $detail)
                <tr>
                    <td class="text-center">{{$index + 1}}</td>
                    <td>{{$detail->product->name}}</td>
                    <td class="text-center">{{number_format($detail->quantity, 0, ',', '.')}}</td>
                    <td class="text-right">Rp {{number_format($detail->unit_price, 0, ',', '.')}}</td>
                    <td class="text-right">Rp {{number_format($detail->subtotal, 0, ',', '.')}}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @endif

    <div class="summary-table">
        <table>
            <tr>
                <td><strong>Biaya Jasa Service:</strong></td>
                <td class="text-right">Rp {{number_format($service->service_fee, 0, ',', '.')}}</td>
            </tr>
            <tr>
                <td><strong>Biaya Spare Part:</strong></td>
                <td class="text-right">Rp {{number_format($service->parts_cost, 0, ',', '.')}}</td>
            </tr>
            <tr class="total-row">
                <td><strong>TOTAL BIAYA:</strong></td>
                <td class="text-right"><strong>Rp {{number_format($service->total_cost, 0, ',', '.')}}</strong></td>
            </tr>
            <tr>
                <td><strong>Uang Muka (DP):</strong></td>
                <td class="text-right">Rp {{number_format($service->down_payment, 0, ',', '.')}}</td>
            </tr>
            <tr style="background-color: #ffe6e6;">
                <td><strong>Sisa Pembayaran:</strong></td>
                <td class="text-right"><strong>Rp {{number_format($service->remaining_payment, 0, ',', '.')}}</strong></td>
            </tr>
        </table>
    </div>

    <div style="clear: both; margin-top: 20px;">
        <table style="border: none;">
            <tr>
                <td style="width: 30%; border: none;"><strong>Teknisi:</strong></td>
                <td style="border: none;">{{$service->technician ? $service->technician->name : '-'}}</td>
            </tr>
            <tr>
                <td style="border: none;"><strong>Prioritas:</strong></td>
                <td style="border: none;">
                    @if($service->priority == 'normal')
                        Normal
                    @elseif($service->priority == 'urgent')
                        Urgent
                    @else
                        Very Urgent
                    @endif
                </td>
            </tr>
            <tr>
                <td style="border: none;"><strong>Status:</strong></td>
                <td style="border: none;">
                    <span class="status-badge">{{strtoupper($service->status)}}</span>
                </td>
            </tr>
            @if($service->estimated_completion)
            <tr>
                <td style="border: none;"><strong>Estimasi Selesai:</strong></td>
                <td style="border: none;">{{$service->estimated_completion->format('d/m/Y H:i')}}</td>
            </tr>
            @endif
        </table>
    </div>

    @if($service->notes)
    <div class="notes-box">
        <strong>CATATAN:</strong><br>
        {{$service->notes}}
    </div>
    @endif

    <div style="border: 2px dashed #000; padding: 10px; margin-top: 20px; background-color: #fff8e1;">
        <strong>PERHATIAN:</strong>
        <ul style="margin: 5px 0; padding-left: 20px;">
            <li>Barang yang sudah diambil tidak dapat dikembalikan</li>
            <li>Garansi service 7 hari untuk kerusakan yang sama</li>
            <li>Harap membawa nota ini saat pengambilan</li>
            <li>Barang yang tidak diambil dalam 30 hari, menjadi milik toko</li>
        </ul>
    </div>

    <div class="signature-section">
        <div class="signature-box signature-left">
            <div>Penerima,</div>
            <div class="signature-line">
                ({{$service->customer->name}})
            </div>
        </div>
        <div class="signature-box signature-center">
            <div>Teknisi,</div>
            <div class="signature-line">
                ({{$service->technician ? $service->technician->name : '................'}})
            </div>
        </div>
        <div class="signature-box signature-right">
            <div>Petugas,</div>
            <div class="signature-line">
                (................................)
            </div>
        </div>
        <div class="clear"></div>
    </div>

    @if($service->barcode)
        <div style="text-align: right; margin: 0px 0; padding: 0px; border: 0px solid #000;">
            <img src="{{ generateQrCodeBase64($service->barcode, 100) }}" style="width: 100px; height: 100px; margin-bottom: 10px;">
        </div>
    @endif

    <p style="margin-top: 0px; font-size: 9px; text-align: right; clear: both;">
        Dicetak pada: {{date('d M Y H:i')}}
    </p>
</body>
</html>
