@section('heading', 'Tambah Stock Opname')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Tambah Stock Opname</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{route('stock-opname')}}">Stock Opname</a></li>
                    <li class="breadcrumb-item active">Tambah</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <form action="{{route('stock-opname.save')}}" method="POST" id="opnameForm">
            @csrf
            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Detail Produk</h3>
                            <div class="card-tools">
                                <button type="button" id="loadProductsBtn" class="btn btn-primary btn-sm" disabled>
                                    <i class="fas fa-sync"></i> Muat Produk
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-sm" id="detailTable">
                                    <thead>
                                        <tr>
                                            <th style="width: 5%;">No</th>
                                            <th style="width: 30%;">Produk</th>
                                            <th style="width: 10%;">Satuan</th>
                                            <th style="width: 15%;">Stok Sistem</th>
                                            <th style="width: 15%;">Stok Fisik</th>
                                            <th style="width: 10%;">Selisih</th>
                                            <th style="width: 15%;">Catatan</th>
                                        </tr>
                                    </thead>
                                    <tbody id="detailBody">
                                        <tr class="text-center">
                                            <td colspan="7">Pilih cabang dan klik "Muat Produk" untuk memuat data</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Informasi Stock Opname</h3>
                        </div>
                        <div class="card-body">
                            @if(session('error'))
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                {{ session('error') }}
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            @endif

                            <div class="form-group">
                                <label>No. Opname</label>
                                <input type="text" class="form-control" value="{{$opnameNumber}}" readonly>
                            </div>

                            <div class="form-group">
                                <label>Cabang <span class="text-danger">*</span></label>
                                <select name="branch_id" id="branchSelect" class="form-control @error('branch_id') is-invalid @enderror" required>
                                    <option value="">-- Pilih Cabang --</option>
                                    @foreach($branches as $branch)
                                    <option value="{{$branch->id}}" {{old('branch_id') == $branch->id ? 'selected' : ''}}>
                                        {{$branch->name}}
                                    </option>
                                    @endforeach
                                </select>
                                @error('branch_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Tanggal Opname <span class="text-danger">*</span></label>
                                <input type="date" name="opname_date" class="form-control @error('opname_date') is-invalid @enderror"
                                    value="{{old('opname_date', date('Y-m-d'))}}" required>
                                @error('opname_date')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Catatan</label>
                                <textarea name="notes" class="form-control" rows="3">{{old('notes')}}</textarea>
                            </div>

                            <hr>

                            <div class="form-group">
                                <label>Total Item dengan Selisih</label>
                                <h4 id="totalDifference">0 item</h4>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-success btn-block" id="submitBtn" disabled>
                                <i class="fas fa-save"></i> Simpan Stock Opname
                            </button>
                            <a href="{{route('stock-opname')}}" class="btn btn-secondary btn-block">
                                <i class="fas fa-arrow-left"></i> Kembali
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</section>
@endsection

@push('scripts')
<script>
let detailIndex = 0;

$(function() {
    const branchSelect = document.getElementById('branchSelect');
    const loadProductsBtn = document.getElementById('loadProductsBtn');

    branchSelect.addEventListener('change', function() {
        loadProductsBtn.disabled = !this.value;
        // Clear table if branch changes
        const detailBody = document.getElementById('detailBody');
        detailBody.innerHTML = '<tr class="text-center"><td colspan="7">Pilih cabang dan klik "Muat Produk" untuk memuat data</td></tr>';
        detailIndex = 0;
        updateCalculation();
    });

    loadProductsBtn.addEventListener('click', async function() {
        const branchId = branchSelect.value;
        if (!branchId) {
            alert('Pilih cabang terlebih dahulu!');
            return;
        }

        loadProductsBtn.disabled = true;
        loadProductsBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Memuat...';

        try {
            const response = await fetch(`{{url('/admin/stock-opname/get-products')}}?branch_id=${branchId}`);
            const products = await response.json();

            const detailBody = document.getElementById('detailBody');
            detailBody.innerHTML = '';
            detailIndex = 0;

            if (products.length === 0) {
                detailBody.innerHTML = '<tr class="text-center"><td colspan="7">Tidak ada produk dengan stok di cabang ini</td></tr>';
            } else {
                products.forEach(product => {
                    addProductRow(product);
                });
            }

            loadProductsBtn.innerHTML = '<i class="fas fa-sync"></i> Muat Produk';
            loadProductsBtn.disabled = false;

        } catch (error) {
            console.error('Error:', error);
            alert('Terjadi kesalahan saat memuat data produk');
            loadProductsBtn.innerHTML = '<i class="fas fa-sync"></i> Muat Produk';
            loadProductsBtn.disabled = false;
        }
    });
});

function addProductRow(product) {
    const tbody = document.getElementById('detailBody');

    const row = `
        <tr id="row-${detailIndex}">
            <td>${detailIndex + 1}</td>
            <td>
                ${product.name} - ${product.brand}
                <input type="hidden" name="details[${detailIndex}][product_id]" value="${product.id}">
                <input type="hidden" name="details[${detailIndex}][system_stock]" value="${product.system_stock}" class="system-stock">
            </td>
            <td>${product.unit}</td>
            <td class="text-center"><span class="badge badge-info">${product.system_stock}</span></td>
            <td>
                <input type="number" name="details[${detailIndex}][physical_stock]" class="form-control form-control-sm physical-stock"
                    value="${product.system_stock}" min="0" step="1" required data-index="${detailIndex}">
            </td>
            <td class="text-center difference-cell" id="difference-${detailIndex}">
                <span class="badge badge-secondary">0</span>
            </td>
            <td>
                <input type="text" name="details[${detailIndex}][notes]" class="form-control form-control-sm"
                    placeholder="Catatan...">
            </td>
        </tr>
    `;

    tbody.insertAdjacentHTML('beforeend', row);
    detailIndex++;

    addCalculationListeners();
}

function addCalculationListeners() {
    document.querySelectorAll('.physical-stock').forEach(input => {
        input.addEventListener('input', function() {
            const index = this.dataset.index;
            updateRowDifference(index);
            updateCalculation();
        });
    });
}

function updateRowDifference(index) {
    const row = document.getElementById(`row-${index}`);
    if (!row) return;

    const systemStock = parseFloat(row.querySelector('.system-stock').value) || 0;
    const physicalStock = parseFloat(row.querySelector('.physical-stock').value) || 0;
    const differenceCell = document.getElementById(`difference-${index}`);

    const difference = physicalStock - systemStock;

    let badgeClass = 'badge-secondary';
    let sign = '';

    if (difference > 0) {
        badgeClass = 'badge-success';
        sign = '+';
    } else if (difference < 0) {
        badgeClass = 'badge-danger';
    }

    differenceCell.innerHTML = `<span class="badge ${badgeClass}">${sign}${difference}</span>`;
}

function updateCalculation() {
    let itemsWithDifference = 0;
    const tbody = document.getElementById('detailBody');
    const rows = tbody.querySelectorAll('tr');

    rows.forEach(row => {
        const systemStock = row.querySelector('.system-stock');
        const physicalStock = row.querySelector('.physical-stock');

        if (systemStock && physicalStock) {
            const system = parseFloat(systemStock.value) || 0;
            const physical = parseFloat(physicalStock.value) || 0;

            if (system !== physical) {
                itemsWithDifference++;
            }
        }
    });

    document.getElementById('totalDifference').textContent = itemsWithDifference + ' item';

    const submitBtn = document.getElementById('submitBtn');
    submitBtn.disabled = itemsWithDifference === 0;
}
</script>
@endpush
