<?php $__env->startSection('heading', 'Detail Penjualan'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Detail Penjualan</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('sale')); ?>">Penjualan</a></li>
                    <li class="breadcrumb-item active">Detail</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Detail Produk</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>Produk</th>
                                    <th style="width: 12%;">Qty</th>
                                    <th style="width: 18%;">Harga</th>
                                    <th style="width: 15%;">Diskon</th>
                                    <th style="width: 18%;">Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $sale->saleDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($detail->product->name); ?></td>
                                    <td><?php echo e(number_format($detail->quantity, 0, ',', '.')); ?> <?php echo e($detail->product->unit); ?></td>
                                    <td class="text-right">Rp <?php echo e(number_format($detail->selling_price, 0, ',', '.')); ?></td>
                                    <td class="text-right">Rp <?php echo e(number_format($detail->discount, 0, ',', '.')); ?></td>
                                    <td class="text-right">Rp <?php echo e(number_format($detail->subtotal, 0, ',', '.')); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th colspan="5" class="text-right">Subtotal</th>
                                    <th class="text-right">Rp <?php echo e(number_format($sale->subtotal, 0, ',', '.')); ?></th>
                                </tr>
                                <tr>
                                    <th colspan="5" class="text-right">Diskon</th>
                                    <th class="text-right">Rp <?php echo e(number_format($sale->discount, 0, ',', '.')); ?></th>
                                </tr>
                                <tr>
                                    <th colspan="5" class="text-right">Pajak</th>
                                    <th class="text-right">Rp <?php echo e(number_format($sale->tax, 0, ',', '.')); ?></th>
                                </tr>
                                <tr>
                                    <th colspan="5" class="text-right">Total</th>
                                    <th class="text-right text-success">Rp <?php echo e(number_format($sale->total_amount, 0, ',', '.')); ?></th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Informasi Penjualan</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <th style="width: 40%;">No. Penjualan</th>
                                <td><?php echo e($sale->sale_number); ?></td>
                            </tr>
                            <tr>
                                <th>Customer</th>
                                <td><?php echo e($sale->customer ? $sale->customer->name : 'Umum'); ?></td>
                            </tr>
                            <tr>
                                <th>Cabang</th>
                                <td><?php echo e($sale->branch->name); ?></td>
                            </tr>
                            <tr>
                                <th>Tanggal</th>
                                <td><?php echo e(TanggalID($sale->sale_date)); ?></td>
                            </tr>
                            <tr>
                                <th>Metode Bayar</th>
                                <td>
                                    <?php if($sale->payment_method == 'cash'): ?>
                                    <span class="badge badge-success">Tunai</span>
                                    <?php elseif($sale->payment_method == 'transfer'): ?>
                                    <span class="badge badge-info">Transfer</span>
                                    <?php else: ?>
                                    <span class="badge badge-warning">Kredit</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    <?php if($sale->status == 'pending'): ?>
                                    <span class="badge badge-warning">Pending</span>
                                    <?php elseif($sale->status == 'completed'): ?>
                                    <span class="badge badge-success">Selesai</span>
                                    <?php else: ?>
                                    <span class="badge badge-danger">Batal</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Kasir</th>
                                <td><?php echo e($sale->cashier->name); ?></td>
                            </tr>
                            <?php if($sale->notes): ?>
                            <tr>
                                <th>Catatan</th>
                                <td><?php echo e($sale->notes); ?></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <th>Dibuat</th>
                                <td><?php echo e(TanggalID($sale->created_at)); ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="card-footer">
                        <a href="<?php echo e(route('sale')); ?>" class="btn btn-secondary btn-block">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <a href="<?php echo e(route('sale.invoice-pdf', $sale->id)); ?>" class="btn btn-success btn-block" target="_blank">
                            <i class="fas fa-print"></i> Cetak Faktur
                        </a>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sales.edit')): ?>
                        <?php if($sale->status == 'pending'): ?>
                        <a href="<?php echo e(route('sale.edit', $sale->id)); ?>" class="btn btn-primary btn-block">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- QR Code Card -->
                <?php if($sale->barcode): ?>
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h3 class="card-title"><i class="fas fa-qrcode"></i> QR Code Penjualan</h3>
                    </div>
                    <div class="card-body text-center">
                        <div style="max-width: 300px; margin: 0 auto; border: 0px solid #007bff; border-radius: 10px; padding: 10px;">
                            <?php echo generateQrCode($sale->barcode, 300); ?>

                        </div>
                        <p class="mt-3 mb-0" style="font-size: 14px; color: #666;">
                            <code><?php echo e($sale->barcode); ?></code>
                        </p>
                        <small class="text-muted">Scan QR Code ini untuk cepat mencari penjualan</small>

                        <!-- Download QR Code Button -->
                        <div class="mt-3">
                            <a href="<?php echo e(route('sale.qrcode-jpg', $sale->id)); ?>"
                               class="btn btn-success btn-sm">
                                <i class="fas fa-download"></i> Unduh QR Code (JPG)
                            </a>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\laravel\resources\views/transaction/sale/show.blade.php ENDPATH**/ ?>