{{-- <aside class="main-sidebar sidebar-light-dark elevation-4"> --}}
<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="#" class="brand-link">
        <img src="{{asset('logo/logo-umi.png')}}" alt="AdminLTE Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
        <span class="brand-text font-weight-light"> UMI-CELL </span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar user panel (optional) -->
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="info">
                <a href="#" class="d-block"> {{ Auth::user()->name }} </a>
            </div>
        </div>

        <!-- SidebarSearch Form -->
        <div class="form-inline">
            <div class="input-group" data-widget="sidebar-search">
                <input class="form-control form-control-sidebar" type="search" placeholder="Search" aria-label="Search">
                <div class="input-group-append">
                    <button class="btn btn-sidebar">
                        <i class="fas fa-search fa-fw"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <li class="nav-item">
                    <a href="{{route('home')}}" class="nav-link {{($title === "home") ? 'active' : ''}}">
                        <i class="nav-icon fas fa-home"></i>
                        <p> Home </p>
                    </a>
                </li>

                <li class="nav-item {{ in_array($title, ['branch','category','brand','supplier','customer']) ? 'menu-open' : '' }}">
                    <a href="#" class="nav-link {{ in_array($title, ['branch','category','brand','supplier','customer']) ? 'active' : '' }}">
                        <i class="nav-icon fas fa-database"></i>
                        <p>
                            Master
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            @can('branches.index')
                                <a href="{{route('branch')}}" class="nav-link {{($title === "branch") ? 'active' : ''}}">
                                    <i class="nav-icon far fa-building"></i>
                                    <p> Cabang </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-item">
                            @can('categories.index')
                                <a href="{{route('category')}}" class="nav-link {{($title === "category") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-list"></i>
                                    <p> Kategori </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-item">
                            @can('brands.index')
                                <a href="{{route('brand')}}" class="nav-link {{($title === "brand") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-tag"></i>
                                    <p> Merek </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-item">
                            @can('suppliers.index')
                                <a href="{{route('supplier')}}" class="nav-link {{($title === "supplier") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-truck"></i>
                                    <p> Supplier </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-item">
                            @can('customers.index')
                                <a href="{{route('customer')}}" class="nav-link {{($title === "customer") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-users"></i>
                                    <p> Customer </p>
                                </a>
                            @endcan
                        </li>
                    </ul>
                </li>

                <li class="nav-item {{ in_array($title, ['role','permission','user']) ? 'menu-open' : '' }}">
                    <a href="#" class="nav-link {{ in_array($title, ['role','permission','user']) ? 'active' : '' }}">
                        <i class="nav-icon fas fa-cogs"></i>
                        <p>
                            Pengaturan
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            @can('roles.index')
                                <a href="{{route('role')}}" class="nav-link {{($title === "role") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-user-shield"></i>
                                    <p> Roles </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-item">
                            @can('permissions.index')
                                <a href="{{route('admin.permission.index')}}" class="nav-link {{($title === "permission") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-key"></i>
                                    <p> Permissions </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-item">
                            @can('users.index')
                                <a href="{{route('user')}}" class="nav-link {{($title === "user") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-user"></i>
                                    <p> Users </p>
                                </a>
                            @endcan
                        </li>
                    </ul>
                </li>

                <li class="nav-item {{ in_array($title, ['product']) ? 'menu-open' : '' }}">
                    <a href="#" class="nav-link {{ in_array($title, ['product']) ? 'active' : '' }}">
                        <i class="nav-icon fas fa-cubes"></i>
                        <p>
                            Produk
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            @can('products.index')
                                <a href="{{route('product')}}" class="nav-link {{($title === "product") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-mobile-alt"></i>
                                    <p> Produk </p>
                                </a>
                            @endcan
                        </li>
                    </ul>
                </li>

                <li class="nav-item {{ in_array($title, ['purchase','sale','service','stock_movement','stock_opname']) ? 'menu-open' : '' }}">
                    <a href="#" class="nav-link {{ in_array($title, ['purchase','sale','service','stock_movement','stock_opname']) ? 'active' : '' }}">
                        <i class="nav-icon fas fa-exchange-alt"></i>
                        <p>
                            Transaksi
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            @can('purchases.index')
                                <a href="{{route('purchase')}}" class="nav-link {{($title === "purchase") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-shopping-cart"></i>
                                    <p> Pembelian </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-item">
                            @can('sales.index')
                                <a href="{{route('sale')}}" class="nav-link {{($title === "sale") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-cash-register"></i>
                                    <p> Penjualan </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-item">
                            @can('services.index')
                                <a href="{{route('services.index')}}" class="nav-link {{($title === "service") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-wrench"></i>
                                    <p> Service </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-item">
                            @can('stock-movements.index')
                                <a href="{{route('stock-movement')}}" class="nav-link {{($title === "stock_movement") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-history"></i>
                                    <p> Pergerakan Stok </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-item">
                            @can('stock-opnames.index')
                                <a href="{{route('stock-opname')}}" class="nav-link {{($title === "stock_opname") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-clipboard-check"></i>
                                    <p> Stock Opname </p>
                                </a>
                            @endcan
                        </li>
                    </ul>
                </li>

                @canany(['profit.index', 'service-reports.index'])
                <li class="nav-item {{ in_array($title, ['profit_loss', 'product_list_report', 'service']) ? 'menu-open' : '' }}">
                    <a href="#" class="nav-link {{ in_array($title, ['profit_loss', 'product_list_report', 'service']) ? 'active' : '' }}">
                        <i class="nav-icon fas fa-chart-line"></i>
                        <p>
                            Laporan
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            @can('profit.index')
                                <a href="{{route('report.profit-loss')}}" class="nav-link {{($title === "profit_loss") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-file-invoice-dollar"></i>
                                    <p> Laba Rugi </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-item">
                            @can('item.index')
                                <a href="{{route('report.product-list')}}" class="nav-link {{($title === "product_list_report") ? 'active' : ''}}">
                                    <i class="nav-icon fas fa-boxes"></i>
                                    <p> Daftar Item </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-header">LAPORAN SERVICE</li>
                        <li class="nav-item">
                            @can('service-reports.index')
                                <a href="{{route('report.service.status')}}" class="nav-link">
                                    <i class="nav-icon fas fa-tasks"></i>
                                    <p> Status Service </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-item">
                            @can('service-reports.index')
                                <a href="{{route('report.service.technician')}}" class="nav-link">
                                    <i class="nav-icon fas fa-user-cog"></i>
                                    <p> Kinerja Teknisi </p>
                                </a>
                            @endcan
                        </li>
                        <li class="nav-item">
                            @can('service-reports.index')
                                <a href="{{route('report.service.revenue')}}" class="nav-link">
                                    <i class="nav-icon fas fa-dollar-sign"></i>
                                    <p> Pendapatan Service </p>
                                </a>
                            @endcan
                        </li>
                    </ul>
                </li>
                @endcanany

            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>
