<!DOCTYPE html>
<html>
<head>
    <title>Laporan Pendapatan Service</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h2 {
            margin: 5px 0;
            font-size: 16px;
        }
        .header p {
            margin: 3px 0;
            font-size: 11px;
        }
        .summary-box {
            margin-bottom: 15px;
            padding: 10px;
            background-color: #f5f5f5;
            border: 1px solid #ddd;
        }
        .summary-box h4 {
            margin: 0 0 10px 0;
            font-size: 12px;
        }
        .summary-row {
            display: table;
            width: 100%;
            margin-bottom: 5px;
        }
        .summary-label {
            display: table-cell;
            width: 60%;
            font-weight: bold;
        }
        .summary-value {
            display: table-cell;
            width: 40%;
            text-align: right;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        table th {
            background-color: #4CAF50;
            color: white;
            padding: 8px;
            text-align: left;
            font-size: 10px;
        }
        table td {
            border: 1px solid #ddd;
            padding: 6px;
            font-size: 10px;
        }
        table tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        h3 {
            margin-top: 20px;
            font-size: 14px;
        }
        .summary-box {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #f5f5f5;
            border: 1px solid #ddd;
        }
        .summary-box p {
            margin: 5px 0;
            font-size: 10px;
            padding: 3px 5px;
        }
        .summary-box p.header {
            font-weight: bold;
            font-size: 11px;
            background-color: #e0e0e0;
            padding: 5px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>LAPORAN PENDAPATAN SERVICE</h2>
        <p>Periode: {{Carbon\Carbon::parse($startDate)->format('d/m/Y')}} - {{Carbon\Carbon::parse($endDate)->format('d/m/Y')}}</p>
        @if($branchName)
        <p>Cabang: {{$branchName}}</p>
        @else
        <p>Semua Cabang</p>
        @endif
    </div>

    <div class="summary-box">
        <p class="header">Ringkasan Pendapatan</p>
        <p>Total Pendapatan: Rp {{number_format($totalRevenue, 0, ',', '.')}}</p>
        <p>Biaya Jasa Service: Rp {{number_format($totalServiceFee, 0, ',', '.')}}</p>
        <p>Biaya Spare Part: Rp {{number_format($totalPartsCost, 0, ',', '.')}}</p>
        <p>Sisa Pembayaran: Rp {{number_format($totalRemaining, 0, ',', '.')}}</p>
        <p>Down Payment (DP): Rp {{number_format($totalDownPayment, 0, ',', '.')}}</p>
        <p>Rata-rata DP: {{$totalRevenue > 0 ? number_format(($totalDownPayment / $totalRevenue) * 100, 1) : 0}}%</p>
        <p>Rata-rata Nilai per Service: Rp {{$services->count() > 0 && $totalRevenue > 0 ? number_format($totalRevenue / $services->count(), 0, ',', '.') : 0}}</p>
    </div>

    <h3>Pendapatan Per Cabang</h3>
    <table>
        <thead>
            <tr>
                <th>Cabang</th>
                <th class="text-center">Jumlah Service</th>
                <th class="text-right">Biaya Jasa</th>
                <th class="text-right">Biaya Spare Part</th>
                <th class="text-right">Total Pendapatan</th>
                <th class="text-center">Persentase</th>
            </tr>
        </thead>
        <tbody>
            @foreach($branchRevenue as $revenue)
            <tr>
                <td><strong>{{$revenue['branch_name']}}</strong></td>
                <td class="text-center">{{$revenue['total_services']}}</td>
                <td class="text-right">Rp {{number_format($revenue['total_service_fee'], 0, ',', '.')}}</td>
                <td class="text-right">Rp {{number_format($revenue['total_parts_cost'], 0, ',', '.')}}</td>
                <td class="text-right">Rp {{number_format($revenue['total_revenue'], 0, ',', '.')}}</td>
                <td class="text-center">{{$totalRevenue > 0 ? number_format(($revenue['total_revenue'] / $totalRevenue) * 100, 1) : 0}}%</td>
            </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr style="font-weight: bold;">
                <td>TOTAL</td>
                <td class="text-center">{{$branchRevenue->sum('total_services')}}</td>
                <td class="text-right">Rp {{number_format($totalServiceFee, 0, ',', '.')}}</td>
                <td class="text-right">Rp {{number_format($totalPartsCost, 0, ',', '.')}}</td>
                <td class="text-right">Rp {{number_format($totalRevenue, 0, ',', '.')}}</td>
                <td class="text-center">100%</td>
            </tr>
        </tfoot>
    </table>

    <h3>Detail Transaksi Service</h3>
    <table>
        <thead>
            <tr>
                <th>No. Service</th>
                <th>Tanggal</th>
                <th>Customer</th>
                <th>Device</th>
                <th>Cabang</th>
                <th class="text-right">Biaya Jasa</th>
                <th class="text-right">Spare Part</th>
                <th class="text-right">Total</th>
                <th class="text-right">DP</th>
                <th class="text-right">Sisa</th>
            </tr>
        </thead>
        <tbody>
            @foreach($services as $service)
            <tr>
                <td>{{$service->service_number}}</td>
                <td>{{$service->service_date->format('d/m/Y')}}</td>
                <td>{{$service->customer->name}}</td>
                <td>{{$service->device_brand}} {{$service->device_model}}</td>
                <td>{{$service->branch->name}}</td>
                <td class="text-right">Rp {{number_format($service->service_fee, 0, ',', '.')}}</td>
                <td class="text-right">Rp {{number_format($service->parts_cost, 0, ',', '.')}}</td>
                <td class="text-right">Rp {{number_format($service->total_cost, 0, ',', '.')}}</td>
                <td class="text-right">Rp {{number_format($service->down_payment, 0, ',', '.')}}</td>
                <td class="text-right">Rp {{number_format($service->remaining_payment, 0, ',', '.')}}</td>
            </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr style="font-weight: bold;">
                <td colspan="5" class="text-right">TOTAL:</td>
                <td class="text-right">Rp {{number_format($totalServiceFee, 0, ',', '.')}}</td>
                <td class="text-right">Rp {{number_format($totalPartsCost, 0, ',', '.')}}</td>
                <td class="text-right">Rp {{number_format($totalRevenue, 0, ',', '.')}}</td>
                <td class="text-right">Rp {{number_format($totalDownPayment, 0, ',', '.')}}</td>
                <td class="text-right">Rp {{number_format($totalRemaining, 0, ',', '.')}}</td>
            </tr>
        </tfoot>
    </table>

    <div style="margin-top: 30px; font-size: 9px; color: #666;">
        <p>Dicetak pada: {{now()->format('d/m/Y H:i:s')}}</p>
    </div>
</body>
</html>
