<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Faktur Pembelian - {{$purchase->purchase_number}}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        .header h2 {
            margin: 5px 0;
            font-size: 20px;
            font-weight: bold;
        }
        .header p {
            margin: 3px 0;
            font-size: 10px;
        }
        .title {
            text-align: center;
            font-size: 16px;
            font-weight: bold;
            margin: 15px 0;
            text-decoration: underline;
        }
        .info-section {
            margin-bottom: 20px;
        }
        .info-row {
            margin-bottom: 5px;
        }
        .info-left {
            width: 50%;
            float: left;
        }
        .info-right {
            width: 50%;
            float: right;
        }
        .clear {
            clear: both;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        table.bordered {
            border: 1px solid #000;
        }
        table.bordered th,
        table.bordered td {
            border: 1px solid #000;
            padding: 5px 8px;
        }
        table.bordered th {
            background-color: #e0e0e0;
            font-weight: bold;
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .font-bold {
            font-weight: bold;
        }
        .summary-table {
            margin-top: 20px;
            width: 50%;
            float: right;
        }
        .summary-table td {
            padding: 5px 10px;
        }
        .total-row {
            background-color: #e0e0e0;
            font-weight: bold;
            font-size: 12px;
        }
        .signature-section {
            margin-top: 100px;
            clear: both;
        }
        .signature-box {
            width: 45%;
            text-align: center;
        }
        .signature-left {
            float: left;
        }
        .signature-right {
            float: right;
        }
        .signature-line {
            margin-top: 80px;
            border-top: 1px solid #000;
            padding-top: 5px;
        }
    </style>
</head>
<body>
    @php
        $logoPath = public_path('logo/logo-umi.png');
        $logoExists = file_exists($logoPath);
    @endphp

    <div class="header">
        <div style="
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center;
            width: 100%;
            white-space: nowrap;
        ">
            @if($logoExists)
                <img src="{{ $logoPath }}"
                    style="
                        height:50px;
                        width:50px;
                        display:inline-block !important;
                        vertical-align: middle;
                        margin-right:10px;
                    ">
            @endif

            <span style="
                font-size:24px;
                font-weight:bold;
                display:inline-block;
                vertical-align: middle;
            ">
                UMI CELL
            </span>
        </div>

        <p>Jl. Raya Semarang-Boja, Jatisari, Kec. Mijen, Kota Semarang Jawa Tengah 50275</p>
        <p>Telp: 0882005564342</p>
    </div>

    <div class="title">FAKTUR PEMBELIAN</div>

    <div class="info-section">
        <div class="info-left">
            <div class="info-row">
                <strong>Nota:</strong> {{$purchase->purchase_number}}
            </div>
            <div class="info-row">
                <strong>Kasir:</strong> {{$purchase->user->name}}
            </div>
        </div>
        <div class="info-right">
            <div class="info-row">
                <strong>Tanggal:</strong> {{date('d/m/Y', strtotime($purchase->purchase_date))}}
            </div>
            <div class="info-row">
                <strong>Supplier:</strong> {{$purchase->supplier->name}}
            </div>
            <div class="info-row">
                <strong>Alamat:</strong> {{$purchase->supplier->address ?? '-'}}
            </div>
            <div class="info-row">
                <strong>Telp:</strong> {{$purchase->supplier->phone ?? '-'}}
            </div>
            <div class="info-row">
                <strong>Cabang:</strong> {{$purchase->branch->name}}
            </div>
        </div>
        <div class="clear"></div>
    </div>

    <table class="bordered">
        <thead>
            <tr>
                <th style="width: 5%;">No</th>
                <th style="width: 40%;">Nama</th>
                <th style="width: 10%;">Qty</th>
                <th style="width: 10%;">Satuan</th>
                <th style="width: 15%;">Harga</th>
                <th style="width: 20%;">Total</th>
            </tr>
        </thead>
        <tbody>
            @php
                $totalItems = 0;
            @endphp
            @foreach($purchase->purchaseDetails as $index => $detail)
            <tr>
                <td class="text-center">{{$index + 1}}</td>
                <td>{{$detail->product->name}}</td>
                <td class="text-center">{{number_format($detail->quantity, 0, ',', '.')}}</td>
                <td class="text-center">{{$detail->product->unit}}</td>
                <td class="text-right">{{number_format($detail->purchase_price, 0, ',', '.')}}</td>
                <td class="text-right">{{number_format($detail->subtotal, 0, ',', '.')}}</td>
            </tr>
            @php
                $totalItems += $detail->quantity;
            @endphp
            @endforeach
        </tbody>
    </table>

    <div class="summary-table">
        <table>
            <tr>
                <td><strong>Jumlah Item:</strong></td>
                <td class="text-right">{{number_format($totalItems, 0, ',', '.')}} item</td>
            </tr>
            <tr>
                <td><strong>Sub Total:</strong></td>
                <td class="text-right">Rp {{number_format($purchase->total_amount, 0, ',', '.')}}</td>
            </tr>
            <tr class="total-row">
                <td><strong>TOTAL AKHIR:</strong></td>
                <td class="text-right"><strong>Rp {{number_format($purchase->total_amount, 0, ',', '.')}}</strong></td>
            </tr>
        </table>
    </div>

    @if($purchase->notes)
    <div style="margin-top: 20px; clear: both;">
        <strong>Catatan:</strong> {{$purchase->notes}}
    </div>
    @endif

    <div class="signature-section">
        <div class="signature-box signature-left">
            <div>Hormat Kami,</div>
            <div class="signature-line">
                ({{$purchase->user->name}})
            </div>
        </div>
        <div class="signature-box signature-right">
            <div>Penerima,</div>
            <div class="signature-line">
                (................................)
            </div>
        </div>
        <div class="clear"></div>
    </div>

    <p style="margin-top: 50px; font-size: 9px; text-align: right; clear: both;">
        Dicetak pada: {{date('d M Y H:i')}}
    </p>
</body>
</html>
