@section('heading', 'Detail Pembelian')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Detail Pembelian</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{route('purchase')}}">Pembelian</a></li>
                    <li class="breadcrumb-item active">Detail</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Detail Produk</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>Produk</th>
                                    <th style="width: 15%;">Qty</th>
                                    <th style="width: 20%;">Harga</th>
                                    <th style="width: 20%;">Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($purchase->purchaseDetails as $index => $detail)
                                <tr>
                                    <td>{{$index + 1}}</td>
                                    <td>{{$detail->product->name}}</td>
                                    <td>{{number_format($detail->quantity, 0, ',', '.')}} {{$detail->product->unit}}</td>
                                    <td class="text-right">Rp {{number_format($detail->purchase_price, 0, ',', '.')}}</td>
                                    <td class="text-right">Rp {{number_format($detail->subtotal, 0, ',', '.')}}</td>
                                </tr>
                                @endforeach
                                <tr>
                                    <th colspan="4" class="text-right">Total</th>
                                    <th class="text-right">Rp {{number_format($purchase->total_amount, 0, ',', '.')}}</th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Informasi Pembelian</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <th style="width: 40%;">No. Pembelian</th>
                                <td>{{$purchase->purchase_number}}</td>
                            </tr>
                            <tr>
                                <th>Supplier</th>
                                <td>{{$purchase->supplier->name}}</td>
                            </tr>
                            <tr>
                                <th>Cabang</th>
                                <td>{{$purchase->branch->name}}</td>
                            </tr>
                            <tr>
                                <th>Tanggal</th>
                                <td>{{TanggalID($purchase->purchase_date)}}</td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    @if($purchase->status == 'pending')
                                    <span class="badge badge-warning">Pending</span>
                                    @elseif($purchase->status == 'completed')
                                    <span class="badge badge-success">Selesai</span>
                                    @else
                                    <span class="badge badge-danger">Batal</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>User</th>
                                <td>{{$purchase->user->name}}</td>
                            </tr>
                            @if($purchase->notes)
                            <tr>
                                <th>Catatan</th>
                                <td>{{$purchase->notes}}</td>
                            </tr>
                            @endif
                            <tr>
                                <th>Dibuat</th>
                                <td>{{TanggalID($purchase->created_at)}}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="card-footer">
                        <a href="{{route('purchase')}}" class="btn btn-secondary btn-block">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <a href="{{route('purchase.invoice-pdf', $purchase->id)}}" class="btn btn-success btn-block" target="_blank">
                            <i class="fas fa-print"></i> Cetak Faktur
                        </a>
                        @can('purchases.edit')
                        @if($purchase->status == 'pending')
                        <a href="{{route('purchase.edit', $purchase->id)}}" class="btn btn-primary btn-block">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        @endif
                        @endcan
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
