<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Daftar Item</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 9px;
            margin: 10px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        .header h2 {
            margin: 5px 0;
            font-size: 16px;
        }
        .header p {
            margin: 3px 0;
            font-size: 10px;
        }
        table.items {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        table.items thead {
            background-color: #f0f0f0;
        }
        table.items th,
        table.items td {
            border: 1px solid #000;
            padding: 4px;
            font-size: 8px;
        }
        table.items th {
            font-weight: bold;
            text-align: center;
        }
        .text-center {
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
    </style>
</head>
<body>
    <?php
        $logoPath = public_path('logo/logo-umi.png');
        $logoExists = file_exists($logoPath);
    ?>

    <div class="header">
        <div style="
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center;
            width: 100%;
            white-space: nowrap;
        ">
            <?php if($logoExists): ?>
                <img src="<?php echo e($logoPath); ?>"
                    style="
                        height:50px;
                        width:50px;
                        display:inline-block !important;
                        vertical-align: middle;
                        margin-right:10px;
                    ">
            <?php endif; ?>

            <span style="
                font-size:24px;
                font-weight:bold;
                display:inline-block;
                vertical-align: middle;
            ">
                UMI CELL
            </span>
        </div>

        <p>Jl. Raya Semarang-Boja, Jatisari, Kec. Mijen, Kota Semarang Jawa Tengah 50275</p>
        <p>Telp: 0882005564342</p>
    </div>

    <h3 style="text-align: center; margin-bottom: 5px;">DAFTAR ITEM</h3>
    <p style="text-align: center; margin-top: 0;">
        Semua Item<br>
        Departemen: <?php echo e($branch ? $branch->name : 'Semua Cabang'); ?>

    </p>

    <table class="items">
        <thead>
            <tr>
                <th style="width: 50px;">Kode</th>
                <th style="width: 120px;">Nama Produk</th>
                <th style="width: 70px;">Kategori</th>
                <th style="width: 70px;">Merek</th>
                <th style="width: 60px;">Total Stok</th>
                <th style="width: 50px;">Stok Min</th>
                <th style="width: 70px;">Harga Beli</th>
                <th style="width: 70px;">Harga Jual</th>
                <th>Deskripsi</th>
                <th style="width: 90px;">Aset (h.Beli*Qty)</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $totalAsset = 0;
            ?>
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $totalAsset += $product->asset;
                ?>
                <tr>
                    <td class="text-center">B-<?php echo e(str_pad($product->id, 4, '0', STR_PAD_LEFT)); ?></td>
                    <td><?php echo e($product->name); ?></td>
                    <td><?php echo e($product->category->name ?? '-'); ?></td>
                    <td><?php echo e($product->brand->name ?? '-'); ?></td>
                    <td class="text-center"><?php echo e(number_format($product->stock_quantity)); ?> <?php echo e($product->unit); ?></td>
                    <td class="text-center"><?php echo e($product->min_stock ?? 0); ?></td>
                    <td class="text-right"><?php echo e(number_format($product->purchase_price, 0, ',', '.')); ?></td>
                    <td class="text-right"><?php echo e(number_format($product->selling_price, 0, ',', '.')); ?></td>
                    <td><?php echo e($product->description ?? '-'); ?></td>
                    <td class="text-right"><?php echo e(number_format($product->asset, 0, ',', '.')); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr style="font-weight: bold; background-color: #f0f0f0;">
                <td colspan="9" class="text-right">TOTAL ASET:</td>
                <td class="text-right">Rp <?php echo e(number_format($totalAsset, 0, ',', '.')); ?></td>
            </tr>
        </tfoot>
    </table>
</body>
</html>
<?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/report/product-list/pdf.blade.php ENDPATH**/ ?>