<?php $__env->startSection('heading', 'Laporan Pendapatan Service'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Laporan Pendapatan Service</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Laporan Service - Pendapatan </li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <!-- Filter Form -->
        <div class="card">
            <div class="card-header bg-primary">
                <h3 class="card-title">Filter Laporan</h3>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('report.service.revenue')); ?>" method="GET">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Tanggal Mulai</label>
                                <input type="date" name="start_date" class="form-control" value="<?php echo e($startDate); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Tanggal Akhir</label>
                                <input type="date" name="end_date" class="form-control" value="<?php echo e($endDate); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Cabang</label>
                                <select name="branch_id" class="form-control">
                                    <option value="">Semua Cabang</option>
                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($branch->id); ?>" <?php echo e($branchId == $branch->id ? 'selected' : ''); ?>>
                                        <?php echo e($branch->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <button type="submit" class="btn btn-primary btn-block">
                                    <i class="fas fa-search"></i> Tampilkan
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <a href="<?php echo e(route('report.service.revenue.export-pdf', ['start_date' => $startDate, 'end_date' => $endDate, 'branch_id' => $branchId])); ?>" class="btn btn-danger" target="_blank">
                            <i class="fas fa-file-pdf"></i> Export PDF
                        </a>
                        <a href="<?php echo e(route('report.service.revenue.export-excel', ['start_date' => $startDate, 'end_date' => $endDate, 'branch_id' => $branchId])); ?>" class="btn btn-success">
                            <i class="fas fa-file-excel"></i> Export Excel
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="row">
            <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3>Rp <?php echo e(number_format($totalRevenue / 1000, 0)); ?>K</h3>
                        <p>Total Pendapatan</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3>Rp <?php echo e(number_format($totalServiceFee / 1000, 0)); ?>K</h3>
                        <p>Biaya Jasa Service</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-wrench"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3>Rp <?php echo e(number_format($totalPartsCost / 1000, 0)); ?>K</h3>
                        <p>Biaya Spare Part</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-cog"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-danger">
                    <div class="inner">
                        <h3>Rp <?php echo e(number_format($totalRemaining / 1000, 0)); ?>K</h3>
                        <p>Sisa Pembayaran</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-exclamation-circle"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-4">
                <div class="info-box bg-primary">
                    <span class="info-box-icon"><i class="fas fa-hand-holding-usd"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Down Payment (DP)</span>
                        <span class="info-box-number">Rp <?php echo e(number_format($totalDownPayment, 0, ',', '.')); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box bg-success">
                    <span class="info-box-icon"><i class="fas fa-percentage"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Rata-rata DP</span>
                        <span class="info-box-number">
                            <?php echo e($totalRevenue > 0 ? number_format(($totalDownPayment / $totalRevenue) * 100, 1) : 0); ?>%
                        </span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box bg-info">
                    <span class="info-box-icon"><i class="fas fa-calculator"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Rata-rata Nilai per Service</span>
                        <span class="info-box-number">
                            Rp <?php echo e($services->count() > 0 && $totalRevenue > 0 ? number_format($totalRevenue / $services->count(), 0, ',', '.') : 0); ?>

                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Chart Tren Pendapatan -->
        <div class="card">
            <div class="card-header bg-info">
                <h3 class="card-title">Tren Pendapatan Harian</h3>
            </div>
            <div class="card-body">
                <canvas id="revenueChart" height="80"></canvas>
            </div>
        </div>

        <!-- Pendapatan per Cabang -->
        <div class="card">
            <div class="card-header bg-success">
                <h3 class="card-title">Pendapatan Per Cabang</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Cabang</th>
                            <th class="text-center">Jumlah Service</th>
                            <th class="text-right">Biaya Jasa</th>
                            <th class="text-right">Biaya Spare Part</th>
                            <th class="text-right">Total Pendapatan</th>
                            <th class="text-center">Persentase</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $branchRevenue; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $revenue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><strong><?php echo e($revenue['branch_name']); ?></strong></td>
                            <td class="text-center"><?php echo e($revenue['total_services']); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($revenue['total_service_fee'], 0, ',', '.')); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($revenue['total_parts_cost'], 0, ',', '.')); ?></td>
                            <td class="text-right"><strong>Rp <?php echo e(number_format($revenue['total_revenue'], 0, ',', '.')); ?></strong></td>
                            <td class="text-center">
                                <span class="badge badge-primary">
                                    <?php echo e($totalRevenue > 0 ? number_format(($revenue['total_revenue'] / $totalRevenue) * 100, 1) : 0); ?>%
                                </span>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr class="font-weight-bold bg-light">
                            <td>TOTAL</td>
                            <td class="text-center"><?php echo e($branchRevenue->sum('total_services')); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($totalServiceFee, 0, ',', '.')); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($totalPartsCost, 0, ',', '.')); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($totalRevenue, 0, ',', '.')); ?></td>
                            <td class="text-center">100%</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Detail Transaksi -->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title">Detail Transaksi Service</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped table-sm" id="serviceTable">
                    <thead>
                        <tr>
                            <th>No. Service</th>
                            <th>Tanggal</th>
                            <th>Customer</th>
                            <th>Device</th>
                            <th>Cabang</th>
                            <th class="text-right">Biaya Jasa</th>
                            <th class="text-right">Biaya Spare Part</th>
                            <th class="text-right">Total</th>
                            <th class="text-right">DP</th>
                            <th class="text-right">Sisa</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><a href="<?php echo e(route('services.show', $service->id)); ?>"><?php echo e($service->service_number); ?></a></td>
                            <td><?php echo e($service->service_date->format('d/m/Y')); ?></td>
                            <td><?php echo e($service->customer->name); ?></td>
                            <td><?php echo e($service->device_brand); ?> <?php echo e($service->device_model); ?></td>
                            <td><?php echo e($service->branch->name); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($service->service_fee, 0, ',', '.')); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($service->parts_cost, 0, ',', '.')); ?></td>
                            <td class="text-right"><strong>Rp <?php echo e(number_format($service->total_cost, 0, ',', '.')); ?></strong></td>
                            <td class="text-right">Rp <?php echo e(number_format($service->down_payment, 0, ',', '.')); ?></td>
                            <td class="text-right">
                                <span class="<?php echo e($service->remaining_payment > 0 ? 'text-danger' : 'text-success'); ?>">
                                    Rp <?php echo e(number_format($service->remaining_payment, 0, ',', '.')); ?>

                                </span>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr class="font-weight-bold">
                            <td colspan="5" class="text-right">TOTAL:</td>
                            <td class="text-right">Rp <?php echo e(number_format($totalServiceFee, 0, ',', '.')); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($totalPartsCost, 0, ',', '.')); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($totalRevenue, 0, ',', '.')); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($totalDownPayment, 0, ',', '.')); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($totalRemaining, 0, ',', '.')); ?></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
<script>
$(document).ready(function() {
    $('#serviceTable').DataTable({
        "responsive": true,
        "lengthChange": true,
        "autoWidth": false,
        "pageLength": 25,
        "order": [[1, 'desc']]
    });

    // Line Chart Revenue
    const ctx = document.getElementById('revenueChart').getContext('2d');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode($chartLabels, 15, 512) ?>,
            datasets: [{
                label: 'Pendapatan Harian',
                data: <?php echo json_encode($chartData, 15, 512) ?>,
                borderColor: '#4CAF50',
                backgroundColor: 'rgba(76, 175, 80, 0.1)',
                tension: 0.3,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return 'Rp ' + value.toLocaleString('id-ID');
                        }
                    }
                }
            },
            plugins: {
                legend: {
                    display: true,
                    position: 'top'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return 'Pendapatan: Rp ' + context.parsed.y.toLocaleString('id-ID');
                        }
                    }
                }
            }
        }
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/report/service/revenue.blade.php ENDPATH**/ ?>