<?php $__env->startSection('heading', 'Produk'); ?>



<?php $__env->startSection('content'); ?>


<style>
    .warning {
        background-color: yellow;
    }

</style>


<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1> Produk </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('home')); ?>">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active"> Produk </li>
                </ol>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"> <b>Produk</b> </h3>
                        <div class="card-tools">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.create')): ?>
                                <button type="button" class="btn btn-primary text-white btn-sm m-1" title="Import Excel" data-toggle="modal" data-target="#modal-import">
                                    <i class="fas fa-file-excel"></i> Import Excel
                                </button>
                                <button type="button" class="btn btn-success text-white btn-sm m-1" title="Tambah" data-toggle="modal" data-target="#modal-tambah">
                                    <i class="fas fa-plus-circle"></i> Tambah
                                </button>
                                <div class="modal fade" id="modal-tambah">
                                    <div class="modal-dialog modal-xl">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title"> Tambah Produk </h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form action="<?php echo e(route('product.save')); ?>" method="POST" enctype="multipart/form-data" id="form-tambah-product" novalidate>
                                                <?php echo csrf_field(); ?>
                                                <div class="modal-body">
                                                    <!-- Nav Tabs -->
                                                    <ul class="nav nav-tabs" id="productTab" role="tablist">
                                                        <li class="nav-item">
                                                            <a class="nav-link active" id="data-tab" data-toggle="tab" href="#data-produk" role="tab">
                                                                <i class="fas fa-box"></i> Data Produk <span class="text-danger">*</span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" id="stok-tab" data-toggle="tab" href="#stok-produk" role="tab">
                                                                <i class="fas fa-warehouse"></i> Stok per Cabang <span class="text-danger">*</span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" id="harga-tab" data-toggle="tab" href="#harga-produk" role="tab">
                                                                <i class="fas fa-tags"></i> Harga per Cabang <span class="text-danger">*</span>
                                                            </a>
                                                        </li>
                                                    </ul>

                                                    <!-- Tab Content -->
                                                    <div class="tab-content" id="productTabContent" style="padding-top: 15px;">
                                                        <!-- Tab 1: Data Produk -->
                                                        <div class="tab-pane fade show active" id="data-produk" role="tabpanel">
                                                            <div class="form-group">
                                                                <label> Produk <span class="text-danger">*</span></label>
                                                                <input type="text" name="name" value="<?php echo e(old('name')); ?>" placeholder="Masukkan Produk" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <div class="invalid-feedback" style="display: block">
                                                                    <?php echo e($message); ?>

                                                                </div>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                            <div class="form-group">
                                                                <label> Kategori <span class="text-danger">*</span></label>
                                                                <select name="category_id" class="form-control select2 <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                                    <option value="">Pilih Kategori</option>
                                                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($category->id); ?>" <?php echo e(old('category_id') == $category->id ? 'selected' : ''); ?>>
                                                                            <?php echo e($category->name); ?>

                                                                        </option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                                <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <div class="invalid-feedback" style="display: block">
                                                                    <?php echo e($message); ?>

                                                                </div>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                            <div class="form-group">
                                                                <label> Merek <span class="text-danger">*</span></label>
                                                                <select name="brand_id" class="form-control select2 <?php $__errorArgs = ['brand_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                                    <option value="">Pilih Merek</option>
                                                                    <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($brand->id); ?>" <?php echo e(old('brand_id') == $brand->id ? 'selected' : ''); ?>>
                                                                            <?php echo e($brand->name); ?>

                                                                        </option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                                <?php $__errorArgs = ['brand_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <div class="invalid-feedback" style="display: block">
                                                                    <?php echo e($message); ?>

                                                                </div>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                            <div class="form-group">
                                                                <label> Satuan Unit <span class="text-danger">*</span></label>
                                                                <input type="text" name="unit" value="<?php echo e(old('unit')); ?>" placeholder="Contoh: pcs, box, unit" class="form-control <?php $__errorArgs = ['unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                                <?php $__errorArgs = ['unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <div class="invalid-feedback" style="display: block">
                                                                    <?php echo e($message); ?>

                                                                </div>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                            <div class="form-group">
                                                                <label> Minimal Stok <span class="text-danger">*</span></label>
                                                                <input type="number" name="min_stock" value="<?php echo e(old('min_stock')); ?>" placeholder="Masukkan minimal stok" class="form-control <?php $__errorArgs = ['min_stock'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                                <?php $__errorArgs = ['min_stock'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <div class="invalid-feedback" style="display: block">
                                                                    <?php echo e($message); ?>

                                                                </div>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                            <div class="form-group">
                                                                <label> Deskripsi </label>
                                                                <textarea name="description" placeholder="Masukkan Deskripsi" class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('description')); ?></textarea>
                                                                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <div class="invalid-feedback" style="display: block">
                                                                    <?php echo e($message); ?>

                                                                </div>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </div>

                                                        <!-- Tab 2: Stok per Cabang -->
                                                        <div class="tab-pane fade" id="stok-produk" role="tabpanel">
                                                            <div class="alert alert-info">
                                                                <i class="icon fas fa-info-circle"></i>
                                                                Pilih cabang dan atur stok awal produk
                                                            </div>
                                                            <button type="button" class="btn btn-sm btn-success mb-3" id="btn-add-stock">
                                                                <i class="fas fa-plus"></i> Tambah Stok Cabang
                                                            </button>
                                                            <div id="stok-container"></div>
                                                        </div>

                                                        <!-- Tab 3: Harga per Cabang -->
                                                        <div class="tab-pane fade" id="harga-produk" role="tabpanel">
                                                            <div class="alert alert-info">
                                                                <i class="icon fas fa-info-circle"></i>
                                                                Pilih cabang dan atur harga beli & jual
                                                            </div>
                                                            <button type="button" class="btn btn-sm btn-success mb-3" id="btn-add-price">
                                                                <i class="fas fa-plus"></i> Tambah Harga Cabang
                                                            </button>
                                                            <div id="harga-container"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-primary btn-submit">
                                                        <i class="fa fa-paper-plane"></i> Simpan Semua
                                                    </button>
                                                    <button class="btn btn-warning text-white btn-reset" type="reset">
                                                        <i class="fa fa-redo"></i> Reset
                                                    </button>
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">
                                                        <i class="fas fa-undo"></i> Kembali
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                             <?php endif; ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Search Filter -->
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-search"></i> Pencarian Produk</label>
                                    <input type="text" id="searchProduct" class="form-control" placeholder="Cari berdasarkan ID atau Nama Produk...">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><i class="fas fa-filter"></i> Filter Kategori</label>
                                    <select id="filterCategory" class="form-control">
                                        <option value="">Semua Kategori</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($category->name); ?>"><?php echo e($category->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><i class="fas fa-filter"></i> Filter Merek</label>
                                    <select id="filterBrand" class="form-control">
                                        <option value="">Semua Merek</option>
                                        <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($brand->name); ?>"><?php echo e($brand->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th scope="col" style="text-align: center;width: 6%">NO.</th>
                                    <th scope="col">Produk</th>
                                    <th scope="col">Kategori</th>
                                    <th scope="col">Merek</th>
                                    <th scope="col">Barcode</th>
                                    <th scope="col">Unit</th>
                                    <th scope="col">Min Stock</th>
                                    <th scope="col">Deskripsi</th>
                                    <th scope="col" style="width: 15%;text-align: center">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $nomer = 1; ?>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $no => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th><?php echo e($nomer++); ?></th>
                                    <td><?php echo e($product->name); ?></td>
                                    <td><?php echo e($product->category->name ?? 'N/A'); ?></td>
                                    <td><?php echo e($product->brand->name ?? 'N/A'); ?></td>
                                    <td style="text-align: center;">
                                        <?php echo generateQrCode($product->barcode, 100); ?>

                                    </td>
                                    <td><?php echo e($product->unit); ?></td>
                                    <td><?php echo e($product->min_stock); ?></td>
                                    <td><?php echo e($product->description); ?></td>
                                    <td class="text-left">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.index')): ?>
                                            <a href="<?php echo e(route('product.show', $product->id)); ?>" class="btn btn-info btn-sm m-1" title="Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.edit')): ?>
                                            <button type="button" class="btn btn-warning text-white btn-sm m-1" title="Edit" data-toggle="modal" data-target="#modal-edit-<?php echo e($product->id); ?>">
                                                <i class="fas fa-pencil-alt"></i>
                                            </button>
                                            <div class="modal fade" id="modal-edit-<?php echo e($product->id); ?>">
                                                <div class="modal-dialog modal-xl">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"> Edit Produk: <?php echo e($product->name); ?> </h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form action="<?php echo e(route('product.update', $product->id)); ?>" method="POST" enctype="multipart/form-data" class="form-edit-product" id="form-edit-product-<?php echo e($product->id); ?>" novalidate data-product-id="<?php echo e($product->id); ?>">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <div class="modal-body">
                                                                <!-- Nav Tabs -->
                                                                <ul class="nav nav-tabs" id="editProductTab<?php echo e($product->id); ?>" role="tablist">
                                                                    <li class="nav-item">
                                                                        <a class="nav-link active" id="edit-data-tab-<?php echo e($product->id); ?>" data-toggle="tab" href="#edit-data-produk-<?php echo e($product->id); ?>" role="tab">
                                                                            <i class="fas fa-box"></i> Data Produk
                                                                        </a>
                                                                    </li>
                                                                    <li class="nav-item">
                                                                        <a class="nav-link" id="edit-stok-tab-<?php echo e($product->id); ?>" data-toggle="tab" href="#edit-stok-produk-<?php echo e($product->id); ?>" role="tab">
                                                                            <i class="fas fa-warehouse"></i> Stok per Cabang
                                                                        </a>
                                                                    </li>
                                                                    <li class="nav-item">
                                                                        <a class="nav-link" id="edit-harga-tab-<?php echo e($product->id); ?>" data-toggle="tab" href="#edit-harga-produk-<?php echo e($product->id); ?>" role="tab">
                                                                            <i class="fas fa-tags"></i> Harga per Cabang
                                                                        </a>
                                                                    </li>
                                                                </ul>

                                                                <!-- Tab Content -->
                                                                <div class="tab-content" id="editProductTabContent<?php echo e($product->id); ?>" style="padding-top: 15px;">
                                                                    <!-- Tab 1: Data Produk -->
                                                                    <div class="tab-pane fade show active" id="edit-data-produk-<?php echo e($product->id); ?>" role="tabpanel">
                                                                        <div class="form-group">
                                                                            <label> Produk <span class="text-danger">*</span></label>
                                                                            <input type="text" name="name" value="<?php echo e(old('name', $product->name)); ?>" placeholder="Masukkan Produk" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <div class="invalid-feedback" style="display: block">
                                                                                <?php echo e($message); ?>

                                                                            </div>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label> Kategori <span class="text-danger">*</span></label>
                                                                            <select name="category_id" class="form-control select2-edit <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" data-original-value="<?php echo e($product->category_id); ?>" required>
                                                                                <option value="">Pilih Kategori</option>
                                                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <option value="<?php echo e($category->id); ?>" <?php echo e(old('category_id', $product->category_id) == $category->id ? 'selected' : ''); ?>>
                                                                                        <?php echo e($category->name); ?>

                                                                                    </option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>
                                                                            <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <div class="invalid-feedback" style="display: block">
                                                                                <?php echo e($message); ?>

                                                                            </div>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label> Merek <span class="text-danger">*</span></label>
                                                                            <select name="brand_id" class="form-control select2-edit <?php $__errorArgs = ['brand_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" data-original-value="<?php echo e($product->brand_id); ?>" required>
                                                                                <option value="">Pilih Merek</option>
                                                                                <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <option value="<?php echo e($brand->id); ?>" <?php echo e(old('brand_id', $product->brand_id) == $brand->id ? 'selected' : ''); ?>>
                                                                                        <?php echo e($brand->name); ?>

                                                                                    </option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>
                                                                            <?php $__errorArgs = ['brand_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <div class="invalid-feedback" style="display: block">
                                                                                <?php echo e($message); ?>

                                                                            </div>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label> Satuan Unit <span class="text-danger">*</span></label>
                                                                            <input type="text" name="unit" value="<?php echo e(old('unit', $product->unit)); ?>" placeholder="Contoh: pcs, box, unit" class="form-control <?php $__errorArgs = ['unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                                            <?php $__errorArgs = ['unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <div class="invalid-feedback" style="display: block">
                                                                                <?php echo e($message); ?>

                                                                            </div>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label> Minimal Stok <span class="text-danger">*</span></label>
                                                                            <input type="number" name="min_stock" value="<?php echo e(old('min_stock', $product->min_stock)); ?>" placeholder="Masukkan minimal stok" class="form-control <?php $__errorArgs = ['min_stock'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                                            <?php $__errorArgs = ['min_stock'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <div class="invalid-feedback" style="display: block">
                                                                                <?php echo e($message); ?>

                                                                            </div>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label> Deskripsi </label>
                                                                            <textarea name="description" placeholder="Masukkan Deskripsi" class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('description', $product->description)); ?></textarea>
                                                                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <div class="invalid-feedback" style="display: block">
                                                                                <?php echo e($message); ?>

                                                                            </div>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                        </div>
                                                                    </div>

                                                                    <!-- Tab 2: Stok per Cabang -->
                                                                    <div class="tab-pane fade" id="edit-stok-produk-<?php echo e($product->id); ?>" role="tabpanel">
                                                                        <div class="alert alert-info">
                                                                            <i class="icon fas fa-info-circle"></i>
                                                                            Kelola stok produk per cabang. Anda dapat menambah cabang baru atau mengubah stok yang sudah ada.
                                                                        </div>
                                                                        <button type="button" class="btn btn-sm btn-success mb-3 btn-add-stock-edit" data-product-id="<?php echo e($product->id); ?>">
                                                                            <i class="fas fa-plus"></i> Tambah Stok Cabang
                                                                        </button>
                                                                        <div id="stok-container-<?php echo e($product->id); ?>">
                                                                            <?php $__currentLoopData = $product->productStocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <div class="card mb-3" id="stock-edit-<?php echo e($product->id); ?>-<?php echo e($index); ?>" data-original-stock-id="<?php echo e($stock->id); ?>">
                                                                                <div class="card-body">
                                                                                    <div class="row">
                                                                                        <div class="col-md-6">
                                                                                            <div class="form-group">
                                                                                                <label>Cabang <span class="text-danger">*</span></label>
                                                                                                <select name="stocks[<?php echo e($index); ?>][branch_id]" class="form-control stock-branch-select-edit" data-stock-id="stock-edit-<?php echo e($product->id); ?>-<?php echo e($index); ?>" data-product-id="<?php echo e($product->id); ?>" required>
                                                                                                    <option value="">Pilih Cabang</option>
                                                                                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                                        <option value="<?php echo e($branch->id); ?>" <?php echo e($stock->branch_id == $branch->id ? 'selected' : ''); ?>>
                                                                                                            <?php echo e($branch->name); ?>

                                                                                                        </option>
                                                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                                </select>
                                                                                                <input type="hidden" name="stocks[<?php echo e($index); ?>][id]" value="<?php echo e($stock->id); ?>">
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="col-md-5">
                                                                                            <div class="form-group">
                                                                                                <label>Jumlah Stok <span class="text-danger">*</span></label>
                                                                                                <input type="number" name="stocks[<?php echo e($index); ?>][quantity]" value="<?php echo e($stock->quantity); ?>"
                                                                                                    class="form-control" placeholder="0" min="0" required>
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="col-md-1">
                                                                                            <label>&nbsp;</label>
                                                                                            <button type="button" class="btn btn-danger btn-block btn-remove-stock-edit" data-stock-id="stock-edit-<?php echo e($product->id); ?>-<?php echo e($index); ?>" data-product-id="<?php echo e($product->id); ?>">
                                                                                                <i class="fas fa-trash"></i>
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </div>
                                                                    </div>

                                                                    <!-- Tab 3: Harga per Cabang -->
                                                                    <div class="tab-pane fade" id="edit-harga-produk-<?php echo e($product->id); ?>" role="tabpanel">
                                                                        <div class="alert alert-info">
                                                                            <i class="icon fas fa-info-circle"></i>
                                                                            Kelola harga produk per cabang. Anda dapat menambah cabang baru atau mengubah harga yang sudah ada.
                                                                        </div>
                                                                        <button type="button" class="btn btn-sm btn-success mb-3 btn-add-price-edit" data-product-id="<?php echo e($product->id); ?>">
                                                                            <i class="fas fa-plus"></i> Tambah Harga Cabang
                                                                        </button>
                                                                        <div id="harga-container-<?php echo e($product->id); ?>">
                                                                            <?php $__currentLoopData = $product->productPrices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <div class="card mb-3" id="price-edit-<?php echo e($product->id); ?>-<?php echo e($index); ?>" data-original-price-id="<?php echo e($price->id); ?>">
                                                                                <div class="card-body">
                                                                                    <div class="row">
                                                                                        <div class="col-md-4">
                                                                                            <div class="form-group">
                                                                                                <label>Cabang <span class="text-danger">*</span></label>
                                                                                                <select name="prices[<?php echo e($index); ?>][branch_id]" class="form-control price-branch-select-edit" data-price-id="price-edit-<?php echo e($product->id); ?>-<?php echo e($index); ?>" data-product-id="<?php echo e($product->id); ?>" required>
                                                                                                    <option value="">Pilih Cabang</option>
                                                                                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                                        <option value="<?php echo e($branch->id); ?>" <?php echo e($price->branch_id == $branch->id ? 'selected' : ''); ?>>
                                                                                                            <?php echo e($branch->name); ?>

                                                                                                        </option>
                                                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                                </select>
                                                                                                <input type="hidden" name="prices[<?php echo e($index); ?>][id]" value="<?php echo e($price->id); ?>">
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="col-md-3">
                                                                                            <div class="form-group">
                                                                                                <label>Harga Beli <span class="text-danger">*</span></label>
                                                                                                <input type="number" name="prices[<?php echo e($index); ?>][purchase_price]" value="<?php echo e($price->purchase_price); ?>"
                                                                                                    class="form-control" placeholder="0" min="0" step="0.01" required>
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="col-md-3">
                                                                                            <div class="form-group">
                                                                                                <label>Harga Jual <span class="text-danger">*</span></label>
                                                                                                <input type="number" name="prices[<?php echo e($index); ?>][selling_price]" value="<?php echo e($price->selling_price); ?>"
                                                                                                    class="form-control" placeholder="0" min="0" step="0.01" required>
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="col-md-2">
                                                                                            <label>&nbsp;</label>
                                                                                            <button type="button" class="btn btn-danger btn-block btn-remove-price-edit" data-price-id="price-edit-<?php echo e($product->id); ?>-<?php echo e($index); ?>" data-product-id="<?php echo e($product->id); ?>">
                                                                                                <i class="fas fa-trash"></i>
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit" class="btn btn-primary btn-submit-edit">
                                                                    <i class="fa fa-paper-plane"></i> Simpan Semua
                                                                </button>
                                                                <button class="btn btn-warning text-white btn-reset" type="reset">
                                                                    <i class="fa fa-redo"></i> Reset
                                                                </button>
                                                                <button type="button" class="btn btn-default" data-dismiss="modal">
                                                                    <i class="fas fa-undo"></i> Kembali
                                                                </button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.delete')): ?>
                                            <form action="<?php echo e(route('product.delete', $product->id)); ?>" method="POST" style="display:inline;" class="delete-form-<?php echo e($product->id); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="button" class="btn btn-danger btn-sm delete m-1" data-id="<?php echo e($product->id); ?>" data-name="<?php echo e($product->name); ?>" title="Hapus">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /.content -->

<!-- Modal Import Excel -->
<div class="modal fade" id="modal-import">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Import Produk dari Excel</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(route('product.import-excel')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        <strong>Petunjuk:</strong>
                        <ol class="mb-0 pl-3">
                            <li>Download template Excel terlebih dahulu</li>
                            <li>Isi data produk sesuai format template</li>
                            <li>Upload file Excel yang sudah diisi</li>
                            <li>Pastikan Kategori, Merek, dan Cabang sudah ada di sistem</li>
                        </ol>
                    </div>

                    <div class="form-group">
                        <label>Download Template</label>
                        <div>
                            <a href="<?php echo e(route('product.download-template')); ?>" class="btn btn-success btn-sm" target="_blank">
                                <i class="fas fa-download"></i> Download Template Excel
                            </a>
                        </div>
                        <small class="text-muted">Template berisi format dan contoh data yang benar</small>
                    </div>

                    <hr>

                    <div class="form-group">
                        <label for="excel_file">Upload File Excel <span class="text-danger">*</span></label>
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="excel_file" name="excel_file" accept=".xlsx,.xls" required>
                            <label class="custom-file-label" for="excel_file">Pilih file...</label>
                        </div>
                        <small class="text-muted">Format: .xlsx atau .xls (Maksimal 2MB)</small>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload"></i> Upload & Import
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Data cabang dari controller
    var branches = <?php echo json_encode($branches, 15, 512) ?>;
    var selectedStockBranches = []; // Track cabang yang sudah dipilih untuk stok
    var selectedPriceBranches = []; // Track cabang yang sudah dipilih untuk harga
    var stockCounter = 0;
    var priceCounter = 0;

    // Disable tombol submit saat modal pertama kali dibuka
    $('#modal-tambah').on('shown.bs.modal', function () {
        $('#form-tambah-product .btn-submit').prop('disabled', true);
    });

    // Handle tab change - enable submit hanya di tab Harga per Cabang (Form Tambah)
    $('#productTab a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        var targetTab = $(e.target).attr('href');

        if (targetTab === '#harga-produk') {
            // Tab Harga per Cabang aktif - enable tombol submit
            $('#form-tambah-product .btn-submit').prop('disabled', false);
        } else {
            // Tab lain aktif - disable tombol submit
            $('#form-tambah-product .btn-submit').prop('disabled', true);
        }
    });

    // Handle tab change untuk Form Edit - tombol selalu enabled
    $(document).on('shown.bs.tab', 'a[id^="edit-"][data-toggle="tab"]', function (e) {
        var targetTab = $(e.target).attr('href');
        var productId = targetTab.match(/\d+/); // Extract product ID from href

        // Untuk form edit, tombol submit selalu enabled (tidak ada restriction tab)
        if (productId) {
            $('#form-edit-product-' + productId[0] + ' .btn-submit-edit').prop('disabled', false);
        }
    });

    // Inisialisasi Select2 untuk form edit (harus diinisialisasi saat modal dibuka)
    $('[id^="modal-edit-"]').on('shown.bs.modal', function () {
        $(this).find('.select2-edit').select2({
            dropdownParent: $(this).find('.modal-content')
        });

        // Enable tombol submit untuk form edit (tidak ada restriction seperti form tambah)
        $(this).find('.btn-submit-edit').prop('disabled', false);
    });

    // Validasi sebelum submit form
    $('#form-tambah-product').on('submit', function(e) {
        // Validasi Tab Data Produk
        var productName = $('#form-tambah-product input[name="name"]').val();
        var categoryId = $('#form-tambah-product select[name="category_id"]').val();
        var brandId = $('#form-tambah-product select[name="brand_id"]').val();
        var unit = $('#form-tambah-product input[name="unit"]').val();
        var minStock = $('#form-tambah-product input[name="min_stock"]').val();

        if (!productName || productName.trim() === '') {
            e.preventDefault();
            alert('Nama Produk wajib diisi!');
            $('#data-tab').tab('show');
            $('#form-tambah-product input[name="name"]').focus();
            return false;
        }

        if (!categoryId || categoryId === '') {
            e.preventDefault();
            alert('Kategori wajib dipilih!');
            $('#data-tab').tab('show');
            $('#form-tambah-product select[name="category_id"]').focus();
            return false;
        }

        if (!brandId || brandId === '') {
            e.preventDefault();
            alert('Merek wajib dipilih!');
            $('#data-tab').tab('show');
            $('#form-tambah-product select[name="brand_id"]').focus();
            return false;
        }

        if (!unit || unit.trim() === '') {
            e.preventDefault();
            alert('Satuan Unit wajib diisi!');
            $('#data-tab').tab('show');
            $('#form-tambah-product input[name="unit"]').focus();
            return false;
        }

        if (!minStock || minStock.trim() === '') {
            e.preventDefault();
            alert('Minimal Stok wajib diisi!');
            $('#data-tab').tab('show');
            $('#form-tambah-product input[name="min_stock"]').focus();
            return false;
        }

        // Validasi Tab Stok per Cabang
        var stockCount = $('#stok-container .card').length;

        if (stockCount === 0) {
            e.preventDefault();
            alert('Minimal harus menambahkan 1 stok cabang!');
            $('#stok-tab').tab('show');
            return false;
        }

        // Validasi bahwa setiap stok memiliki cabang yang dipilih
        var stockValid = true;
        $('#stok-container .stock-branch-select').each(function() {
            if (!$(this).val()) {
                stockValid = false;
                return false;
            }
        });

        if (!stockValid) {
            e.preventDefault();
            alert('Silakan pilih cabang untuk semua stok yang ditambahkan!');
            $('#stok-tab').tab('show');
            return false;
        }

        // Validasi Tab Harga per Cabang
        var priceCount = $('#harga-container .card').length;

        if (priceCount === 0) {
            e.preventDefault();
            alert('Minimal harus menambahkan 1 harga cabang!');
            $('#harga-tab').tab('show');
            return false;
        }

        // Validasi bahwa setiap harga memiliki cabang yang dipilih
        var priceValid = true;
        $('#harga-container .price-branch-select').each(function() {
            if (!$(this).val()) {
                priceValid = false;
                return false;
            }
        });

        if (!priceValid) {
            e.preventDefault();
            alert('Silakan pilih cabang untuk semua harga yang ditambahkan!');
            $('#harga-tab').tab('show');
            return false;
        }

        // Validasi: Cabang di stok harus ada di harga, dan sebaliknya
        var stockBranchIds = [];
        var priceBranchIds = [];
        var branchNames = <?php echo json_encode($branches->pluck('name', 'id'), 512) ?>;

        // Ambil semua branch_id dari stok
        $('#stok-container .stock-branch-select').each(function() {
            var branchId = $(this).val();
            if (branchId) {
                stockBranchIds.push(parseInt(branchId));
            }
        });

        // Ambil semua branch_id dari harga
        $('#harga-container .price-branch-select').each(function() {
            var branchId = $(this).val();
            if (branchId) {
                priceBranchIds.push(parseInt(branchId));
            }
        });

        // Cek cabang yang ada di stok tapi tidak ada di harga
        var missingInPrice = stockBranchIds.filter(function(id) {
            return priceBranchIds.indexOf(id) === -1;
        });

        if (missingInPrice.length > 0) {
            e.preventDefault();
            var missingBranchNames = missingInPrice.map(function(id) {
                return branchNames[id];
            }).join(', ');
            alert('Cabang berikut ada di Tab Stok Barang tapi tidak ada di Tab Harga Cabang: ' + missingBranchNames + '.\n\nSilakan tambahkan harga untuk cabang tersebut.');
            $('#harga-tab').tab('show');
            return false;
        }

        // Cek cabang yang ada di harga tapi tidak ada di stok
        var missingInStock = priceBranchIds.filter(function(id) {
            return stockBranchIds.indexOf(id) === -1;
        });

        if (missingInStock.length > 0) {
            e.preventDefault();
            var missingBranchNames = missingInStock.map(function(id) {
                return branchNames[id];
            }).join(', ');
            alert('Cabang berikut ada di Tab Harga Cabang tapi tidak ada di Tab Stok Barang: ' + missingBranchNames + '.\n\nSilakan tambahkan stok untuk cabang tersebut.');
            $('#stok-tab').tab('show');
            return false;
        }

        return true;
    });

    // Handle reset button untuk form tambah
    $('#form-tambah-product .btn-reset').on('click', function(e) {
        // Reset select2 dropdown ke nilai default (kosong)
        $('#form-tambah-product select[name="category_id"]').val('').trigger('change');
        $('#form-tambah-product select[name="brand_id"]').val('').trigger('change');

        // Reset stok dan harga containers
        $('#stok-container').empty();
        $('#harga-container').empty();
        selectedStockBranches = [];
        selectedPriceBranches = [];
        stockCounter = 0;
        priceCounter = 0;
    });

    // Handle reset button untuk form edit
    $('.form-edit-product .btn-reset').on('click', function(e) {
        var form = $(this).closest('form');

        // Reset select2 dropdown ke nilai original dari database
        var categorySelect = form.find('select[name="category_id"]');
        var brandSelect = form.find('select[name="brand_id"]');

        var originalCategoryValue = categorySelect.data('original-value');
        var originalBrandValue = brandSelect.data('original-value');

        categorySelect.val(originalCategoryValue).trigger('change');
        brandSelect.val(originalBrandValue).trigger('change');
    });

    // Fungsi untuk mendapatkan available branches untuk stok
    function getAvailableStockBranches() {
        return branches.filter(function(branch) {
            return !selectedStockBranches.includes(branch.id);
        });
    }

    // Fungsi untuk mendapatkan available branches untuk harga
    function getAvailablePriceBranches() {
        return branches.filter(function(branch) {
            return !selectedPriceBranches.includes(branch.id);
        });
    }

    // Handle Tambah Stok Cabang
    $('#btn-add-stock').on('click', function() {
        var availableBranches = getAvailableStockBranches();

        if (availableBranches.length === 0) {
            alert('Semua cabang sudah ditambahkan!');
            return;
        }

        var currentIndex = stockCounter;
        var stockId = 'stock-' + currentIndex;
        stockCounter++;

        var branchOptions = '<option value="">Pilih Cabang</option>';
        availableBranches.forEach(function(branch) {
            branchOptions += '<option value="' + branch.id + '">' + branch.name + '</option>';
        });

        var html = `
            <div class="card mb-3" id="${stockId}">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Cabang <span class="text-danger">*</span></label>
                                <select name="stocks[${currentIndex}][branch_id]" class="form-control stock-branch-select" data-stock-id="${stockId}" required>
                                    ${branchOptions}
                                </select>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label>Jumlah Stok <span class="text-danger">*</span></label>
                                <input type="number" name="stocks[${currentIndex}][quantity]"
                                    class="form-control" placeholder="0" min="0" value="0" required>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <button type="button" class="btn btn-danger btn-block btn-remove-stock" data-stock-id="${stockId}">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        `;

        $('#stok-container').append(html);
    });

    // Handle perubahan pilihan cabang untuk stok
    $(document).on('change', '.stock-branch-select', function() {
        var selectedBranchId = parseInt($(this).val());
        var stockId = $(this).data('stock-id');

        // Hapus branch ID lama jika ada
        var oldBranchId = $(this).data('old-branch-id');
        if (oldBranchId) {
            var index = selectedStockBranches.indexOf(oldBranchId);
            if (index > -1) {
                selectedStockBranches.splice(index, 1);
            }
        }

        // Tambah branch ID baru
        if (selectedBranchId) {
            selectedStockBranches.push(selectedBranchId);
            $(this).data('old-branch-id', selectedBranchId);
        }
    });

    // Handle hapus stok cabang
    $(document).on('click', '.btn-remove-stock', function() {
        var stockId = $(this).data('stock-id');
        var branchSelect = $('#' + stockId).find('.stock-branch-select');
        var branchId = parseInt(branchSelect.val());

        // Hapus dari array selected branches
        if (branchId) {
            var index = selectedStockBranches.indexOf(branchId);
            if (index > -1) {
                selectedStockBranches.splice(index, 1);
            }
        }

        // Hapus card
        $('#' + stockId).remove();
    });

    // Handle Tambah Harga Cabang
    $('#btn-add-price').on('click', function() {
        var availableBranches = getAvailablePriceBranches();

        if (availableBranches.length === 0) {
            alert('Semua cabang sudah ditambahkan!');
            return;
        }

        var currentIndex = priceCounter;
        var priceId = 'price-' + currentIndex;
        priceCounter++;

        var branchOptions = '<option value="">Pilih Cabang</option>';
        availableBranches.forEach(function(branch) {
            branchOptions += '<option value="' + branch.id + '">' + branch.name + '</option>';
        });


        var html = `
            <div class="card mb-3" id="${priceId}">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Cabang <span class="text-danger">*</span></label>
                                <select name="prices[${currentIndex}][branch_id]" class="form-control price-branch-select" data-price-id="${priceId}" required>
                                    ${branchOptions}
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Harga Beli <span class="text-danger">*</span></label>
                                <input type="number" name="prices[${currentIndex}][purchase_price]"
                                    class="form-control" placeholder="0" min="0" step="0.01" value="0" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Harga Jual <span class="text-danger">*</span></label>
                                <input type="number" name="prices[${currentIndex}][selling_price]"
                                    class="form-control" placeholder="0" min="0" step="0.01" value="0" required>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label>&nbsp;</label>
                            <button type="button" class="btn btn-danger btn-block btn-remove-price" data-price-id="${priceId}">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        `;

        $('#harga-container').append(html);
    });

    // Handle perubahan pilihan cabang untuk harga
    $(document).on('change', '.price-branch-select', function() {
        var selectedBranchId = parseInt($(this).val());
        var priceId = $(this).data('price-id');

        // Hapus branch ID lama jika ada
        var oldBranchId = $(this).data('old-branch-id');
        if (oldBranchId) {
            var index = selectedPriceBranches.indexOf(oldBranchId);
            if (index > -1) {
                selectedPriceBranches.splice(index, 1);
            }
        }

        // Tambah branch ID baru
        if (selectedBranchId) {
            selectedPriceBranches.push(selectedBranchId);
            $(this).data('old-branch-id', selectedBranchId);
        }
    });

    // Handle hapus harga cabang
    $(document).on('click', '.btn-remove-price', function() {
        var priceId = $(this).data('price-id');
        var branchSelect = $('#' + priceId).find('.price-branch-select');
        var branchId = parseInt(branchSelect.val());

        // Hapus dari array selected branches
        if (branchId) {
            var index = selectedPriceBranches.indexOf(branchId);
            if (index > -1) {
                selectedPriceBranches.splice(index, 1);
            }
        }

        // Hapus card
        $('#' + priceId).remove();
    });

    // ============================================
    // JAVASCRIPT UNTUK FORM EDIT
    // ============================================

    // Track counters dan selected branches untuk setiap produk edit
    var editStockCounters = {};
    var editPriceCounters = {};
    var editSelectedStockBranches = {};
    var editSelectedPriceBranches = {};

    // Initialize counters saat modal edit dibuka
    $('[id^="modal-edit-"]').on('shown.bs.modal', function() {
        var productId = $(this).find('form').data('product-id');

        // Initialize counters berdasarkan jumlah item yang sudah ada
        if (!editStockCounters[productId]) {
            editStockCounters[productId] = $('#stok-container-' + productId + ' .card').length;
        }
        if (!editPriceCounters[productId]) {
            editPriceCounters[productId] = $('#harga-container-' + productId + ' .card').length;
        }

        // Initialize selected branches
        if (!editSelectedStockBranches[productId]) {
            editSelectedStockBranches[productId] = [];
            $('#stok-container-' + productId + ' .stock-branch-select-edit').each(function() {
                var branchId = parseInt($(this).val());
                if (branchId) {
                    editSelectedStockBranches[productId].push(branchId);
                }
            });
        }

        if (!editSelectedPriceBranches[productId]) {
            editSelectedPriceBranches[productId] = [];
            $('#harga-container-' + productId + ' .price-branch-select-edit').each(function() {
                var branchId = parseInt($(this).val());
                if (branchId) {
                    editSelectedPriceBranches[productId].push(branchId);
                }
            });
        }
    });

    // Fungsi untuk mendapatkan available branches untuk stok edit
    function getAvailableStockBranchesEdit(productId) {
        return branches.filter(function(branch) {
            return !editSelectedStockBranches[productId] || !editSelectedStockBranches[productId].includes(branch.id);
        });
    }

    // Fungsi untuk mendapatkan available branches untuk harga edit
    function getAvailablePriceBranchesEdit(productId) {
        return branches.filter(function(branch) {
            return !editSelectedPriceBranches[productId] || !editSelectedPriceBranches[productId].includes(branch.id);
        });
    }

    // Handle Tambah Stok Cabang Edit
    $(document).on('click', '.btn-add-stock-edit', function() {
        var productId = $(this).data('product-id');
        var availableBranches = getAvailableStockBranchesEdit(productId);

        if (availableBranches.length === 0) {
            alert('Semua cabang sudah ditambahkan!');
            return;
        }

        var currentIndex = editStockCounters[productId];
        var stockId = 'stock-edit-' + productId + '-' + currentIndex;
        editStockCounters[productId]++;

        var branchOptions = '<option value="">Pilih Cabang</option>';
        availableBranches.forEach(function(branch) {
            branchOptions += '<option value="' + branch.id + '">' + branch.name + '</option>';
        });

        var html = `
            <div class="card mb-3" id="${stockId}">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Cabang <span class="text-danger">*</span></label>
                                <select name="stocks[${currentIndex}][branch_id]" class="form-control stock-branch-select-edit" data-stock-id="${stockId}" data-product-id="${productId}" required>
                                    ${branchOptions}
                                </select>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label>Jumlah Stok <span class="text-danger">*</span></label>
                                <input type="number" name="stocks[${currentIndex}][quantity]"
                                    class="form-control" placeholder="0" min="0" required>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <button type="button" class="btn btn-danger btn-block btn-remove-stock-edit" data-stock-id="${stockId}" data-product-id="${productId}">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        `;

        $('#stok-container-' + productId).append(html);
    });

    // Handle perubahan pilihan cabang untuk stok edit
    $(document).on('change', '.stock-branch-select-edit', function() {
        var selectedBranchId = parseInt($(this).val());
        var stockId = $(this).data('stock-id');
        var productId = $(this).data('product-id');

        if (!editSelectedStockBranches[productId]) {
            editSelectedStockBranches[productId] = [];
        }

        // Hapus branch ID lama jika ada
        var oldBranchId = $(this).data('old-branch-id');
        if (oldBranchId) {
            var index = editSelectedStockBranches[productId].indexOf(oldBranchId);
            if (index > -1) {
                editSelectedStockBranches[productId].splice(index, 1);
            }
        }

        // Tambah branch ID baru
        if (selectedBranchId) {
            editSelectedStockBranches[productId].push(selectedBranchId);
            $(this).data('old-branch-id', selectedBranchId);
        }
    });

    // Handle hapus stok cabang edit
    $(document).on('click', '.btn-remove-stock-edit', function() {
        var stockId = $(this).data('stock-id');
        var productId = $(this).data('product-id');
        var branchSelect = $('#' + stockId).find('.stock-branch-select-edit');
        var branchId = parseInt(branchSelect.val());

        if (!editSelectedStockBranches[productId]) {
            editSelectedStockBranches[productId] = [];
        }

        // Hapus dari array selected branches
        if (branchId) {
            var index = editSelectedStockBranches[productId].indexOf(branchId);
            if (index > -1) {
                editSelectedStockBranches[productId].splice(index, 1);
            }
        }

        // Hapus card
        $('#' + stockId).remove();
    });

    // Handle Tambah Harga Cabang Edit
    $(document).on('click', '.btn-add-price-edit', function() {
        var productId = $(this).data('product-id');
        var availableBranches = getAvailablePriceBranchesEdit(productId);

        if (availableBranches.length === 0) {
            alert('Semua cabang sudah ditambahkan!');
            return;
        }

        var currentIndex = editPriceCounters[productId];
        var priceId = 'price-edit-' + productId + '-' + currentIndex;
        editPriceCounters[productId]++;

        var branchOptions = '<option value="">Pilih Cabang</option>';
        availableBranches.forEach(function(branch) {
            branchOptions += '<option value="' + branch.id + '">' + branch.name + '</option>';
        });


        var html = `
            <div class="card mb-3" id="${priceId}">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Cabang <span class="text-danger">*</span></label>
                                <select name="prices[${currentIndex}][branch_id]" class="form-control price-branch-select-edit" data-price-id="${priceId}" data-product-id="${productId}" required>
                                    ${branchOptions}
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Harga Beli <span class="text-danger">*</span></label>
                                <input type="number" name="prices[${currentIndex}][purchase_price]"
                                    class="form-control" placeholder="0" min="0" step="0.01"  required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Harga Jual <span class="text-danger">*</span></label>
                                <input type="number" name="prices[${currentIndex}][selling_price]"
                                    class="form-control" placeholder="0" min="0" step="0.01" required>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label>&nbsp;</label>
                            <button type="button" class="btn btn-danger btn-block btn-remove-price-edit" data-price-id="${priceId}" data-product-id="${productId}">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        `;

        $('#harga-container-' + productId).append(html);
    });

    // Handle perubahan pilihan cabang untuk harga edit
    $(document).on('change', '.price-branch-select-edit', function() {
        var selectedBranchId = parseInt($(this).val());
        var priceId = $(this).data('price-id');
        var productId = $(this).data('product-id');

        if (!editSelectedPriceBranches[productId]) {
            editSelectedPriceBranches[productId] = [];
        }

        // Hapus branch ID lama jika ada
        var oldBranchId = $(this).data('old-branch-id');
        if (oldBranchId) {
            var index = editSelectedPriceBranches[productId].indexOf(oldBranchId);
            if (index > -1) {
                editSelectedPriceBranches[productId].splice(index, 1);
            }
        }

        // Tambah branch ID baru
        if (selectedBranchId) {
            editSelectedPriceBranches[productId].push(selectedBranchId);
            $(this).data('old-branch-id', selectedBranchId);
        }
    });

    // Handle hapus harga cabang edit
    $(document).on('click', '.btn-remove-price-edit', function() {
        var priceId = $(this).data('price-id');
        var productId = $(this).data('product-id');
        var branchSelect = $('#' + priceId).find('.price-branch-select-edit');
        var branchId = parseInt(branchSelect.val());

        if (!editSelectedPriceBranches[productId]) {
            editSelectedPriceBranches[productId] = [];
        }

        // Hapus dari array selected branches
        if (branchId) {
            var index = editSelectedPriceBranches[productId].indexOf(branchId);
            if (index > -1) {
                editSelectedPriceBranches[productId].splice(index, 1);
            }
        }

        // Hapus card
        $('#' + priceId).remove();
    });

    // ============================================
    // SEARCH & FILTER FUNCTIONALITY
    // ============================================

    // Initialize DataTable
    var table = $('#example1').DataTable();

    // Custom search untuk ID atau Nama Produk
    $('#searchProduct').on('keyup', function() {
        table.search(this.value).draw();
    });

    // Filter berdasarkan Kategori
    $('#filterCategory').on('change', function() {
        var selectedCategory = this.value;

        // Column index 2 adalah kolom Kategori (0-based index)
        if (selectedCategory) {
            table.column(2).search('^' + selectedCategory + '$', true, false).draw();
        } else {
            table.column(2).search('').draw();
        }
    });

    // Filter berdasarkan Merek
    $('#filterBrand').on('change', function() {
        var selectedBrand = this.value;

        // Column index 3 adalah kolom Merek (0-based index)
        if (selectedBrand) {
            table.column(3).search('^' + selectedBrand + '$', true, false).draw();
        } else {
            table.column(3).search('').draw();
        }
    });

    // Validasi sebelum submit form edit
    $(document).on('submit', '.form-edit-product', function(e) {
        var form = $(this);
        var productId = form.data('product-id');

        // Validasi: Cabang di stok harus ada di harga, dan sebaliknya
        var stockBranchIds = [];
        var priceBranchIds = [];
        var branchNames = <?php echo json_encode($branches->pluck('name', 'id'), 512) ?>;

        // Ambil semua branch_id dari stok
        $('#stok-container-' + productId + ' .stock-branch-select-edit').each(function() {
            var branchId = $(this).val();
            if (branchId) {
                stockBranchIds.push(parseInt(branchId));
            }
        });

        // Ambil semua branch_id dari harga
        $('#harga-container-' + productId + ' .price-branch-select-edit').each(function() {
            var branchId = $(this).val();
            if (branchId) {
                priceBranchIds.push(parseInt(branchId));
            }
        });

        // Cek cabang yang ada di stok tapi tidak ada di harga
        var missingInPrice = stockBranchIds.filter(function(id) {
            return priceBranchIds.indexOf(id) === -1;
        });

        if (missingInPrice.length > 0) {
            e.preventDefault();
            var missingBranchNames = missingInPrice.map(function(id) {
                return branchNames[id];
            }).join(', ');
            alert('Cabang berikut ada di Tab Stok Barang tapi tidak ada di Tab Harga Cabang: ' + missingBranchNames + '.\n\nSilakan tambahkan harga untuk cabang tersebut.');
            $('#harga-tab-edit-' + productId).tab('show');
            return false;
        }

        // Cek cabang yang ada di harga tapi tidak ada di stok
        var missingInStock = priceBranchIds.filter(function(id) {
            return stockBranchIds.indexOf(id) === -1;
        });

        if (missingInStock.length > 0) {
            e.preventDefault();
            var missingBranchNames = missingInStock.map(function(id) {
                return branchNames[id];
            }).join(', ');
            alert('Cabang berikut ada di Tab Harga Cabang tapi tidak ada di Tab Stok Barang: ' + missingBranchNames + '.\n\nSilakan tambahkan stok untuk cabang tersebut.');
            $('#stok-tab-edit-' + productId).tab('show');
            return false;
        }

        return true;
    });

    // Handle custom file input label untuk modal import
    $('#excel_file').on('change', function() {
        var fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').html(fileName);
    });
});
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/product/product.blade.php ENDPATH**/ ?>