<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laporan Laba Rugi Per Produk</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        .header h2 {
            margin: 5px 0;
            font-size: 16px;
        }
        .header p {
            margin: 3px 0;
            font-size: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        table.bordered {
            border: 1px solid #000;
        }
        table.bordered th,
        table.bordered td {
            border: 1px solid #000;
            padding: 6px 4px;
        }
        table.bordered th {
            background-color: #e0e0e0;
            font-weight: bold;
            font-size: 9px;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .font-bold {
            font-weight: bold;
        }
        .bg-light {
            background-color: #f5f5f5;
        }
        .bg-success {
            background-color: #d4edda;
        }
        .total-row {
            background-color: #d4edda;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <?php
        $logoPath = public_path('logo/logo-umi.png');
        $logoExists = file_exists($logoPath);
    ?>

    <div class="header">
        <div style="
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center;
            width: 100%;
            white-space: nowrap;
        ">
            <?php if($logoExists): ?>
                <img src="<?php echo e($logoPath); ?>"
                    style="
                        height:50px;
                        width:50px;
                        display:inline-block !important;
                        vertical-align: middle;
                        margin-right:10px;
                    ">
            <?php endif; ?>

            <span style="
                font-size:24px;
                font-weight:bold;
                display:inline-block;
                vertical-align: middle;
            ">
                UMI CELL
            </span>
        </div>

        <p>Jl. Raya Semarang-Boja, Jatisari, Kec. Mijen, Kota Semarang Jawa Tengah 50275</p>
        <p>Telp: 0882005564342</p>
    </div>

    <h3 style="text-align: center; margin-bottom: 5px;">LAPORAN LABA RUGI Per PRODUK</h3>
    <p style="text-align: center; margin-top: 0;">
        Periode: <?php echo e(date('d M Y', strtotime($startDate))); ?> - <?php echo e(date('d M Y', strtotime($endDate))); ?><br>
        <?php if($branch): ?>
            Cabang: <?php echo e($branch->name); ?>

        <?php else: ?>
            Cabang: Semua Cabang
        <?php endif; ?>
    </p>

    <table class="bordered">
        <thead>
            <tr>
                <th rowspan="2" style="width: 8%;">Nota</th>
                <th rowspan="2" style="width: 35%;">Nama Item</th>
                <th rowspan="2" style="width: 12%;">Total Jual</th>
                <th rowspan="2" style="width: 13%;">Harga Pokok</th>
                <th rowspan="2" style="width: 10%;">Potongan</th>
                <th colspan="2" style="width: 22%;">Laba</th>
            </tr>
            <tr>
                <th style="width: 13%;">Laba Kotor</th>
                <th style="width: 9%;">Laba %</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $totalJualAll = 0;
                $hargaPokokAll = 0;
                $potonganAll = 0;
                $labaKotorAll = 0;
                $counter = 1;
            ?>
            <?php $__currentLoopData = $productDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="text-center"><?php echo e($counter++); ?></td>
                    <td><?php echo e($detail->product->name ?? 'N/A'); ?> <?php if($detail->product->brand): ?> - <?php echo e($detail->product->brand->name); ?> <?php endif; ?></td>
                    <td class="text-right"><?php echo e(number_format($detail->total_jual, 0, ',', '.')); ?></td>
                    <td class="text-right"><?php echo e(number_format($detail->harga_pokok, 0, ',', '.')); ?></td>
                    <td class="text-right"><?php echo e(number_format($detail->potongan, 0, ',', '.')); ?></td>
                    <td class="text-right"><?php echo e(number_format($detail->laba_kotor, 0, ',', '.')); ?></td>
                    <td class="text-right"><?php echo e(number_format($detail->laba_persen, 2)); ?></td>
                </tr>
                <?php
                    $totalJualAll += $detail->total_jual;
                    $hargaPokokAll += $detail->harga_pokok;
                    $potonganAll += $detail->potongan;
                    $labaKotorAll += $detail->laba_kotor;
                ?>
                <!-- Sub Total -->
                <tr class="bg-light">
                    <td colspan="2" class="text-right font-bold">Sub Total</td>
                    <td class="text-right font-bold"><?php echo e(number_format($detail->total_jual, 0, ',', '.')); ?></td>
                    <td class="text-right font-bold"><?php echo e(number_format($detail->harga_pokok, 0, ',', '.')); ?></td>
                    <td class="text-right font-bold"><?php echo e(number_format($detail->potongan, 0, ',', '.')); ?></td>
                    <td class="text-right font-bold"><?php echo e(number_format($detail->laba_kotor, 0, ',', '.')); ?></td>
                    <td></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <!-- Grand Total -->
            <tr class="total-row">
                <td colspan="2" class="text-right">TOTAL</td>
                <td class="text-right"><?php echo e(number_format($totalJualAll, 0, ',', '.')); ?></td>
                <td class="text-right"><?php echo e(number_format($hargaPokokAll, 0, ',', '.')); ?></td>
                <td class="text-right"><?php echo e(number_format($potonganAll, 0, ',', '.')); ?></td>
                <td class="text-right"><?php echo e(number_format($labaKotorAll, 0, ',', '.')); ?></td>
                <td></td>
            </tr>
        </tbody>
    </table>

    <p style="margin-top: 30px; font-size: 9px; text-align: right;">
        Dicetak pada: <?php echo e(date('d M Y H:i')); ?>

    </p>
</body>
</html>
<?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/report/profit-loss/product-analysis-pdf.blade.php ENDPATH**/ ?>