<?php $__env->startSection('heading', 'Penjualan'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Penjualan</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Penjualan</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Daftar Penjualan</h3>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sales.create')): ?>
                        <div class="card-tools">
                            <a href="<?php echo e(route('sale.create')); ?>" class="btn btn-success btn-sm">
                                <i class="fas fa-plus"></i> Tambah Penjualan
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="card-body">
                        <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endif; ?>

                        <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endif; ?>

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>No. Penjualan</th>
                                    <th>Tanggal</th>
                                    <th>Customer</th>
                                    <th>Cabang</th>
                                    <th>Total</th>
                                    <th>Metode Bayar</th>
                                    <th>Status</th>
                                    <th>Kasir</th>
                                    <th style="width: 15%;">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($sale->sale_number); ?></td>
                                    <td><?php echo e(TanggalID($sale->sale_date)); ?></td>
                                    <td><?php echo e($sale->customer ? $sale->customer->name : 'Umum'); ?></td>
                                    <td><?php echo e($sale->branch->name); ?></td>
                                    <td class="text-right">Rp <?php echo e(number_format($sale->total_amount, 0, ',', '.')); ?></td>
                                    <td>
                                        <?php if($sale->payment_method == 'cash'): ?>
                                        <span class="badge badge-success">Tunai</span>
                                        <?php elseif($sale->payment_method == 'transfer'): ?>
                                        <span class="badge badge-info">Transfer</span>
                                        <?php else: ?>
                                        <span class="badge badge-warning">Kredit</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($sale->status == 'pending'): ?>
                                        <span class="badge badge-warning">Pending</span>
                                        <?php elseif($sale->status == 'completed'): ?>
                                        <span class="badge badge-success">Selesai</span>
                                        <?php else: ?>
                                        <span class="badge badge-danger">Batal</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($sale->cashier->name); ?></td>
                                    <td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sales.index')): ?>
                                        <a href="<?php echo e(route('sale.show', $sale->id)); ?>" class="btn btn-info btn-sm" title="Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sales.edit')): ?>
                                        
                                        <a href="<?php echo e(route('sale.edit', $sale->id)); ?>" class="btn btn-primary btn-sm" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sales.delete')): ?>
                                        
                                        <form action="<?php echo e(route('sale.delete', $sale->id)); ?>" method="POST" style="display:inline;" class="delete-form-<?php echo e($sale->id); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="button" class="btn btn-danger btn-sm delete" data-id="<?php echo e($sale->id); ?>" data-name="Penjualan <?php echo e($sale->sale_number); ?>" title="Hapus">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/transaction/sale/index.blade.php ENDPATH**/ ?>