<?php $__env->startSection('heading', 'Edit Pembelian'); ?>


<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Edit Pembelian</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('purchase')); ?>">Pembelian</a></li>
                    <li class="breadcrumb-item active">Edit</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <form action="<?php echo e(route('purchase.update', $purchase->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="row">
                <!-- ================= LEFT ================= -->
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Detail Produk</h3>
                        </div>
                        <div class="card-body">

                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Produk</th>
                                            <th>Satuan</th>
                                            <th>Qty</th>
                                            <th>Harga</th>
                                            <th>Sub Total</th>
                                        </tr>
                                    </thead>

                                    <tbody id="detailBody">
                                        <?php $__currentLoopData = $purchase->purchaseDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="row-<?php echo e($i); ?>">
                                            <td>
                                                <?php echo e($detail->product->name); ?>

                                                <input type="hidden" name="details[<?php echo e($i); ?>][product_id]" value="<?php echo e($detail->product_id); ?>">
                                            </td>
                                            <td class="text-center"><?php echo e($detail->product->unit); ?></td>
                                            <td>
                                                <input type="number" name="details[<?php echo e($i); ?>][quantity]" class="form-control qty-input" value="<?php echo e($detail->quantity); ?>" min="1">
                                            </td>
                                            <td>
                                                <input type="number" name="details[<?php echo e($i); ?>][purchase_price]" class="form-control price-input" value="<?php echo e($detail->purchase_price); ?>" min="0">
                                            </td>
                                            <td class="text-right subtotal-cell">
                                                <strong class="subtotal-text" data-subtotal="<?php echo e($detail->subtotal); ?>">
                                                    Rp <?php echo e(number_format($detail->subtotal,0,',','.')); ?>

                                                </strong>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>

                <!-- ================= RIGHT ================= -->
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Informasi Pembelian</h3>
                        </div>

                        <div class="card-body">

                            <div class="form-group">
                                <label>No Pembelian</label>
                                <input type="text" class="form-control" value="<?php echo e($purchase->purchase_number); ?>" readonly>
                            </div>

                            <div class="form-group">
                                <label>Supplier</label>
                                <input type="text" class="form-control" value="<?php echo e($purchase->supplier->name); ?>" readonly>
                                <input type="hidden" name="supplier_id" value="<?php echo e($purchase->supplier_id); ?>">
                            </div>

                            <div class="form-group">
                                <label>Cabang</label>
                                <input type="text" class="form-control" value="<?php echo e($purchase->branch->name); ?>" readonly>
                                <input type="hidden" name="branch_id" value="<?php echo e($purchase->branch_id); ?>">
                            </div>

                            <div class="form-group">
                                <label>Tanggal Pembelian</label>
                                <input type="text" class="form-control" value="<?php echo e(\Carbon\Carbon::parse($purchase->purchase_date)->format('d/m/Y')); ?>" readonly>
                                <input type="hidden" name="purchase_date" value="<?php echo e($purchase->purchase_date); ?>">
                            </div>

                            <div class="form-group">
                                <label>Catatan</label>
                                <textarea readonly name="notes" class="form-control"><?php echo e($purchase->notes); ?></textarea>
                            </div>

                            <hr>

                            <div class="form-group">
                                <label>Total Pembelian</label>
                                <h3 class="text-success" id="totalAmount">
                                    Rp <?php echo e(number_format($purchase->total_amount,0,',','.')); ?>

                                </h3>
                            </div>

                        </div>

                        <div class="card-footer">
                            <button type="submit" class="btn btn-success btn-block">
                                <i class="fas fa-save"></i> Update Pembelian
                            </button>
                            <a href="<?php echo e(route('purchase')); ?>" class="btn btn-secondary btn-block">Kembali</a>
                        </div>

                    </div>
                </div>

            </div>
        </form>
    </div>
</section>
<?php $__env->stopSection(); ?>

<!-- ================= Qty dan Sub Total ================= -->
<script>
    function formatRupiah(number) {
        return 'Rp ' + number.toLocaleString('id-ID');
    }

    function updateRowSubtotal(row) {
        const qtyInput = row.querySelector('.qty-input');
        const priceInput = row.querySelector('.price-input');
        const subtotalText = row.querySelector('.subtotal-text');

        const qty = parseFloat(qtyInput.value) || 0;
        const price = parseFloat(priceInput.value) || 0;

        const subtotal = qty * price;

        subtotalText.textContent = formatRupiah(subtotal);
        subtotalText.dataset.subtotal = subtotal;

        updateTotal();
    }

    function updateTotal() {
        let total = 0;

        document.querySelectorAll('.subtotal-text').forEach(el => {
            total += parseFloat(el.dataset.subtotal) || 0;
        });

        document.getElementById('totalAmount').textContent = formatRupiah(total);
    }

    // EVENT LISTENER UNTUK QTY & HARGA
    document.addEventListener('DOMContentLoaded', function () {

        document.querySelectorAll('.qty-input, .price-input').forEach(input => {
            input.addEventListener('input', function () {
                const row = this.closest('tr');
                updateRowSubtotal(row);
            });
        });

    });
</script>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/transaction/purchase/edit.blade.php ENDPATH**/ ?>